/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.picocontainer.Behavior;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.monitors.ComponentMonitorHelper;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterComponentMonitor
implements ComponentMonitor {
    private final PrintWriter out;
    private final ComponentMonitor delegate;

    public WriterComponentMonitor(Writer out) {
        this(out, new NullComponentMonitor());
    }

    public WriterComponentMonitor(Writer out, ComponentMonitor delegate) {
        this.out = new PrintWriter(out);
        this.delegate = delegate;
    }

    @Override
    public <T> Constructor<T> instantiating(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiating {0}", ComponentMonitorHelper.ctorToString(constructor)));
        return this.delegate.instantiating(container, componentAdapter, constructor);
    }

    @Override
    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] injected, long duration) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiated {0} [{1} ms], component {2}, injected [{3}]", ComponentMonitorHelper.ctorToString(constructor), duration, instantiated.getClass().getName(), ComponentMonitorHelper.parmsToString(injected)));
        this.delegate.instantiated(container, componentAdapter, constructor, instantiated, injected, duration);
    }

    @Override
    public <T> void instantiationFailed(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Exception cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiation failed: {0}, reason: {1}", ComponentMonitorHelper.ctorToString(constructor), cause.getMessage()));
        this.delegate.instantiationFailed(container, null, constructor, cause);
    }

    @Override
    public Object invoking(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, Object[] args2) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invoking {0} on {1}", ComponentMonitorHelper.memberToString(member), instance));
        return this.delegate.invoking(container, componentAdapter, member, instance, args2);
    }

    @Override
    public void invoked(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, long duration, Object[] args2, Object retVal) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invoked {0} on {1} [{2} ms]", ComponentMonitorHelper.methodToString(member), instance, duration));
        this.delegate.invoked(container, componentAdapter, member, instance, duration, args2, retVal);
    }

    @Override
    public void invocationFailed(Member member, Object instance, Exception cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invocation failed: {0} on {1}, reason: {2}", ComponentMonitorHelper.memberToString(member), instance, cause.getMessage()));
        this.delegate.invocationFailed(member, instance, cause);
    }

    @Override
    public void lifecycleInvocationFailed(MutablePicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, RuntimeException cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", ComponentMonitorHelper.methodToString(method), instance, cause.getMessage()));
        this.delegate.lifecycleInvocationFailed(container, componentAdapter, method, instance, cause);
    }

    @Override
    public Object noComponentFound(MutablePicoContainer container, Object componentKey) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: No component for key: {0}", componentKey));
        return this.delegate.noComponentFound(container, componentKey);
    }

    @Override
    public Injector newInjector(Injector injector) {
        return this.delegate.newInjector(injector);
    }

    @Override
    public Behavior newBehavior(Behavior behavior) {
        return this.delegate.newBehavior(behavior);
    }
}

