/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.ChunkIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah32.BitCounter32;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.ChunkIteratorImpl32;
import com.googlecode.javaewah32.ClearIntIterator32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.FastAggregation32;
import com.googlecode.javaewah32.IntArray;
import com.googlecode.javaewah32.IntBufferWrapper;
import com.googlecode.javaewah32.IntIteratorImpl32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.NonEmptyVirtualStorage32;
import com.googlecode.javaewah32.ReverseEWAHIterator32;
import com.googlecode.javaewah32.ReverseIntIterator32;
import com.googlecode.javaewah32.RunningLengthWord32;
import com.googlecode.javaewah32.symmetric.RunningBitmapMerge32;
import com.googlecode.javaewah32.symmetric.ThresholdFuncBitmap32;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class EWAHCompressedBitmap32
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage32,
LogicalElement<EWAHCompressedBitmap32> {
    final Buffer32 buffer;
    private RunningLengthWord32 rlw = null;
    private int sizeInBits = 0;
    public static final boolean ADJUST_CONTAINER_SIZE_WHEN_AGGREGATING = true;
    public static final int WORD_IN_BITS = 32;
    static final long serialVersionUID = 1L;

    public EWAHCompressedBitmap32() {
        this(new IntArray());
    }

    public EWAHCompressedBitmap32(int bufferSize) {
        this(new IntArray(bufferSize));
    }

    public EWAHCompressedBitmap32(ByteBuffer buffer) {
        IntBuffer ib = buffer.asIntBuffer();
        this.sizeInBits = ib.get(0);
        int sizeInWords = ib.get(1);
        int rlwposition = ib.get(2 + sizeInWords);
        ib.position(2);
        this.buffer = new IntBufferWrapper(ib.slice(), sizeInWords);
        this.rlw = new RunningLengthWord32(this.buffer, rlwposition);
    }

    public EWAHCompressedBitmap32(IntBuffer buffer) {
        this(new IntBufferWrapper(buffer));
    }

    private EWAHCompressedBitmap32(Buffer32 buffer) {
        this.buffer = buffer;
        this.rlw = new RunningLengthWord32(this.buffer, 0);
    }

    @Deprecated
    public void add(int newData) {
        this.addWord(newData);
    }

    @Deprecated
    public void add(int newData, int bitsThatMatter) {
        this.addWord(newData, bitsThatMatter);
    }

    @Override
    public void addWord(int newData) {
        this.addWord(newData, 32);
    }

    public void addWord(int newData, int bitsThatMatter) {
        this.sizeInBits += bitsThatMatter;
        if (newData == 0) {
            this.insertEmptyWord(false);
        } else if (newData == -1) {
            this.insertEmptyWord(true);
        } else {
            this.insertLiteralWord(newData);
        }
    }

    private void insertEmptyWord(boolean v) {
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        int runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0) {
            this.rlw.setRunningBit(v);
        }
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 65535) {
            this.rlw.setRunningLength(runlen + 1);
            return;
        }
        this.buffer.push_back(0);
        this.rlw.position = this.buffer.sizeInWords() - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1);
    }

    @Override
    public void addLiteralWord(int newData) {
        this.sizeInBits += 32;
        this.insertLiteralWord(newData);
    }

    private void insertLiteralWord(int newData) {
        int numberSoFar = this.rlw.getNumberOfLiteralWords();
        if (numberSoFar >= Short.MAX_VALUE) {
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            this.rlw.setNumberOfLiteralWords(1);
            this.buffer.push_back(newData);
        } else {
            this.rlw.setNumberOfLiteralWords(numberSoFar + 1);
            this.buffer.push_back(newData);
        }
    }

    @Override
    public void addStreamOfLiteralWords(Buffer32 buffer, int start, int number) {
        int leftOverNumber = number;
        while (leftOverNumber > 0) {
            int numberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatWeCanAdd = leftOverNumber < Short.MAX_VALUE - numberOfLiteralWords ? leftOverNumber : Short.MAX_VALUE - numberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(numberOfLiteralWords + whatWeCanAdd);
            this.buffer.push_back(buffer, start, whatWeCanAdd);
            this.sizeInBits += whatWeCanAdd * 32;
            if ((leftOverNumber -= whatWeCanAdd) <= 0) continue;
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, int number) {
        if (number == 0) {
            return;
        }
        this.sizeInBits += number * 32;
        this.fastaddStreamOfEmptyWords(v, number);
    }

    @Override
    public void addStreamOfNegatedLiteralWords(Buffer32 buffer, int start, int number) {
        int leftOverNumber = number;
        while (leftOverNumber > 0) {
            int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatwecanadd = leftOverNumber < Short.MAX_VALUE - NumberOfLiteralWords ? leftOverNumber : Short.MAX_VALUE - NumberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
            this.buffer.negative_push_back(buffer, start, whatwecanadd);
            this.sizeInBits += whatwecanadd * 32;
            if ((leftOverNumber -= whatwecanadd) <= 0) continue;
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    @Override
    public EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 a) {
        int size = this.buffer.sizeInWords() > a.buffer.sizeInWords() ? this.buffer.sizeInWords() : a.buffer.sizeInWords();
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32(size);
        this.andToContainer(a, container);
        return container;
    }

    public void andToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        container.clear();
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    int index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.andToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap32 andNot(EWAHCompressedBitmap32 a) {
        int size = this.buffer.sizeInWords() > a.buffer.sizeInWords() ? this.buffer.sizeInWords() : a.buffer.sizeInWords();
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32(size);
        this.andNotToContainer(a, container);
        return container;
    }

    public void andNotToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        IteratingBufferedRunningLengthWord32 remaining;
        container.clear();
        EWAHIterator32 i = this.getEWAHIterator();
        EWAHIterator32 j = a.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index;
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else if (i_is_prey) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                } else {
                    index = prey.dischargeNegated(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & ~rlwj.getLiteralWordAt(k));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        }
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.andNotToContainer(a, counter);
        return counter.getCount();
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator32 i = this.getEWAHIterator();
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter += 32 * localrlw.getRunningLength();
            }
            int numberOfLiteralWords = localrlw.getNumberOfLiteralWords();
            int literalWords = i.literalWords();
            for (int j = 0; j < numberOfLiteralWords; ++j) {
                counter += Integer.bitCount(i.buffer().getWord(literalWords + j));
            }
        }
        return counter;
    }

    @Override
    public void clear() {
        this.sizeInBits = 0;
        this.buffer.clear();
        this.rlw.position = 0;
    }

    public EWAHCompressedBitmap32 clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap32 clone = new EWAHCompressedBitmap32(this.buffer.clone());
        clone.sizeInBits = this.sizeInBits;
        clone.rlw = new RunningLengthWord32(clone.buffer, this.rlw.position);
        return clone;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeInBits);
        int siw = this.buffer.sizeInWords();
        out.writeInt(siw);
        for (int i = 0; i < siw; ++i) {
            out.writeInt(this.buffer.getWord(i));
        }
        out.writeInt(this.rlw.position);
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeInBits = in.readInt();
        int sizeInWords = in.readInt();
        this.buffer.clear();
        this.buffer.removeLastWord();
        this.buffer.ensureCapacity(sizeInWords);
        for (int i = 0; i < sizeInWords; ++i) {
            this.buffer.push_back(in.readInt());
        }
        this.rlw = new RunningLengthWord32(this.buffer, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap32) {
            try {
                this.xorToContainer((EWAHCompressedBitmap32)o, new NonEmptyVirtualStorage32());
                return true;
            }
            catch (NonEmptyVirtualStorage32.NonEmptyException e) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, int number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
        }
        int runLen = this.rlw.getRunningLength();
        int whatWeCanAdd = number < 65535 - runLen ? number : 65535 - runLen;
        this.rlw.setRunningLength(runLen + whatWeCanAdd);
        number -= whatWeCanAdd;
        while (number >= 65535) {
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(65535);
            number -= 65535;
        }
        if (number > 0) {
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(number);
        }
    }

    public EWAHIterator32 getEWAHIterator() {
        return new EWAHIterator32(this.buffer);
    }

    private ReverseEWAHIterator32 getReverseEWAHIterator() {
        return new ReverseEWAHIterator32(this.buffer);
    }

    public IteratingRLW32 getIteratingRLW() {
        return new IteratingBufferedRunningLengthWord32(this);
    }

    @Deprecated
    public List<Integer> getPositions() {
        return this.toList();
    }

    public List<Integer> toList() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator32 i = this.getEWAHIterator();
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                int N = localrlw.getRunningLength();
                for (j = 0; j < N; ++j) {
                    for (int c = 0; c < 32; ++c) {
                        v.add(pos++);
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            int nlw = localrlw.getNumberOfLiteralWords();
            for (j = 0; j < nlw; ++j) {
                int T;
                for (int data = i.buffer().getWord(i.literalWords() + j); data != 0; data ^= T) {
                    T = data & -data;
                    v.add(Integer.bitCount(T - 1) + pos);
                }
                pos += 32;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeInBits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = -1640531535;
        EWAHIterator32 i = this.getEWAHIterator();
        while (i.hasNext()) {
            i.next();
            if (i.rlw.getRunningBit()) {
                int rl = i.rlw.getRunningLength();
                karprabin += -1640531535 * rl;
            }
            int nlw = i.rlw.getNumberOfLiteralWords();
            int lw = i.literalWords();
            for (int k = 0; k < nlw; ++k) {
                long W = this.buffer.getWord(lw + k);
                karprabin += (int)(-1640531535L * W);
            }
        }
        return karprabin;
    }

    public boolean intersects(EWAHCompressedBitmap32 a) {
        NonEmptyVirtualStorage32 nevs = new NonEmptyVirtualStorage32();
        try {
            this.andToContainer(a, nevs);
        }
        catch (NonEmptyVirtualStorage32.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl32(this.getEWAHIterator());
    }

    public IntIterator reverseIntIterator() {
        return new ReverseIntIterator32(this.getReverseEWAHIterator(), this.sizeInBits);
    }

    public boolean isEmpty() {
        return this.getFirstSetBit() < 0;
    }

    public IntIterator clearIntIterator() {
        return new ClearIntIterator32(this.getEWAHIterator(), this.sizeInBits);
    }

    public ChunkIterator chunkIterator() {
        return new ChunkIteratorImpl32(this.getEWAHIterator(), this.sizeInBits);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap32.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    @Override
    public void not() {
        RunningLengthWord32 rlw1;
        EWAHIterator32 i = this.getEWAHIterator();
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            int nlw = rlw1.getNumberOfLiteralWords();
            for (int j = 0; j < nlw; ++j) {
                i.buffer().negateWord(i.literalWords() + j);
            }
        } while (i.hasNext());
        int usedbitsinlast = this.sizeInBits % 32;
        if (usedbitsinlast == 0) {
            return;
        }
        if (rlw1.getNumberOfLiteralWords() == 0) {
            if (rlw1.getRunningLength() > 0 && rlw1.getRunningBit()) {
                if (rlw1.getRunningLength() == 1 && rlw1.position > 0) {
                    EWAHIterator32 j = this.getEWAHIterator();
                    int newrlwpos = this.rlw.position;
                    while (j.hasNext()) {
                        RunningLengthWord32 r = j.next();
                        if (r.position >= rlw1.position) break;
                        newrlwpos = r.position;
                    }
                    this.rlw.position = newrlwpos;
                    this.buffer.removeLastWord();
                } else {
                    rlw1.setRunningLength(rlw1.getRunningLength() - 1);
                }
                this.insertLiteralWord(-1 >>> 32 - usedbitsinlast);
            }
            return;
        }
        i.buffer().andWord(i.literalWords() + rlw1.getNumberOfLiteralWords() - 1, -1 >>> 32 - usedbitsinlast);
    }

    @Override
    public EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 a) {
        int size = this.buffer.sizeInWords() + a.buffer.sizeInWords();
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32(size);
        this.orToContainer(a, container);
        return container;
    }

    public void orToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        container.clear();
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    int index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) | rlwj.getLiteralWordAt(k));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        if (rlwj.size() > 0 && rlwi.size() > 0) {
            throw new RuntimeException("fds");
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.orToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean get(int i) {
        if (i < 0 || i >= this.sizeInBits) {
            return false;
        }
        IteratingRLW32 j = this.getIteratingRLW();
        int wordi = i / 32;
        for (int wordChecked = 0; wordChecked <= wordi; wordChecked += j.getNumberOfLiteralWords()) {
            if (wordi < (wordChecked += j.getRunningLength())) {
                return j.getRunningBit();
            }
            if (wordi < wordChecked + j.getNumberOfLiteralWords()) {
                int w = j.getLiteralWordAt(wordi - wordChecked);
                return (w & 1 << i) != 0;
            }
            j.next();
        }
        return false;
    }

    public int getFirstSetBit() {
        int nword = 0;
        int siw = this.buffer.sizeInWords();
        for (int pos = 0; pos < siw; ++pos) {
            int rl = RunningLengthWord32.getRunningLength(this.buffer, pos);
            boolean rb = RunningLengthWord32.getRunningBit(this.buffer, pos);
            if (rl > 0 && rb) {
                return nword * 32;
            }
            nword += rl;
            int lw = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, pos);
            for (int p = pos + 1; p <= pos + lw; ++p) {
                int word = this.buffer.getWord(p);
                if ((long)word != 0L) {
                    int T = word & -word;
                    return nword * 32 + Integer.bitCount(T - 1);
                }
                ++nword;
            }
        }
        return -1;
    }

    public boolean clear(int i) {
        return this.set(i, false);
    }

    public boolean set(int i) {
        return this.set(i, true);
    }

    private boolean set(int i, boolean value) {
        if (i > 0x7FFFFFDF || i < 0) {
            throw new IndexOutOfBoundsException("Position should be between 0 and 2147483615");
        }
        if (i < this.sizeInBits) {
            this.locateAndSet(i, value);
        } else {
            this.extendAndSet(i, value);
        }
        return true;
    }

    private void extendAndSet(int i, boolean value) {
        int dist = this.distanceInWords(i);
        this.sizeInBits = i + 1;
        if (value) {
            if (dist > 0) {
                if (this.rlw.getNumberOfLiteralWords() > 0 && this.buffer.getLastWord() == 0) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(false);
                }
                if (dist > 1) {
                    this.fastaddStreamOfEmptyWords(false, dist - 1);
                }
                this.insertLiteralWord(1 << i % 32);
            }
            if (this.rlw.getNumberOfLiteralWords() == 0) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
                this.insertLiteralWord(1 << i % 32);
            }
            this.buffer.orLastWord(1 << i % 32);
            if (this.buffer.getLastWord() == -1) {
                this.buffer.removeLastWord();
                this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                this.insertEmptyWord(true);
            }
        } else if (dist > 0) {
            this.fastaddStreamOfEmptyWords(false, dist);
        }
    }

    private void locateAndSet(int i, boolean value) {
        int lw;
        int nbits = 0;
        int siw = this.buffer.sizeInWords();
        for (int pos = 0; pos < siw; pos += lw + 1) {
            int rl = RunningLengthWord32.getRunningLength(this.buffer, pos);
            boolean rb = RunningLengthWord32.getRunningBit(this.buffer, pos);
            lw = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, pos);
            int rbits = rl * 32;
            if (i < nbits + rbits) {
                this.setInRunningLength(value, i, nbits, pos, rl, rb, lw);
                return;
            }
            int lbits = lw * 32;
            if (i < (nbits += rbits) + lbits) {
                this.setInLiteralWords(value, i, nbits, pos, rl, rb, lw);
                return;
            }
            nbits += lbits;
        }
    }

    private void setInRunningLength(boolean value, int i, int nbits, int pos, int rl, boolean rb, int lw) {
        if (value != rb) {
            int wordPosition = (i - nbits) / 32 + 1;
            int addedWords = wordPosition == rl ? 1 : 2;
            this.buffer.expand(pos + 1, addedWords);
            int mask = 1 << i % 32;
            this.buffer.setWord(pos + 1, value ? mask : ~mask);
            if (this.rlw.position >= pos + 1) {
                this.rlw.position += addedWords;
            }
            if (addedWords == 1) {
                this.setRLWInfo(pos, rb, rl - 1, lw + 1);
            } else {
                this.setRLWInfo(pos, rb, wordPosition - 1, 1);
                this.setRLWInfo(pos + 2, rb, rl - wordPosition, lw);
                if (this.rlw.position == pos) {
                    this.rlw.position += 2;
                }
            }
        }
    }

    private void setInLiteralWords(boolean value, int i, int nbits, int pos, int rl, boolean rb, int lw) {
        int emptyWord;
        int wordPosition = (i - nbits) / 32 + 1;
        int mask = 1 << i % 32;
        if (value) {
            this.buffer.orWord(pos + wordPosition, mask);
        } else {
            this.buffer.andWord(pos + wordPosition, ~mask);
        }
        int n = emptyWord = value ? -1 : 0;
        if (this.buffer.getWord(pos + wordPosition) == emptyWord) {
            boolean canMergeInCurrentRLW = this.mergeLiteralWordInCurrentRunningLength(value, rb, rl, wordPosition);
            boolean canMergeInNextRLW = this.mergeLiteralWordInNextRunningLength(value, lw, pos, wordPosition);
            if (canMergeInCurrentRLW && canMergeInNextRLW) {
                int nextRl = RunningLengthWord32.getRunningLength(this.buffer, pos + 2);
                int nextLw = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, pos + 2);
                this.buffer.collapse(pos, 2);
                this.setRLWInfo(pos, value, rl + 1 + nextRl, nextLw);
                if (this.rlw.position >= pos + 2) {
                    this.rlw.position -= 2;
                }
            } else if (canMergeInCurrentRLW) {
                this.buffer.collapse(pos + 1, 1);
                this.setRLWInfo(pos, value, rl + 1, lw - 1);
                if (this.rlw.position >= pos + 2) {
                    --this.rlw.position;
                }
            } else if (canMergeInNextRLW) {
                int nextRLWPos = pos + lw + 1;
                int nextRl = RunningLengthWord32.getRunningLength(this.buffer, nextRLWPos);
                int nextLw = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, nextRLWPos);
                this.buffer.collapse(pos + wordPosition, 1);
                this.setRLWInfo(pos, rb, rl, lw - 1);
                this.setRLWInfo(pos + wordPosition, value, nextRl + 1, nextLw);
                if (this.rlw.position >= nextRLWPos) {
                    this.rlw.position -= lw + 1 - wordPosition;
                }
            } else {
                this.setRLWInfo(pos, rb, rl, wordPosition - 1);
                this.setRLWInfo(pos + wordPosition, value, 1, lw - wordPosition);
                if (this.rlw.position == pos) {
                    this.rlw.position += wordPosition;
                }
            }
        }
    }

    private boolean mergeLiteralWordInCurrentRunningLength(boolean value, boolean rb, int rl, int wordPosition) {
        return (value == rb || rl == 0) && wordPosition == 1;
    }

    private boolean mergeLiteralWordInNextRunningLength(boolean value, int lw, int pos, int wordPosition) {
        int nextRLWPos = pos + lw + 1;
        if (lw == wordPosition && nextRLWPos < this.buffer.sizeInWords()) {
            int nextRl = RunningLengthWord32.getRunningLength(this.buffer, nextRLWPos);
            boolean nextRb = RunningLengthWord32.getRunningBit(this.buffer, nextRLWPos);
            return value == nextRb || nextRl == 0;
        }
        return false;
    }

    private void setRLWInfo(int pos, boolean rb, int rl, int lw) {
        RunningLengthWord32.setRunningBit(this.buffer, pos, rb);
        RunningLengthWord32.setRunningLength(this.buffer, pos, rl);
        RunningLengthWord32.setNumberOfLiteralWords(this.buffer, pos, lw);
    }

    @Override
    public void setSizeInBitsWithinLastWord(int size) {
        if ((size + 32 - 1) / 32 > (this.sizeInBits + 32 - 1) / 32) {
            this.setSizeInBits(size, false);
            return;
        }
        if ((size + 32 - 1) / 32 != (this.sizeInBits + 32 - 1) / 32) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInbits(int,boolean): " + size + " " + this.sizeInBits);
        }
        this.sizeInBits = size;
        int usedBitsInLast = this.sizeInBits % 32;
        if (usedBitsInLast == 0) {
            return;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            if (this.rlw.getRunningLength() > 0) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
                int word = this.rlw.getRunningBit() ? -1 >>> 32 - usedBitsInLast : 0;
                this.insertLiteralWord(word);
            }
            return;
        }
        this.buffer.andLastWord(-1 >>> 32 - usedBitsInLast);
    }

    public boolean setSizeInBits(int size, boolean defaultValue) {
        if (size <= this.sizeInBits) {
            return false;
        }
        if (this.sizeInBits % 32 != 0) {
            if (!defaultValue) {
                if (this.rlw.getNumberOfLiteralWords() > 0) {
                    int bitsToAdd = size - this.sizeInBits;
                    int usedBitsInLast = this.sizeInBits % 32;
                    int freeBitsInLast = 32 - usedBitsInLast;
                    if (this.buffer.getLastWord() == 0) {
                        this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                        this.buffer.removeLastWord();
                        this.sizeInBits -= usedBitsInLast;
                    } else if (usedBitsInLast > 0) {
                        this.sizeInBits += Math.min(bitsToAdd, freeBitsInLast);
                    }
                }
            } else {
                if (this.rlw.getNumberOfLiteralWords() == 0) {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
                    this.insertLiteralWord(0);
                }
                int maskWidth = Math.min(32 - this.sizeInBits % 32, size - this.sizeInBits);
                int maskShift = this.sizeInBits % 32;
                int mask = -1 >>> 32 - maskWidth << maskShift;
                this.buffer.orLastWord(mask);
                if (this.buffer.getLastWord() == -1) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(true);
                }
                this.sizeInBits += maskWidth;
            }
        }
        this.addStreamOfEmptyWords(defaultValue, size / 32 - this.sizeInBits / 32);
        if (this.sizeInBits < size) {
            int dist = this.distanceInWords(size - 1);
            if (dist > 0) {
                this.insertLiteralWord(0);
            }
            if (defaultValue) {
                int maskWidth = size - this.sizeInBits;
                int maskShift = this.sizeInBits % 32;
                int mask = -1 >>> 32 - maskWidth << maskShift;
                this.buffer.orLastWord(mask);
            }
            this.sizeInBits = size;
        }
        return true;
    }

    private int distanceInWords(int i) {
        return (i + 32) / 32 - (this.sizeInBits + 32 - 1) / 32;
    }

    @Override
    public int sizeInBits() {
        return this.sizeInBits;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.sizeInWords() * 4;
    }

    public static EWAHCompressedBitmap32 threshold(int t, EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        EWAHCompressedBitmap32.thresholdWithContainer(container, t, bitmaps);
        return container;
    }

    static int maxSizeInBits(EWAHCompressedBitmap32 ... bitmaps) {
        int maxSizeInBits = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            maxSizeInBits = Math.max(maxSizeInBits, bitmap.sizeInBits());
        }
        return maxSizeInBits;
    }

    public static void thresholdWithContainer(BitmapStorage32 container, int t, EWAHCompressedBitmap32 ... bitmaps) {
        new RunningBitmapMerge32().symmetric(new ThresholdFuncBitmap32(t), container, bitmaps);
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inanspos = 0;
        int pos = 0;
        EWAHIterator32 i = this.getEWAHIterator();
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            int runningLength = localrlw.getRunningLength();
            if (localrlw.getRunningBit()) {
                for (int j = 0; j < runningLength; ++j) {
                    for (int c = 0; c < 32; ++c) {
                        ans[inanspos++] = pos++;
                    }
                }
            } else {
                pos += 32 * runningLength;
            }
            int numberOfLiteralWords = localrlw.getNumberOfLiteralWords();
            int literalWords = i.literalWords();
            for (int j = 0; j < numberOfLiteralWords; ++j) {
                int t;
                for (int data = i.buffer().getWord(literalWords + j); data != 0; data ^= t) {
                    t = data & -data;
                    ans[inanspos++] = Integer.bitCount(t - 1) + pos;
                }
                pos += 32;
            }
        }
        return ans;
    }

    public String toDebugString() {
        StringBuilder ans = new StringBuilder();
        ans.append("{\"size in bits\":");
        ans.append(this.sizeInBits).append(", \"size in words\":");
        ans.append(this.buffer.sizeInWords()).append(",");
        EWAHIterator32 i = this.getEWAHIterator();
        ans.append(" \"content\": [");
        boolean first = true;
        while (i.hasNext()) {
            int data;
            RunningLengthWord32 localrlw = i.next();
            if (!first) {
                ans.append(",");
            }
            first = false;
            ans.append("[");
            if (localrlw.getRunningBit()) {
                ans.append(localrlw.getRunningLength()).append(",").append(" \"1x11\", ");
            } else {
                ans.append(localrlw.getRunningLength()).append(",").append(" \"0x00\", ");
            }
            ans.append("[");
            int j = 0;
            while (j + 1 < localrlw.getNumberOfLiteralWords()) {
                data = i.buffer().getWord(i.literalWords() + j);
                ans.append("\"0x").append(Integer.toHexString(data)).append("\",");
                ++j;
            }
            if (j < localrlw.getNumberOfLiteralWords()) {
                data = i.buffer().getWord(i.literalWords() + j);
                ans.append("\"0x").append(Integer.toHexString(data)).append("\"");
            }
            ans.append("]]");
        }
        ans.append("]}");
        return ans.toString();
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.intIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void swap(EWAHCompressedBitmap32 other) {
        this.buffer.swap(other.buffer);
        int tmp2 = this.rlw.position;
        this.rlw.position = other.rlw.position;
        other.rlw.position = tmp2;
        int tmp3 = this.sizeInBits;
        this.sizeInBits = other.sizeInBits;
        other.sizeInBits = tmp3;
    }

    public void trim() {
        this.buffer.trim();
    }

    @Override
    public EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 a) {
        int size = this.buffer.sizeInWords() + a.buffer.sizeInWords();
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32(size);
        this.xorToContainer(a, container);
        return container;
    }

    public void xorToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        container.clear();
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 predator = i_is_prey ? rlwj : rlwi;
                int index = !predator.getRunningBit() ? prey.discharge(container, predator.getRunningLength()) : prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(predator.getRunningBit(), predator.getRunningLength() - index);
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.xorToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap32 compose(EWAHCompressedBitmap32 a) {
        int size = this.buffer.sizeInWords();
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32(size);
        this.composeToContainer(a, container);
        return container;
    }

    public void composeToContainer(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 container) {
        container.clear();
        ChunkIterator iterator2 = this.chunkIterator();
        ChunkIterator aIterator = a.chunkIterator();
        int index = 0;
        while (iterator2.hasNext() && aIterator.hasNext()) {
            int length;
            if (!iterator2.nextBit()) {
                length = iterator2.nextLength();
                container.setSizeInBits(index += length, false);
                iterator2.move(length);
                continue;
            }
            length = Math.min(iterator2.nextLength(), aIterator.nextLength());
            container.setSizeInBits(index += length, aIterator.nextBit());
            iterator2.move(length);
            aIterator.move(length);
        }
        container.setSizeInBits(this.sizeInBits, false);
    }

    public static void andWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            throw new IllegalArgumentException("Need at least one bitmap");
        }
        if (bitmaps.length == 2) {
            bitmaps[0].andToContainer(bitmaps[1], container);
            return;
        }
        int initialSize = EWAHCompressedBitmap32.calculateInitialSize(bitmaps);
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32(initialSize);
        EWAHCompressedBitmap32 tmp = new EWAHCompressedBitmap32(initialSize);
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length - 1; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        answer.andToContainer(bitmaps[bitmaps.length - 1], container);
    }

    private static int calculateInitialSize(EWAHCompressedBitmap32 ... bitmaps) {
        int initialSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            initialSize = Math.max(bitmap.buffer.sizeInWords(), initialSize);
        }
        return initialSize;
    }

    public static EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].and(bitmaps[1]);
        }
        int initialSize = EWAHCompressedBitmap32.calculateInitialSize(bitmaps);
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32(initialSize);
        EWAHCompressedBitmap32 tmp = new EWAHCompressedBitmap32(initialSize);
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        return answer;
    }

    public static int andCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.andWithContainer(counter, bitmaps);
        return counter.getCount();
    }

    public static EWAHCompressedBitmap32 bitmapOf(int ... setbits) {
        EWAHCompressedBitmap32 a = new EWAHCompressedBitmap32();
        for (int k : setbits) {
            a.set(k);
        }
        return a;
    }

    public static void orWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        FastAggregation32.orToContainer(container, bitmaps);
    }

    public static void xorWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        FastAggregation32.xorToContainer(container, bitmaps);
    }

    public static EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 ... bitmaps) {
        return FastAggregation32.or(bitmaps);
    }

    public static EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 ... bitmaps) {
        return FastAggregation32.xor(bitmaps);
    }

    public static int orCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.orWithContainer(counter, bitmaps);
        return counter.getCount();
    }

    public EWAHCompressedBitmap32 shift(int b) {
        if (b < 0) {
            throw new IllegalArgumentException("Negative shifts unsupported at the moment.");
        }
        int sz = this.buffer.sizeInWords();
        int newsz = b > 0 ? sz + (b + 31) / 32 : sz;
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32(newsz);
        IteratingRLW32 i = this.getIteratingRLW();
        int fullwords = b / 32;
        int shift = b % 32;
        answer.addStreamOfEmptyWords(false, fullwords);
        if (shift == 0) {
            do {
                int rl;
                if ((rl = i.getRunningLength()) > 0) {
                    answer.addStreamOfEmptyWords(i.getRunningBit(), rl);
                }
                int x = i.getNumberOfLiteralWords();
                for (int k = 0; k < x; ++k) {
                    answer.addWord(i.getLiteralWordAt(k));
                }
            } while (i.next());
        } else {
            boolean shiftextension;
            int w = 0;
            do {
                int rl = i.getRunningLength();
                boolean bl = shiftextension = (this.sizeInBits + 32 - 1) % 32 + shift >= 32;
                if (rl > 0) {
                    if (i.getRunningBit()) {
                        int sw = w | -1 << shift;
                        answer.addWord(sw);
                        w = -1 >>> 32 - shift;
                    } else {
                        answer.addWord(w);
                        w = 0;
                    }
                    if (rl > 1) {
                        answer.addStreamOfEmptyWords(i.getRunningBit(), rl - 1);
                    }
                }
                int x = i.getNumberOfLiteralWords();
                for (int k = 0; k < x; ++k) {
                    int neww = i.getLiteralWordAt(k);
                    int sw = w | neww << shift;
                    answer.addWord(sw);
                    w = neww >>> 32 - shift;
                }
            } while (i.next());
            if (shiftextension) {
                answer.addWord(w);
            }
        }
        answer.sizeInBits = this.sizeInBits + b;
        return answer;
    }
}

