/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetInsertStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbCopy
extends SvnWcDbShared {
    public static void copyFile(SVNWCDbDir pdh, File localRelpath, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, File originalReposRelPath, SVNURL originalRootUrl, String originalUuid, long originalRevision, SvnChecksum checksum, boolean updateActualProps, SVNProperties newActualProps, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        SVNWCDb.InsertWorking iw = new SVNWCDb.InsertWorking(pdh.getWCRoot().getDb());
        iw.status = ISVNWCDb.SVNWCDbStatus.Normal;
        iw.kind = ISVNWCDb.SVNWCDbKind.File;
        iw.props = props;
        iw.changedAuthor = changedAuthor;
        iw.changedDate = changedDate;
        iw.changedRev = changedRev;
        if (originalRootUrl != null) {
            long reposId;
            iw.originalReposId = reposId = pdh.getWCRoot().getDb().createReposId(pdh.getWCRoot().getSDb(), originalRootUrl, originalUuid);
            iw.originalReposRelPath = originalReposRelPath;
            iw.originalRevision = originalRevision;
        }
        long[] depths = SvnWcDbCopy.getOpDepthForCopy(pdh.getWCRoot(), localRelpath, iw.originalReposId, originalReposRelPath, originalRevision);
        iw.opDepth = depths[0];
        iw.notPresentOpDepth = depths[1];
        iw.checksum = checksum;
        iw.workItems = workItems;
        if (updateActualProps) {
            iw.updateActualProps = true;
            iw.newActualProps = newActualProps;
        }
        iw.conflict = conflict;
        iw.wcRoot = pdh.getWCRoot();
        iw.localRelpath = localRelpath;
        pdh.getWCRoot().getSDb().runTransaction(iw);
        pdh.flushEntries(pdh.getWCRoot().getAbsPath());
    }

    public static void copyDir(SVNWCDbDir pdh, File localRelpath, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, File originalReposRelPath, SVNURL originalRootUrl, String originalUuid, long originalRevision, List<File> children, boolean isMove, SVNDepth depth, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        SVNWCDb.InsertWorking iw = new SVNWCDb.InsertWorking(pdh.getWCRoot().getDb());
        iw.status = ISVNWCDb.SVNWCDbStatus.Normal;
        iw.kind = ISVNWCDb.SVNWCDbKind.Dir;
        iw.props = props;
        iw.changedAuthor = changedAuthor;
        iw.changedDate = changedDate;
        iw.changedRev = changedRev;
        if (originalRootUrl != null) {
            long reposId;
            iw.originalReposId = reposId = pdh.getWCRoot().getDb().createReposId(pdh.getWCRoot().getSDb(), originalRootUrl, originalUuid);
            iw.originalReposRelPath = originalReposRelPath;
            iw.originalRevision = originalRevision;
        }
        long[] depths = SvnWcDbCopy.getOpDepthForCopy(pdh.getWCRoot(), localRelpath, iw.originalReposId, originalReposRelPath, originalRevision);
        iw.opDepth = depths[0];
        iw.notPresentOpDepth = depths[1];
        iw.children = children;
        iw.depth = depth;
        iw.workItems = workItems;
        iw.movedHere = isMove && (depths[2] == 0L || iw.opDepth == depths[2]);
        iw.conflict = conflict;
        iw.wcRoot = pdh.getWCRoot();
        iw.localRelpath = localRelpath;
        pdh.getWCRoot().getSDb().runTransaction(iw);
        pdh.flushEntries(pdh.getWCRoot().getAbsPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyShadowedLayer(SVNWCDbDir srcPdh, File srcRelpath, long srcOpDepth, SVNWCDbDir dstPdh, File dstRelpath, long dstOpDepth, long delOpDepth, long reposId, File reposRelPath, long revision, int moveOpDepth) throws SVNException {
        Structure<StructureFields.NodeInfo> depthInfo = null;
        try {
            depthInfo = SvnWcDbReader.getDepthInfo(srcPdh.getWCRoot(), srcRelpath, srcOpDepth, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            return;
        }
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)depthInfo.get(StructureFields.NodeInfo.status));
        if (srcOpDepth == 0L) {
            long nodeRevision = depthInfo.lng(StructureFields.NodeInfo.revision);
            long nodeReposId = depthInfo.lng(StructureFields.NodeInfo.reposId);
            File nodeReposRelPath = (File)depthInfo.get(StructureFields.NodeInfo.reposRelPath);
            if (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || nodeRevision != revision || nodeReposId != reposId || !nodeReposRelPath.equals(reposRelPath)) {
                SVNWCDb.ReposInfo reposInfo = srcPdh.getWCRoot().getDb().fetchReposInfo(srcPdh.getWCRoot().getSDb(), nodeReposId);
                nodeReposId = dstPdh.getWCRoot().getDb().createReposId(dstPdh.getWCRoot().getSDb(), SVNURL.parseURIEncoded(reposInfo.reposRootUrl), reposInfo.reposUuid);
                SVNWCDb.InsertWorking iw = new SVNWCDb.InsertWorking(dstPdh.getWCRoot().getDb());
                iw.opDepth = dstOpDepth;
                iw.status = status != ISVNWCDb.SVNWCDbStatus.Excluded ? ISVNWCDb.SVNWCDbStatus.NotPresent : ISVNWCDb.SVNWCDbStatus.Excluded;
                iw.kind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
                iw.originalReposId = nodeReposId;
                iw.originalRevision = nodeRevision;
                iw.originalReposRelPath = nodeReposRelPath;
                iw.changedRev = -1L;
                iw.depth = SVNDepth.INFINITY;
                iw.wcRoot = dstPdh.getWCRoot();
                iw.localRelpath = dstRelpath;
                dstPdh.getWCRoot().getSDb().runTransaction(iw);
                return;
            }
        }
        ISVNWCDb.SVNWCDbStatus dstPresence = null;
        switch (status) {
            case Normal: 
            case Added: 
            case MovedHere: 
            case Copied: {
                dstPresence = ISVNWCDb.SVNWCDbStatus.Normal;
                break;
            }
            case Deleted: 
            case NotPresent: {
                dstPresence = ISVNWCDb.SVNWCDbStatus.NotPresent;
                break;
            }
            case Excluded: {
                dstPresence = ISVNWCDb.SVNWCDbStatus.Excluded;
                break;
            }
            case ServerExcluded: {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot copy ''{0}'' excluded by server", (Object)srcPdh.getWCRoot().getAbsPath(srcRelpath));
                SVNErrorManager.error(err, SVNLogType.WC);
                break;
            }
            default: {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot handle status of ''{0}''", (Object)srcPdh.getWCRoot().getAbsPath(srcRelpath));
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
        }
        if (dstPresence == ISVNWCDb.SVNWCDbStatus.Normal && srcPdh.getWCRoot().getSDb() == dstPdh.getWCRoot().getSDb()) {
            InsertWorkingNodeCopy stmt = new InsertWorkingNodeCopy(srcPdh.getWCRoot().getSDb(), srcOpDepth);
            try {
                stmt.bindf("issisti", srcPdh.getWCRoot().getWcId(), srcRelpath, dstRelpath, dstOpDepth, SVNFileUtil.getFileDir(dstRelpath), SvnWcDbStatementUtil.getPresenceText(dstPresence), srcOpDepth);
                if (dstOpDepth == (long)moveOpDepth) {
                    stmt.bindLong(7, 1L);
                }
                stmt.done();
            }
            finally {
                ((SVNSqlJetStatement)stmt).reset();
            }
            SVNWCDb.InsertWorking iw = new SVNWCDb.InsertWorking(dstPdh.getWCRoot().getDb());
            iw.opDepth = delOpDepth;
            iw.status = ISVNWCDb.SVNWCDbStatus.BaseDeleted;
            iw.kind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
            iw.changedRev = -1L;
            iw.depth = SVNDepth.INFINITY;
            iw.wcRoot = dstPdh.getWCRoot();
            iw.localRelpath = dstRelpath;
            dstPdh.getWCRoot().getSDb().runTransaction(iw);
        } else {
            if (dstPresence == ISVNWCDb.SVNWCDbStatus.Normal) {
                dstPresence = ISVNWCDb.SVNWCDbStatus.NotPresent;
            }
            SVNWCDb.InsertWorking iw = new SVNWCDb.InsertWorking(dstPdh.getWCRoot().getDb());
            iw.opDepth = dstOpDepth;
            iw.status = dstPresence;
            iw.kind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
            iw.changedRev = -1L;
            iw.depth = SVNDepth.INFINITY;
            iw.wcRoot = dstPdh.getWCRoot();
            iw.localRelpath = dstRelpath;
            dstPdh.getWCRoot().getSDb().runTransaction(iw);
        }
        List<String> children = srcPdh.getWCRoot().getDb().gatherRepoChildren(srcPdh.getWCRoot(), srcRelpath, srcOpDepth);
        for (String name : children) {
            File srcChildRelpath = SVNFileUtil.createFilePath(srcRelpath, name);
            File dstChildRelpath = SVNFileUtil.createFilePath(dstRelpath, name);
            File childReposRelPath = null;
            if (reposRelPath != null) {
                childReposRelPath = SVNFileUtil.createFilePath(reposRelPath, name);
            }
            SvnWcDbCopy.copyShadowedLayer(srcPdh, srcChildRelpath, srcOpDepth, dstPdh, dstChildRelpath, dstOpDepth, delOpDepth, reposId, childReposRelPath, revision, moveOpDepth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyShadowedLayer(SVNWCDbDir srcPdh, File localSrcRelpath, SVNWCDbDir dstPdh, File localDstRelpath, boolean isMove) throws SVNException {
        boolean dstLocked = false;
        SvnWcDbCopy.begingWriteTransaction(srcPdh.getWCRoot());
        try {
            if (srcPdh.getWCRoot().getSDb() != dstPdh.getWCRoot().getSDb()) {
                SvnWcDbCopy.begingWriteTransaction(dstPdh.getWCRoot());
                dstLocked = true;
            }
            File srcParentRelPath = SVNFileUtil.getFileDir(localSrcRelpath);
            File dstParentRelPath = SVNFileUtil.getFileDir(localDstRelpath);
            long srcOpDepth = SvnWcDbCopy.getOpDepthOf(srcPdh.getWCRoot(), srcParentRelPath);
            long dstOpDepth = SvnWcDbCopy.getOpDepthOf(dstPdh.getWCRoot(), dstParentRelPath);
            long delOpDepth = SVNWCUtils.relpathDepth(localDstRelpath);
            Structure<StructureFields.NodeInfo> depthInfo = SvnWcDbReader.getDepthInfo(srcPdh.getWCRoot(), srcParentRelPath, srcOpDepth, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId);
            File reposRelpath = (File)depthInfo.get(StructureFields.NodeInfo.reposRelPath);
            if (reposRelpath == null) {
                return;
            }
            reposRelpath = SVNFileUtil.createFilePath(reposRelpath, SVNFileUtil.getFileName(localSrcRelpath));
            SvnWcDbCopy.copyShadowedLayer(srcPdh, localSrcRelpath, srcOpDepth, dstPdh, localDstRelpath, dstOpDepth, delOpDepth, depthInfo.lng(StructureFields.NodeInfo.reposId), reposRelpath, depthInfo.lng(StructureFields.NodeInfo.revision), isMove ? (int)dstOpDepth : 0);
            depthInfo.release();
        }
        catch (SVNException e) {
            try {
                SvnWcDbCopy.rollbackTransaction(srcPdh.getWCRoot());
            }
            finally {
                if (dstLocked) {
                    SvnWcDbCopy.rollbackTransaction(dstPdh.getWCRoot());
                }
            }
        }
        finally {
            try {
                SvnWcDbCopy.commitTransaction(srcPdh.getWCRoot());
            }
            finally {
                if (dstLocked) {
                    SvnWcDbCopy.commitTransaction(dstPdh.getWCRoot());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(SVNWCDbDir srcPdh, File localSrcRelpath, SVNWCDbDir dstPdh, File localDstRelpath, File dstOpRootRelPath, boolean isMove, SVNSkel workItems) throws SVNException {
        boolean dstLocked = false;
        SvnWcDbCopy.begingWriteTransaction(srcPdh.getWCRoot());
        try {
            if (srcPdh.getWCRoot().getSDb() != dstPdh.getWCRoot().getSDb()) {
                SvnWcDbCopy.begingWriteTransaction(dstPdh.getWCRoot());
                dstLocked = true;
            }
            SvnWcDbCopy.doCopy(srcPdh, localSrcRelpath, dstPdh, localDstRelpath, dstOpRootRelPath, isMove, workItems);
        }
        catch (SVNException e) {
            try {
                SvnWcDbCopy.rollbackTransaction(srcPdh.getWCRoot());
            }
            finally {
                if (dstLocked) {
                    SvnWcDbCopy.rollbackTransaction(dstPdh.getWCRoot());
                }
            }
        }
        finally {
            try {
                SvnWcDbCopy.commitTransaction(srcPdh.getWCRoot());
            }
            finally {
                if (dstLocked) {
                    SvnWcDbCopy.commitTransaction(dstPdh.getWCRoot());
                }
            }
        }
    }

    public static SVNNodeKind readKind(ISVNWCDb db, File path, boolean showDeleted, boolean showHidden) throws SVNException {
        SVNNodeKind kind = db.readKind(path, true, showDeleted, showHidden);
        return kind == SVNNodeKind.UNKNOWN ? SVNNodeKind.NONE : kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void doCopy(SVNWCDbDir srcPdh, File localSrcRelpath, SVNWCDbDir dstPdh, File localDstRelpath, File dstOpRootRelPath, boolean isMove, SVNSkel workItems) throws SVNException {
        moveOpDepth = isMove != false ? SVNWCUtils.relpathDepth(dstOpRootRelPath) : 0;
        copyInfo = SvnWcDbCopy.getCopyInfo(srcPdh.getWCRoot(), localSrcRelpath);
        copyFromRelpath = (File)copyInfo.get(CopyInfo.copyFromRelpath);
        dstOpDepths = SvnWcDbCopy.getOpDepthForCopy(dstPdh.getWCRoot(), localDstRelpath, copyInfo.lng(CopyInfo.copyFromId), copyFromRelpath, copyInfo.lng(CopyInfo.copyFromRev));
        status = (ISVNWCDb.SVNWCDbStatus)copyInfo.get(CopyInfo.status);
        dstPresence = null;
        opRoot = copyInfo.is(CopyInfo.opRoot);
        switch (1.$SwitchMap$org$tmatesoft$svn$core$internal$wc17$db$ISVNWCDb$SVNWCDbStatus[status.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                dstPresence = ISVNWCDb.SVNWCDbStatus.Normal;
                break;
            }
            case 5: {
                if (!opRoot) ** GOTO lbl26
                try {
                    dstInfo = SvnWcDbReader.readInfo(dstPdh.getWCRoot(), localDstRelpath, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.status});
                    dstStatus = (ISVNWCDb.SVNWCDbStatus)dstInfo.get(StructureFields.NodeInfo.status);
                    dstInfo.release();
                    if (dstStatus == ISVNWCDb.SVNWCDbStatus.Deleted) {
                        dstPdh.getWCRoot().getDb().addWorkQueue(dstPdh.getWCRoot().getAbsPath(), workItems);
                        return;
                    }
                    ** GOTO lbl29
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                        throw e;
                    }
                }
                ** GOTO lbl29
lbl26:
                // 1 sources

                if (copyFromRelpath == null) {
                    SVNWCDb.addWorkItems(dstPdh.getWCRoot().getSDb(), workItems);
                    return;
                }
            }
lbl29:
            // 5 sources

            case 6: 
            case 7: {
                if (dstOpDepths[1] > 0L) {
                    dstOpDepths[0] = dstOpDepths[1];
                    dstOpDepths[1] = -1L;
                }
                if (status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                    dstPresence = ISVNWCDb.SVNWCDbStatus.Excluded;
                    break;
                }
                dstPresence = ISVNWCDb.SVNWCDbStatus.NotPresent;
                break;
            }
            case 8: {
                err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot copy ''{0}'' excluded by server", (Object)srcPdh.getWCRoot().getAbsPath(localSrcRelpath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            default: {
                err1 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot handle status of ''{0}''", (Object)srcPdh.getWCRoot().getAbsPath(localSrcRelpath));
                SVNErrorManager.error(err1, SVNLogType.WC);
            }
        }
        kind = (ISVNWCDb.SVNWCDbKind)copyInfo.get(CopyInfo.kind);
        children = null;
        if (kind == ISVNWCDb.SVNWCDbKind.Dir) {
            opDepth = SvnWcDbCopy.getOpDepthOf(srcPdh.getWCRoot(), localSrcRelpath);
            children = srcPdh.getWCRoot().getDb().gatherRepoChildren(srcPdh.getWCRoot(), localSrcRelpath, opDepth);
        }
        if (srcPdh.getWCRoot() == dstPdh.getWCRoot()) {
            dstParentRelpath = SVNFileUtil.getFileDir(localDstRelpath);
            stmt = srcPdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.INSERT_WORKING_NODE_COPY_FROM);
            try {
                stmt.bindf("issist", new Object[]{srcPdh.getWCRoot().getWcId(), localSrcRelpath, localDstRelpath, dstOpDepths[0], dstParentRelpath, SvnWcDbStatementUtil.getPresenceText(dstPresence)});
                if (moveOpDepth > 0) {
                    if (SVNWCUtils.relpathDepth(localDstRelpath) == moveOpDepth) {
                        if (!(status == ISVNWCDb.SVNWCDbStatus.Added || status == ISVNWCDb.SVNWCDbStatus.Copied && opRoot)) {
                            stmt.bindLong(7, 1L);
                        }
                    } else {
                        infoStmt = dstPdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
                        try {
                            infoStmt.bindf("is", new Object[]{dstPdh.getWCRoot().getWcId(), dstParentRelpath});
                            haveRow = infoStmt.next();
                            if (!SvnWcDbCopy.$assertionsDisabled && !haveRow) {
                                throw new AssertionError();
                            }
                            if (infoStmt.getColumnBoolean(SVNWCDbSchema.NODES__Fields.moved_here) && dstOpDepths[0] == dstOpDepths[2]) {
                                stmt.bindLong(7, 1L);
                            } else {
                                infoStmt.reset();
                                infoStmt = dstPdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
                                infoStmt.bindf("is", new Object[]{dstPdh.getWCRoot().getWcId(), localSrcRelpath});
                                haveRow = infoStmt.next();
                                if (!SvnWcDbCopy.$assertionsDisabled && !haveRow) {
                                    throw new AssertionError();
                                }
                                if (infoStmt.getColumnBoolean(SVNWCDbSchema.NODES__Fields.moved_here)) {
                                    stmt.bindLong(7, 1L);
                                }
                            }
                        }
                        finally {
                            infoStmt.reset();
                        }
                    }
                }
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            SvnWcDbCopy.copyActual(srcPdh, localSrcRelpath, dstPdh, localDstRelpath);
            if (dstOpDepths[1] > 0L) {
                stmt = srcPdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.INSERT_NODE);
                try {
                    stmt.bindf("isisisrtnt", new Object[]{srcPdh.getWCRoot().getWcId(), localDstRelpath, dstOpDepths[1], dstParentRelpath, copyInfo.lng(CopyInfo.copyFromId), copyInfo.get(CopyInfo.copyFromRelpath), copyInfo.lng(CopyInfo.copyFromRev), SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.NotPresent), SvnWcDbStatementUtil.getKindText(kind)});
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (kind == ISVNWCDb.SVNWCDbKind.Dir && dstPresence == ISVNWCDb.SVNWCDbStatus.Normal) {
                fileChildren = new LinkedList<File>();
                for (String childName : children) {
                    fileChildren.add(new File(childName));
                }
                srcPdh.getWCRoot().getDb().insertIncompleteChildren(srcPdh.getWCRoot().getSDb(), srcPdh.getWCRoot().getWcId(), localDstRelpath, copyInfo.lng(CopyInfo.copyFromId), copyFromRelpath, copyInfo.lng(CopyInfo.copyFromRev), fileChildren, dstOpDepths[0]);
            }
        } else {
            SvnWcDbCopy.crossDbCopy(srcPdh, localSrcRelpath, dstPdh, localDstRelpath, dstPresence, dstOpDepths[0], dstOpDepths[1], kind, children, copyInfo.lng(CopyInfo.copyFromId), (File)copyInfo.get(CopyInfo.copyFromRelpath), copyInfo.lng(CopyInfo.copyFromRev));
        }
        dstPdh.getWCRoot().getDb().addWorkQueue(dstPdh.getWCRoot().getAbsPath(), workItems);
    }

    private static void crossDbCopy(SVNWCDbDir srcPdh, File localSrcRelpath, SVNWCDbDir dstPdh, File localDstRelpath, ISVNWCDb.SVNWCDbStatus dstPresence, long dstOpDepth, long dstNpOpDepth, ISVNWCDb.SVNWCDbKind kind, List<String> children, long copyFromId, File copyFromRelpath, long copyFromRev) throws SVNException {
        Structure<StructureFields.NodeInfo> nodeInfo = SvnWcDbShared.readInfo(srcPdh.getWCRoot(), localSrcRelpath, StructureFields.NodeInfo.changedRev, StructureFields.NodeInfo.changedDate, StructureFields.NodeInfo.changedAuthor, StructureFields.NodeInfo.depth, StructureFields.NodeInfo.checksum);
        SVNProperties properties = SvnWcDbProperties.readPristineProperties(srcPdh.getWCRoot(), localSrcRelpath);
        SVNWCDb.InsertWorking iw = new SVNWCDb.InsertWorking(dstPdh.getWCRoot().getDb());
        iw.status = dstPresence;
        iw.kind = kind;
        iw.props = properties;
        iw.changedRev = nodeInfo.lng(StructureFields.NodeInfo.changedRev);
        iw.changedDate = (SVNDate)nodeInfo.get(StructureFields.NodeInfo.changedDate);
        iw.changedAuthor = nodeInfo.text(StructureFields.NodeInfo.changedAuthor);
        iw.opDepth = dstOpDepth;
        iw.checksum = (SvnChecksum)nodeInfo.get(StructureFields.NodeInfo.checksum);
        ArrayList<File> childrenAsFiles = null;
        if (children != null) {
            childrenAsFiles = new ArrayList<File>();
            for (String name : children) {
                childrenAsFiles.add(new File(name));
            }
        }
        iw.children = childrenAsFiles;
        iw.depth = (SVNDepth)nodeInfo.get(StructureFields.NodeInfo.depth);
        iw.notPresentOpDepth = dstNpOpDepth;
        iw.originalReposId = copyFromId;
        iw.originalRevision = copyFromRev;
        iw.originalReposRelPath = copyFromRelpath;
        iw.wcRoot = dstPdh.getWCRoot();
        iw.localRelpath = localDstRelpath;
        dstPdh.getWCRoot().getSDb().runTransaction(iw);
        SvnWcDbCopy.copyActual(srcPdh, localSrcRelpath, dstPdh, localDstRelpath);
        nodeInfo.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyActual(SVNWCDbDir srcPdh, File localSrcRelpath, SVNWCDbDir dstPdh, File localDstRelpath) throws SVNException {
        block6: {
            SVNSqlJetStatement stmt = srcPdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
            stmt.bindf("is", srcPdh.getWCRoot().getWcId(), localSrcRelpath);
            try {
                if (!stmt.next()) break block6;
                String changelist = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                byte[] properties = SvnWcDbStatementUtil.getColumnBlob(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                if (changelist == null && properties == null) break block6;
                SvnWcDbStatementUtil.reset(stmt);
                stmt = dstPdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.INSERT_ACTUAL_NODE);
                try {
                    stmt.bindf("issbsb", dstPdh.getWCRoot().getWcId(), localDstRelpath, SVNFileUtil.getFileDir(localDstRelpath), properties, changelist, null);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            finally {
                SvnWcDbStatementUtil.reset(stmt);
            }
        }
    }

    private static Structure<CopyInfo> getCopyInfo(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        Object result = Structure.obtain(CopyInfo.class);
        ((Structure)result).set((CopyInfo)CopyInfo.haveWork, false);
        ((Structure)result).set((CopyInfo)CopyInfo.copyFromRev, -1L);
        Structure<StructureFields.NodeInfo> nodeInfo = SvnWcDbReader.readInfo(wcRoot, localRelPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId, StructureFields.NodeInfo.opRoot, StructureFields.NodeInfo.haveWork);
        nodeInfo.from(new StructureFields.NodeInfo[]{StructureFields.NodeInfo.kind, StructureFields.NodeInfo.status, StructureFields.NodeInfo.reposId, StructureFields.NodeInfo.haveWork, StructureFields.NodeInfo.opRoot}).into((Structure)result, new CopyInfo[]{CopyInfo.kind, CopyInfo.status, CopyInfo.copyFromId, CopyInfo.haveWork, CopyInfo.opRoot});
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        File reposRelpath = (File)nodeInfo.get(StructureFields.NodeInfo.reposRelPath);
        long revision = nodeInfo.lng(StructureFields.NodeInfo.revision);
        nodeInfo.release();
        if (status == ISVNWCDb.SVNWCDbStatus.Excluded) {
            File parentRelpath = SVNFileUtil.getFileDir(localRelPath);
            String name = SVNFileUtil.getFileName(localRelPath);
            Structure<CopyInfo> parentCopyInfo = SvnWcDbCopy.getCopyInfo(wcRoot, parentRelpath);
            parentCopyInfo.from(new CopyInfo[]{CopyInfo.copyFromId, CopyInfo.copyFromRev}).into((Structure)result, new CopyInfo[]{CopyInfo.copyFromId, CopyInfo.copyFromRev});
            if (parentCopyInfo.get(CopyInfo.copyFromRelpath) != null) {
                ((Structure)result).set((CopyInfo)CopyInfo.copyFromRelpath, SVNFileUtil.createFilePath((File)parentCopyInfo.get(CopyInfo.copyFromRelpath), name));
            }
            parentCopyInfo.release();
        } else if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbCopy.scanAddition(wcRoot, localRelPath, StructureFields.AdditionInfo.opRootRelPath, StructureFields.AdditionInfo.originalReposRelPath, StructureFields.AdditionInfo.originalReposId, StructureFields.AdditionInfo.originalRevision);
            additionInfo.from(new StructureFields.AdditionInfo[]{StructureFields.AdditionInfo.originalReposRelPath, StructureFields.AdditionInfo.originalReposId, StructureFields.AdditionInfo.originalRevision, StructureFields.AdditionInfo.status}).into((Structure)result, new CopyInfo[]{CopyInfo.copyFromRelpath, CopyInfo.copyFromId, CopyInfo.copyFromRev, CopyInfo.status});
            if (additionInfo.get(StructureFields.AdditionInfo.originalReposRelPath) != null) {
                File opRootRelPath = (File)additionInfo.get(StructureFields.AdditionInfo.opRootRelPath);
                File copyFromRelPath = (File)additionInfo.get(StructureFields.AdditionInfo.originalReposRelPath);
                File relPath = SVNFileUtil.createFilePath(copyFromRelPath, SVNWCUtils.skipAncestor(opRootRelPath, localRelPath));
                ((Structure)result).set((CopyInfo)CopyInfo.copyFromRelpath, relPath);
            }
            additionInfo.release();
        } else if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            Structure<StructureFields.DeletionInfo> deletionInfo = SvnWcDbCopy.scanDeletion(wcRoot, localRelPath);
            if (deletionInfo.get(StructureFields.DeletionInfo.workDelRelPath) != null) {
                File parentDelRelpath = SVNFileUtil.getFileDir((File)deletionInfo.get(StructureFields.DeletionInfo.workDelRelPath));
                Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbCopy.scanAddition(wcRoot, parentDelRelpath, StructureFields.AdditionInfo.opRootRelPath, StructureFields.AdditionInfo.originalReposRelPath, StructureFields.AdditionInfo.originalReposId, StructureFields.AdditionInfo.originalRevision);
                additionInfo.from(new StructureFields.AdditionInfo[]{StructureFields.AdditionInfo.originalReposRelPath, StructureFields.AdditionInfo.originalReposId, StructureFields.AdditionInfo.originalRevision}).into((Structure)result, new CopyInfo[]{CopyInfo.copyFromRelpath, CopyInfo.copyFromId, CopyInfo.copyFromRev});
                File opRootRelPath = (File)additionInfo.get(StructureFields.AdditionInfo.opRootRelPath);
                File copyFromRelPath = (File)additionInfo.get(StructureFields.AdditionInfo.originalReposRelPath);
                File relPath = SVNFileUtil.createFilePath(copyFromRelPath, SVNWCUtils.skipAncestor(opRootRelPath, localRelPath));
                ((Structure)result).set((CopyInfo)CopyInfo.copyFromRelpath, relPath);
                additionInfo.release();
            } else if (deletionInfo.get(StructureFields.DeletionInfo.baseDelRelPath) != null) {
                Structure<StructureFields.NodeInfo> baseInfo = SvnWcDbCopy.getDepthInfo(wcRoot, localRelPath, 0L, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId);
                baseInfo.from(new StructureFields.NodeInfo[]{StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId}).into((Structure)result, new CopyInfo[]{CopyInfo.copyFromRev, CopyInfo.copyFromRelpath, CopyInfo.copyFromId});
                baseInfo.release();
            }
            deletionInfo.release();
        } else {
            ((Structure)result).set((CopyInfo)CopyInfo.copyFromRelpath, reposRelpath);
            ((Structure)result).set((CopyInfo)CopyInfo.copyFromRev, revision);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] getOpDepthForCopy(SVNWCDbRoot wcRoot, File localRelpath, long copyFromReposId, File copyFromRelpath, long copyFromRevision) throws SVNException {
        File parentRelPath = SVNFileUtil.getFileDir(localRelpath);
        long[] result = new long[]{SVNWCUtils.relpathDepth(localRelpath), -1L, SVNWCUtils.relpathDepth(parentRelPath)};
        if (copyFromRelpath == null) {
            return result;
        }
        long minOpDepth = 1L;
        long incompleteOpDepth = -1L;
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
        try {
            SvnWcDbStatementUtil.bindf(stmt, "is", wcRoot.getWcId(), localRelpath);
            if (stmt.next()) {
                ISVNWCDb.SVNWCDbStatus status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                minOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                if (status == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                    incompleteOpDepth = minOpDepth;
                }
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        SvnWcDbStatementUtil.bindf(stmt, "is", wcRoot.getWcId(), parentRelPath);
        if (stmt.next()) {
            long parentOpDepth;
            ISVNWCDb.SVNWCDbStatus presence = SvnWcDbStatementUtil.getColumnPresence(stmt, SVNWCDbSchema.NODES__Fields.presence);
            result[2] = parentOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
            if (parentOpDepth < minOpDepth) {
                SvnWcDbStatementUtil.reset(stmt);
                return result;
            }
            assert (presence == ISVNWCDb.SVNWCDbStatus.Normal);
            if (incompleteOpDepth < 0L || incompleteOpDepth == parentOpDepth) {
                long parentCopyFromReposId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id);
                File parentCopyFromRelpath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.repos_path);
                long parentCopyFromRevision = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.revision);
                if (parentCopyFromReposId == copyFromReposId) {
                    if (copyFromRevision == parentCopyFromRevision && copyFromRelpath.equals(SVNFileUtil.createFilePath(parentCopyFromRelpath, localRelpath.getName()))) {
                        result[0] = parentOpDepth;
                    } else if (incompleteOpDepth > 0L) {
                        result[1] = incompleteOpDepth;
                    }
                }
            }
        }
        SvnWcDbStatementUtil.reset(stmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getOpDepthOf(SVNWCDbRoot wcRoot, File localRelpath) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        SvnWcDbStatementUtil.bindf(stmt, "is", wcRoot.getWcId(), localRelpath);
        try {
            if (stmt.next()) {
                long l = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                return l;
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        return 0L;
    }

    private static class SelectNodeToCopy
    extends SVNSqlJetSelectStatement {
        private long limit;
        private long depth;

        public SelectNodeToCopy(SVNSqlJetDb sDb, long depth) throws SVNException {
            super(sDb, SVNWCDbSchema.NODES);
            this.depth = depth;
        }

        @Override
        protected Object[] getWhere() throws SVNException {
            if (this.depth >= 0L) {
                return new Object[]{this.getBind(1), this.getBind(2), this.depth};
            }
            return super.getWhere();
        }

        @Override
        protected boolean isFilterPassed() throws SVNException {
            ++this.limit;
            return super.isFilterPassed() && this.limit == 1L;
        }

        @Override
        protected ISqlJetCursor openCursor() throws SVNException {
            if (this.depth == 0L) {
                return super.openCursor();
            }
            try {
                return super.openCursor().reverse();
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
                return null;
            }
        }
    }

    private static class InsertWorkingNodeCopy
    extends SVNSqlJetInsertStatement {
        private SelectNodeToCopy select;

        public InsertWorkingNodeCopy(SVNSqlJetDb sDb, boolean base) throws SVNException {
            this(sDb, base ? 0L : -1L);
        }

        public InsertWorkingNodeCopy(SVNSqlJetDb sDb, long depth) throws SVNException {
            super(sDb, SVNWCDbSchema.NODES, SqlJetConflictAction.REPLACE);
            this.select = new SelectNodeToCopy(sDb, depth);
        }

        @Override
        protected Map<String, Object> getInsertValues() throws SVNException {
            this.select.bindf("is", this.getBind(1), this.getBind(2));
            try {
                if (this.select.next()) {
                    HashMap<String, Object> values2 = new HashMap<String, Object>();
                    values2.put(SVNWCDbSchema.NODES__Fields.wc_id.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.wc_id));
                    values2.put(SVNWCDbSchema.NODES__Fields.local_relpath.toString(), this.getBind(3));
                    values2.put(SVNWCDbSchema.NODES__Fields.op_depth.toString(), this.getBind(4));
                    values2.put(SVNWCDbSchema.NODES__Fields.parent_relpath.toString(), this.getBind(5));
                    values2.put(SVNWCDbSchema.NODES__Fields.repos_id.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.repos_id));
                    values2.put(SVNWCDbSchema.NODES__Fields.repos_path.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.repos_path));
                    values2.put(SVNWCDbSchema.NODES__Fields.revision.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.revision));
                    values2.put(SVNWCDbSchema.NODES__Fields.presence.toString(), this.getBind(6));
                    values2.put(SVNWCDbSchema.NODES__Fields.depth.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.depth));
                    values2.put(SVNWCDbSchema.NODES__Fields.moved_here.toString(), this.getBind(7));
                    values2.put(SVNWCDbSchema.NODES__Fields.kind.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.kind));
                    values2.put(SVNWCDbSchema.NODES__Fields.changed_revision.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.changed_revision));
                    values2.put(SVNWCDbSchema.NODES__Fields.changed_date.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.changed_date));
                    values2.put(SVNWCDbSchema.NODES__Fields.changed_author.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.changed_author));
                    values2.put(SVNWCDbSchema.NODES__Fields.checksum.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.checksum));
                    values2.put(SVNWCDbSchema.NODES__Fields.properties.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.properties));
                    values2.put(SVNWCDbSchema.NODES__Fields.translated_size.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.translated_size));
                    values2.put(SVNWCDbSchema.NODES__Fields.last_mod_time.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.last_mod_time));
                    values2.put(SVNWCDbSchema.NODES__Fields.symlink_target.toString(), this.select.getColumn(SVNWCDbSchema.NODES__Fields.symlink_target));
                    values2.put(SVNWCDbSchema.NODES__Fields.moved_to.toString(), this.getMovedTo(this.sDb));
                    HashMap<String, Object> hashMap = values2;
                    return hashMap;
                }
            }
            finally {
                this.select.reset();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getMovedTo(SVNSqlJetDb sDb) throws SVNException {
            SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_MOVED_TO);
            try {
                stmt.bindf("isi", this.getBind(1), this.getBind(3), this.getBind(4));
                boolean next = stmt.next();
                String string = next ? stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to) : null;
                return string;
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static enum CopyInfo {
        copyFromId,
        copyFromRelpath,
        copyFromRev,
        status,
        kind,
        opRoot,
        haveWork;

    }
}

