/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import de.regnis.q.sequence.line.QSequenceLineRAByteData;
import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequence;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.DefaultSvnMerger;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCConflictDescription17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldUpgrade;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.ISvnMerger;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnMergeResult;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCContext {
    public static String CONFLICT_OP_UPDATE = "update";
    public static String CONFLICT_OP_SWITCH = "switch";
    public static String CONFLICT_OP_MERGE = "merge";
    public static String CONFLICT_OP_PATCH = "patch";
    public static String CONFLICT_KIND_TEXT = "text";
    public static String CONFLICT_KIND_PROP = "prop";
    public static String CONFLICT_KIND_TREE = "tree";
    public static String CONFLICT_KIND_REJECT = "reject";
    public static String CONFLICT_KIND_OBSTRUCTED = "obstructed";
    private static List<SVNStatusType> STATUS_ORDERING = new LinkedList<SVNStatusType>();
    public static final long INVALID_REVNUM = -1L;
    public static final int STREAM_CHUNK_SIZE = 16384;
    public static final String THIS_DIR_PREJ = "dir_conflicts";
    public static final String PROP_REJ_EXT = ".prej";
    public static final String CONFLICT_LOCAL_LABEL = "(modified)";
    public static final String CONFLICT_LATEST_LABEL = "(latest)";
    public static final byte[] CONFLICT_START;
    public static final byte[] CONFLICT_END;
    public static final byte[] CONFLICT_SEPARATOR;
    public static final int WC_NG_VERSION = 12;
    public static final int WC_WCPROPS_MANY_FILES_VERSION = 7;
    public static final int WC_WCPROPS_LOST = 12;
    public static final String WC_ADM_FORMAT = "format";
    public static final String WC_ADM_ENTRIES = "entries";
    public static final String WC_ADM_TMP = "tmp";
    public static final String WC_ADM_PRISTINE = "pristine";
    public static final String WC_ADM_NONEXISTENT_PATH = "nonexistent-path";
    public static final String WC_NON_ENTRIES_STRING = "12\n";
    private static final String WC17_SUPPORT_ENABLED_PROPERTY = "svnkit.wc.17.enabled";
    private ISVNWCDb db;
    private boolean closeDb;
    private Stack<ISVNEventHandler> eventHandler;
    private List<CleanupHandler> cleanupHandlers = new LinkedList<CleanupHandler>();
    private SvnOperation<?> operation;

    public TreeLocalModsInfo hasLocalMods(File localAbspath, File anchorAbspath) throws SVNException {
        final TreeLocalModsInfo modsInfo = new TreeLocalModsInfo();
        SVNStatusEditor17 statusEditor = new SVNStatusEditor17(anchorAbspath, this, this.getOptions(), false, false, SVNDepth.INFINITY, new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus status) throws SVNException {
                SVNStatusType nodeStatus = status.getNodeStatus();
                if (nodeStatus == SVNStatusType.STATUS_NORMAL || nodeStatus == SVNStatusType.STATUS_INCOMPLETE || nodeStatus == SVNStatusType.STATUS_IGNORED || nodeStatus == SVNStatusType.STATUS_NONE || nodeStatus == SVNStatusType.STATUS_UNVERSIONED || nodeStatus == SVNStatusType.STATUS_EXTERNAL) {
                    return;
                }
                if (nodeStatus == SVNStatusType.STATUS_DELETED) {
                    modsInfo.modificationsFound = true;
                    return;
                }
                if (nodeStatus == SVNStatusType.STATUS_MISSING || nodeStatus == SVNStatusType.STATUS_OBSTRUCTED) {
                    modsInfo.modificationsFound = true;
                    modsInfo.nonDeleteModificationsFound = true;
                    throw new SVNCancelException();
                }
                modsInfo.modificationsFound = true;
                modsInfo.nonDeleteModificationsFound = true;
                throw new SVNCancelException();
            }
        });
        try {
            statusEditor.walkStatus(localAbspath, SVNDepth.INFINITY, false, false, false, null);
        }
        catch (SVNCancelException sVNCancelException) {
            // empty catch block
        }
        return modsInfo;
    }

    public static boolean isAdminDirectory(String name) {
        return name != null && SVNFileUtil.isWindows ? SVNFileUtil.getAdminDirectoryName().equalsIgnoreCase(name) : SVNFileUtil.getAdminDirectoryName().equals(name);
    }

    private static boolean isWC17SupportEnabled() {
        return Boolean.parseBoolean(System.getProperty(WC17_SUPPORT_ENABLED_PROPERTY, "false"));
    }

    public SVNWCContext(ISVNOptions config, ISVNEventHandler eventHandler) {
        this(ISVNWCDb.SVNWCDbOpenMode.ReadWrite, config, true, true, eventHandler);
    }

    public SVNWCContext(ISVNWCDb.SVNWCDbOpenMode mode, ISVNOptions config, boolean autoUpgrade, boolean enforceEmptyWQ, ISVNEventHandler eventHandler) {
        this.db = new SVNWCDb();
        this.db.open(mode, config, autoUpgrade, enforceEmptyWQ);
        this.closeDb = true;
        this.eventHandler = new Stack();
        this.eventHandler.push(eventHandler);
    }

    public SVNWCContext(ISVNWCDb db, ISVNEventHandler eventHandler) {
        this.db = db;
        this.closeDb = false;
        this.eventHandler = new Stack();
        this.eventHandler.push(eventHandler);
    }

    public void setOperation(SvnOperation<?> operation) {
        if (SVNWCContext.isWC17SupportEnabled()) {
            SvnOperation<?> oldOperation = this.operation;
            this.operation = operation;
            if (oldOperation != null && oldOperation.isChangesWorkingCopy() && !this.operation.isChangesWorkingCopy()) {
                this.db.close();
            }
            ((SVNWCDb)this.db).setWC17SupportEnabled(!this.operation.isChangesWorkingCopy());
        }
    }

    public ISVNEventHandler getEventHandler() {
        return this.eventHandler.isEmpty() ? null : this.eventHandler.peek();
    }

    public void pushEventHandler(ISVNEventHandler handler) {
        this.eventHandler.push(handler);
    }

    public void popEventHandler() {
        this.eventHandler.pop();
    }

    public void setEventHandler(ISVNEventHandler handler) {
        if (!this.eventHandler.isEmpty()) {
            this.eventHandler.clear();
        }
        if (handler != null) {
            this.pushEventHandler(handler);
        }
    }

    public void close() {
        if (this.closeDb) {
            this.db.close();
        }
    }

    public void registerCleanupHandler(CleanupHandler ch) {
        this.cleanupHandlers.add(ch);
    }

    public void cleanup() throws SVNException {
        for (CleanupHandler ch : this.cleanupHandlers) {
            ch.cleanup();
        }
        this.cleanupHandlers.clear();
    }

    public ISVNWCDb getDb() {
        return this.db;
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.getEventHandler() != null) {
            this.getEventHandler().checkCancelled();
        }
    }

    public ISVNOptions getOptions() {
        return this.db.getConfig();
    }

    public SVNNodeKind readKind(File localAbsPath, boolean showHidden) throws SVNException {
        return this.readKind(localAbsPath, true, showHidden);
    }

    public SVNNodeKind readKind(File localAbsPath, boolean showDeleted, boolean showHidden) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        SVNNodeKind dbKind = this.db.readKind(localAbsPath, true, showDeleted, showHidden);
        if (dbKind == SVNNodeKind.DIR) {
            return SVNNodeKind.DIR;
        }
        if (dbKind == SVNNodeKind.FILE) {
            return SVNNodeKind.FILE;
        }
        return SVNNodeKind.NONE;
    }

    public boolean isNodeAdded(File path) throws SVNException {
        ISVNWCDb.WCDbInfo info = this.db.readInfo(path, ISVNWCDb.WCDbInfo.InfoField.status);
        ISVNWCDb.SVNWCDbStatus status = info.status;
        return status == ISVNWCDb.SVNWCDbStatus.Added || status == ISVNWCDb.SVNWCDbStatus.ObstructedAdd;
    }

    public boolean isNodeReplaced(File path) throws SVNException {
        ISVNWCDb.WCDbInfo info = this.db.readInfo(path, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.haveBase);
        ISVNWCDb.SVNWCDbStatus status = info.status;
        boolean haveBase = info.haveBase;
        ISVNWCDb.SVNWCDbStatus baseStatus = null;
        if (haveBase) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(path, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status);
            baseStatus = baseInfo.status;
        }
        return (status == ISVNWCDb.SVNWCDbStatus.Added || status == ISVNWCDb.SVNWCDbStatus.ObstructedAdd) && haveBase && baseStatus != ISVNWCDb.SVNWCDbStatus.NotPresent;
    }

    public long getRevisionNumber(SVNRevision revision, long[] latestRevisionNumber, SVNRepository repository, File path) throws SVNException {
        SVNErrorMessage err;
        if (repository == null && (revision == SVNRevision.HEAD || revision.getDate() != null)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (revision.getNumber() >= 0L) {
            return revision.getNumber();
        }
        if (revision.getDate() != null) {
            return repository.getDatedRevision(revision.getDate());
        }
        if (revision == SVNRevision.HEAD) {
            if (latestRevisionNumber != null && latestRevisionNumber.length > 0 && SVNRevision.isValidRevisionNumber(latestRevisionNumber[0])) {
                return latestRevisionNumber[0];
            }
            long latestRevision = repository.getLatestRevision();
            if (latestRevisionNumber != null && latestRevisionNumber.length > 0) {
                latestRevisionNumber[0] = latestRevision;
            }
            return latestRevision;
        }
        if (!revision.isValid()) {
            return -1L;
        }
        if (revision == SVNRevision.WORKING || revision == SVNRevision.BASE) {
            if (path == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            long revnum = -1L;
            try {
                revnum = this.getNodeCommitBaseRev(path);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                throw e;
            }
            if (!SVNRevision.isValidRevisionNumber(revnum)) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", (Object)path);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            return revnum;
        }
        if (revision == SVNRevision.COMMITTED || revision == SVNRevision.PREVIOUS) {
            if (path == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            ISVNWCDb.WCDbInfo info = this.getNodeChangedInfo(path);
            if (!SVNRevision.isValidRevisionNumber(info.changedRev)) {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", (Object)path);
                SVNErrorManager.error(err4, SVNLogType.WC);
            }
            return revision == SVNRevision.PREVIOUS ? info.changedRev - 1L : info.changedRev;
        }
        err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Unrecognized revision type requested for ''{0}''", path != null ? path : repository.getLocation());
        SVNErrorManager.error(err, SVNLogType.WC);
        return -1L;
    }

    public ISVNWCDb.WCDbInfo getNodeChangedInfo(File path) throws SVNException {
        return this.db.readInfo(path, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedDate, ISVNWCDb.WCDbInfo.InfoField.changedAuthor);
    }

    public long getNodeCommitBaseRev(File local_abspath) throws SVNException {
        ISVNWCDb.WCDbInfo info = this.db.readInfo(local_abspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.haveBase);
        long commitBaseRevision = info.revision;
        if (SVNRevision.isValidRevisionNumber(commitBaseRevision)) {
            return commitBaseRevision;
        }
        ISVNWCDb.SVNWCDbStatus status = info.status;
        boolean haveBase = info.haveBase;
        if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            ISVNWCDb.WCDbAdditionInfo addInfo = this.db.scanAddition(local_abspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision);
            commitBaseRevision = addInfo.originalRevision;
            if (!SVNRevision.isValidRevisionNumber(commitBaseRevision) && haveBase) {
                commitBaseRevision = this.getNodeBaseRev(local_abspath);
            }
        } else if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            ISVNWCDb.WCDbDeletionInfo delInfo = this.db.scanDeletion(local_abspath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.workDelAbsPath);
            File workDelAbspath = delInfo.workDelAbsPath;
            if (workDelAbspath != null) {
                File parentAbspath = SVNFileUtil.getFileDir(workDelAbspath);
                ISVNWCDb.WCDbInfo parentInfo = this.db.readInfo(parentAbspath, ISVNWCDb.WCDbInfo.InfoField.status);
                ISVNWCDb.SVNWCDbStatus parentStatus = parentInfo.status;
                assert (parentStatus == ISVNWCDb.SVNWCDbStatus.Added || parentStatus == ISVNWCDb.SVNWCDbStatus.ObstructedAdd);
                ISVNWCDb.WCDbAdditionInfo parentAddInfo = this.db.scanAddition(parentAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision);
                commitBaseRevision = parentAddInfo.originalRevision;
            } else {
                commitBaseRevision = this.getNodeBaseRev(local_abspath);
            }
        }
        return commitBaseRevision;
    }

    public long getNodeBaseRev(File local_abspath) throws SVNException {
        ISVNWCDb.WCDbInfo info = this.db.readInfo(local_abspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.haveBase);
        long baseRevision = info.revision;
        if (SVNRevision.isValidRevisionNumber(baseRevision)) {
            return baseRevision;
        }
        boolean haveBase = info.haveBase;
        if (haveBase) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(local_abspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision);
            baseRevision = baseInfo.revision;
        }
        return baseRevision;
    }

    public ScheduleInternalInfo getNodeScheduleInternal(File localAbsPath, boolean schedule2, boolean copied) throws SVNException {
        ScheduleInternalInfo info = new ScheduleInternalInfo();
        if (schedule2) {
            info.schedule = SVNWCSchedule.normal;
        }
        if (copied) {
            info.copied = false;
        }
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.originalReposRelpath, ISVNWCDb.WCDbInfo.InfoField.opRoot, ISVNWCDb.WCDbInfo.InfoField.haveBase, ISVNWCDb.WCDbInfo.InfoField.haveMoreWork, ISVNWCDb.WCDbInfo.InfoField.haveWork);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        File copyFromRelpath = readInfo.originalReposRelpath;
        switch (status) {
            case NotPresent: 
            case ServerExcluded: 
            case Excluded: {
                if (!schedule2) break;
                info.schedule = SVNWCSchedule.normal;
                break;
            }
            case Normal: 
            case Incomplete: {
                break;
            }
            case Deleted: {
                if (schedule2) {
                    info.schedule = SVNWCSchedule.delete;
                }
                if (!copied) break;
                if (readInfo.haveMoreWork || !readInfo.haveBase) {
                    info.copied = true;
                    break;
                }
                File work_del_abspath = this.db.scanDeletion((File)localAbsPath, (ISVNWCDb.WCDbDeletionInfo.DeletionInfoField[])new ISVNWCDb.WCDbDeletionInfo.DeletionInfoField[]{ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.workDelAbsPath}).workDelAbsPath;
                if (work_del_abspath == null) break;
                info.copied = true;
                break;
            }
            case Added: {
                if (!readInfo.opRoot) {
                    if (copied) {
                        info.copied = true;
                    }
                    if (!schedule2) break;
                    info.schedule = SVNWCSchedule.normal;
                    break;
                }
                if (copied) {
                    boolean bl = info.copied = copyFromRelpath != null;
                }
                if (!schedule2) break;
                info.schedule = SVNWCSchedule.add;
                if (!readInfo.haveBase && !readInfo.haveMoreWork) break;
                ISVNWCDb.WCDbInfo workingInfo = this.db.readInfoBelowWorking(localAbsPath);
                if (workingInfo.status == ISVNWCDb.SVNWCDbStatus.NotPresent || workingInfo.status == ISVNWCDb.SVNWCDbStatus.Deleted) break;
                info.schedule = SVNWCSchedule.replace;
                break;
            }
            default: {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL), SVNLogType.WC);
                return null;
            }
        }
        return info;
    }

    public boolean isTextModified(File localAbsPath, boolean exactComparison) throws SVNException {
        Structure<StructureFields.NodeInfo> nodeInfo = this.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.recordedSize, StructureFields.NodeInfo.recordedTime, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfo.get(StructureFields.NodeInfo.kind));
        if (!nodeInfo.hasValue(StructureFields.NodeInfo.checksum) || ISVNWCDb.SVNWCDbKind.File != kind || ISVNWCDb.SVNWCDbStatus.Added != status && ISVNWCDb.SVNWCDbStatus.Normal != status) {
            return true;
        }
        SVNFileType fileType = SVNFileType.getType(localAbsPath);
        if (fileType != SVNFileType.FILE && fileType != SVNFileType.SYMLINK) {
            return false;
        }
        if (!exactComparison && fileType != SVNFileType.SYMLINK) {
            boolean compare = false;
            long recordedSize = nodeInfo.lng(StructureFields.NodeInfo.recordedSize);
            if (recordedSize != -1L && SVNFileUtil.getFileLength(localAbsPath) != recordedSize) {
                compare = true;
            }
            if (!compare && !SVNFileUtil.compareFileTimestamps(nodeInfo.lng(StructureFields.NodeInfo.recordedTime), SVNFileUtil.getFileLastModifiedMicros(localAbsPath))) {
                compare = true;
            }
            if (!compare) {
                return false;
            }
        }
        File pristineFile = this.getDb().getPristinePath(this.getDb().getWCRoot(localAbsPath), (SvnChecksum)nodeInfo.get(StructureFields.NodeInfo.checksum));
        boolean modified = false;
        modified = this.compareAndVerify(localAbsPath, pristineFile, nodeInfo.is(StructureFields.NodeInfo.hadProps), nodeInfo.is(StructureFields.NodeInfo.propsMod), exactComparison);
        if (!modified && this.getDb().isWCLockOwns(localAbsPath, false)) {
            this.db.globalRecordFileinfo(localAbsPath, SVNFileUtil.getFileLength(localAbsPath), SVNFileUtil.getFileLastModifiedMicros(localAbsPath));
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndVerify(File localAbsPath, File pristineFile, boolean hasProps, boolean propMods, boolean exactComparison) throws SVNException {
        if (propMods) {
            hasProps = true;
        }
        boolean translationRequired = false;
        TranslateInfo translateInfo = null;
        if (hasProps || this.isGlobalCharsetSpecified()) {
            translateInfo = this.getTranslateInfo(localAbsPath, true, true, true, true);
            translationRequired = this.isTranslationRequired(translateInfo.eolStyleInfo.eolStyle, translateInfo.eolStyleInfo.eolStr, translateInfo.charset, translateInfo.keywords, translateInfo.special, true);
        }
        if (!translationRequired && SVNFileUtil.getFileLength(localAbsPath) != pristineFile.length()) {
            return true;
        }
        if (translationRequired) {
            boolean bl;
            InputStream versionedStream = null;
            InputStream pristineStream = null;
            File tmpFile = null;
            try {
                pristineStream = SVNFileUtil.openFileForReading(pristineFile);
                if (translateInfo.special) {
                    versionedStream = SVNFileUtil.symlinksSupported() ? SVNWCContext.readSpecialFile(localAbsPath) : SVNFileUtil.openFileForReading(localAbsPath);
                } else {
                    versionedStream = SVNFileUtil.openFileForReading(localAbsPath);
                    if (!exactComparison) {
                        byte[] eolStr = translateInfo.eolStyleInfo.eolStr;
                        if (translateInfo.eolStyleInfo.eolStyle == SVNEolStyle.Native) {
                            eolStr = SVNTranslator.getBaseEOL("native");
                        } else if (translateInfo.eolStyleInfo.eolStyle != SVNEolStyle.Fixed && translateInfo.eolStyleInfo.eolStyle != SVNEolStyle.None) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL), SVNLogType.WC);
                        }
                        versionedStream = SVNTranslator.getTranslatingInputStream(versionedStream, translateInfo.charset, eolStr, true, translateInfo.keywords, false);
                    } else {
                        pristineStream = SVNTranslator.getTranslatingInputStream(pristineStream, translateInfo.charset, translateInfo.eolStyleInfo.eolStr, false, translateInfo.keywords, true);
                    }
                }
                bl = !this.isSameContents(versionedStream, pristineStream);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(pristineStream);
                SVNFileUtil.closeFile(versionedStream);
                SVNFileUtil.deleteFile(tmpFile);
                throw throwable;
            }
            SVNFileUtil.closeFile(pristineStream);
            SVNFileUtil.closeFile(versionedStream);
            SVNFileUtil.deleteFile(tmpFile);
            return bl;
        }
        return !this.isSameContents(localAbsPath, pristineFile);
    }

    private boolean isGlobalCharsetSpecified() {
        ISVNOptions options = this.getOptions();
        if (options instanceof DefaultSVNOptions) {
            DefaultSVNOptions defaultOptions = (DefaultSVNOptions)options;
            String globalCharset = defaultOptions.getGlobalCharset();
            return globalCharset != null;
        }
        return false;
    }

    public PristineContentsInfo getPristineContents(File localAbspath, boolean openStream, boolean getPath) throws SVNException {
        SVNErrorMessage err;
        assert (openStream || getPath);
        PristineContentsInfo info = new PristineContentsInfo();
        Structure<StructureFields.PristineInfo> readInfo = this.db.readPristineInfo(localAbspath);
        if (readInfo.get(StructureFields.PristineInfo.kind) != ISVNWCDb.SVNWCDbKind.File) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Can only get the pristine contents of files;  ''{0}'' is not a file", (Object)localAbspath);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)readInfo.get(StructureFields.PristineInfo.status));
        SvnChecksum checksum = (SvnChecksum)readInfo.get(StructureFields.PristineInfo.checksum);
        readInfo.release();
        if (status == ISVNWCDb.SVNWCDbStatus.Added && checksum == null) {
            ISVNWCDb.WCDbAdditionInfo scanAddition = this.db.scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status);
            if (scanAddition.status == ISVNWCDb.SVNWCDbStatus.Added) {
                return info;
            }
        } else if (status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Cannot get the pristine contents of ''{0}'' because its delete is already committed", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.Incomplete) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot get the pristine contents of ''{0}'' because it has an unexpected status", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else {
            SVNErrorManager.assertionFailure(status != ISVNWCDb.SVNWCDbStatus.Obstructed && status != ISVNWCDb.SVNWCDbStatus.ObstructedAdd && status != ISVNWCDb.SVNWCDbStatus.ObstructedDelete && status != ISVNWCDb.SVNWCDbStatus.BaseDeleted, null, SVNLogType.WC);
        }
        if (checksum == null) {
            return info;
        }
        SvnChecksum oldchecksum = SvnChecksum.fromString(checksum.toString());
        if (getPath) {
            info.path = this.db.getPristinePath(localAbspath, oldchecksum);
        }
        if (openStream) {
            info.stream = this.db.readPristine(localAbspath, oldchecksum);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSameContents(File file1, File file2) throws SVNException {
        InputStream stream1 = null;
        InputStream stream2 = null;
        try {
            stream1 = SVNFileUtil.openFileForReading(file1);
            stream2 = SVNFileUtil.openFileForReading(file2);
            boolean bl = this.isSameContents(stream1, stream2);
            return bl;
        }
        finally {
            try {
                SVNFileUtil.closeFile(stream1);
            }
            finally {
                SVNFileUtil.closeFile(stream2);
            }
        }
    }

    private boolean isSameContents(InputStream stream1, InputStream stream2) throws SVNException {
        try {
            byte[] buf1 = new byte[16384];
            byte[] buf2 = new byte[16384];
            long bytes_read1 = 16384L;
            long bytes_read2 = 16384L;
            boolean same = true;
            while (bytes_read1 == 16384L && bytes_read2 == 16384L) {
                bytes_read1 = stream1.read(buf1);
                if (bytes_read1 == (bytes_read2 = (long)stream2.read(buf2)) && this.arraysEqual(buf1, buf2, (int)bytes_read1)) continue;
                same = false;
                break;
            }
            return same;
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
            return false;
        }
    }

    private boolean arraysEqual(byte[] array1, byte[] array2, int size) {
        for (int i = 0; i < size; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static InputStream readSpecialFile(File localAbsPath) throws SVNException {
        if (!SVNFileUtil.symlinksSupported()) {
            return SVNFileUtil.openFileForReading(localAbsPath, SVNLogType.WC);
        }
        SVNFileType filetype = SVNFileType.getType(localAbsPath);
        if (SVNFileType.FILE == filetype) {
            return SVNFileUtil.openFileForReading(localAbsPath, SVNLogType.WC);
        }
        if (SVNFileType.SYMLINK == filetype) {
            String linkPath = SVNFileUtil.getSymlinkName(localAbsPath);
            if (linkPath == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            String symlinkContents = "link " + linkPath;
            return new ByteArrayInputStream(symlinkContents.getBytes());
        }
        SVNErrorManager.assertionFailure(false, "ERR_MALFUNCTION", SVNLogType.WC);
        return null;
    }

    private boolean isTranslationRequired(SVNEolStyle style, byte[] eol, String charset, Map<String, byte[]> keywords, boolean special, boolean force_eol_check) {
        return special || keywords != null && !keywords.isEmpty() || style != SVNEolStyle.None && force_eol_check || charset != null || style == SVNEolStyle.Fixed && !Arrays.equals(SVNEolStyleInfo.NATIVE_EOL_STR, eol);
    }

    public String getCharset(File path) throws SVNException {
        SVNProperties properties = this.getProperties(path, "svn:mime-type");
        String mimeType = properties.getStringValue("svn:mime-type");
        return SVNTranslator.getCharset(properties.getStringValue("svnkit:charset"), mimeType, path, this.getOptions());
    }

    public boolean isSpecial(File path) throws SVNException {
        String property = this.getProperty(path, "svn:special");
        return property != null;
    }

    public SVNEolStyleInfo getEolStyle(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        String propVal = this.getProperty(localAbsPath, "svn:eol-style");
        return SVNEolStyleInfo.fromValue(propVal);
    }

    public Map<String, byte[]> getKeyWords(File localAbsPath, String forceList) throws SVNException {
        String list;
        assert (SVNWCDb.isAbsolute(localAbsPath));
        if (forceList == null) {
            list = this.getProperty(localAbsPath, "svn:keywords");
            if (list == null) {
                return null;
            }
        } else {
            list = forceList;
        }
        SVNURL url = this.getNodeUrl(localAbsPath);
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedDate, ISVNWCDb.WCDbInfo.InfoField.changedAuthor, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl);
        return SVNTranslator.computeKeywords(list, url.toString(), readInfo.reposRootUrl == null ? null : readInfo.reposRootUrl.toString(), readInfo.changedAuthor, readInfo.changedDate != null ? readInfo.changedDate.format() : null, Long.toString(readInfo.changedRev), this.getOptions());
    }

    public TranslateInfo getTranslateInfo(File localAbspath, boolean fetchEolStyle, boolean fetchCharset, boolean fetchKeywords, boolean fetchSpecial) throws SVNException {
        return this.getTranslateInfo(localAbspath, null, false, fetchEolStyle, fetchCharset, fetchKeywords, fetchSpecial);
    }

    public TranslateInfo getTranslateInfo(File localAbspath, SVNProperties props, boolean forNormalization, boolean fetchEolStyle, boolean fetchCharset, boolean fetchKeywords, boolean fetchSpecial) throws SVNException {
        TranslateInfo info = new TranslateInfo();
        if (props == null) {
            props = this.getActualProperties(localAbspath);
        }
        if (fetchEolStyle) {
            info.eolStyleInfo = SVNEolStyleInfo.fromValue(props.getStringValue("svn:eol-style"));
        }
        if (fetchCharset) {
            info.charset = SVNTranslator.getCharset(props.getStringValue("svnkit:charset"), props.getStringValue("svn:mime-type"), localAbspath, this.getOptions());
        }
        if (fetchKeywords) {
            String keywordsProp = props.getStringValue("svn:keywords");
            info.keywords = keywordsProp == null || "".equals(keywordsProp) ? null : this.expandKeywords(localAbspath, null, keywordsProp, forNormalization);
        }
        if (fetchSpecial) {
            info.special = props.getStringValue("svn:special") != null;
        }
        return info;
    }

    private Map<String, byte[]> expandKeywords(File localAbsPath, File wriAbspath, String keywordsList, boolean forNormalization) throws SVNException {
        long changedRev;
        String url = null;
        String repositoryRoot = null;
        SVNDate changedDate = null;
        String changedAuthor = null;
        if (!forNormalization) {
            ISVNWCDb.WCDbInfo info = this.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedAuthor, ISVNWCDb.WCDbInfo.InfoField.changedDate);
            changedAuthor = info.changedAuthor;
            changedRev = info.changedRev;
            changedDate = info.changedDate;
            String string = repositoryRoot = info.reposRootUrl == null ? null : info.reposRootUrl.toString();
            if (info.reposRelPath != null) {
                url = info.reposRootUrl.appendPath(SVNFileUtil.getFilePath(info.reposRelPath), false).toString();
            } else {
                SVNURL svnUrl = this.getNodeUrl(localAbsPath);
                if (svnUrl != null) {
                    url = svnUrl.toString();
                }
            }
        } else {
            url = "";
            repositoryRoot = null;
            changedRev = -1L;
            changedDate = SVNDate.NULL;
            changedAuthor = "";
        }
        return SVNTranslator.computeKeywords(keywordsList, url, repositoryRoot, changedAuthor, changedDate != null ? changedDate.format() : null, Long.toString(changedRev), this.getOptions());
    }

    public boolean isFileExternal(File path) throws SVNException {
        String serialized = this.db.getFileExternalTemp(path);
        return serialized != null;
    }

    public SVNURL getNodeUrl(File path) throws SVNException {
        Structure<StructureFields.NodeInfo> info = this.db.readInfo(path, StructureFields.NodeInfo.status, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId, StructureFields.NodeInfo.haveBase);
        File reposRelPath = (File)info.get(StructureFields.NodeInfo.reposRelPath);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)info.get(StructureFields.NodeInfo.status));
        long reposId = info.lng(StructureFields.NodeInfo.reposId);
        if (reposRelPath == null) {
            if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbShared.scanAddition((SVNWCDb)this.db, path);
                reposRelPath = (File)additionInfo.get(StructureFields.AdditionInfo.reposRelPath);
                reposId = additionInfo.lng(StructureFields.AdditionInfo.reposId);
                additionInfo.release();
            } else if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                File localRelPath = this.db.toRelPath(path);
                Structure<StructureFields.DeletionInfo> deletionInfo = SvnWcDbShared.scanDeletion((SVNWCDb)this.db, path);
                File baseDelRelpath = (File)deletionInfo.get(StructureFields.DeletionInfo.baseDelRelPath);
                File workDelRelpath = (File)deletionInfo.get(StructureFields.DeletionInfo.workDelRelPath);
                if (baseDelRelpath != null) {
                    SVNWCDb.DirParsedInfo dirParsedInfo = ((SVNWCDb)this.db).parseDir(path, SVNSqlJetDb.Mode.ReadOnly);
                    Structure<StructureFields.NodeInfo> baseInfo = SvnWcDbShared.getBaseInfo(dirParsedInfo.wcDbDir.getWCRoot(), baseDelRelpath, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId);
                    reposRelPath = (File)baseInfo.get(StructureFields.NodeInfo.reposRelPath);
                    reposId = baseInfo.lng(StructureFields.NodeInfo.reposId);
                    baseInfo.release();
                    reposRelPath = SVNFileUtil.createFilePath(reposRelPath, SVNWCUtils.skipAncestor(baseDelRelpath, localRelPath));
                } else if (workDelRelpath != null) {
                    File workRelpath = SVNFileUtil.getFileDir(workDelRelpath);
                    Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbShared.scanAddition((SVNWCDb)this.db, this.db.fromRelPath(this.db.getWCRoot(path), workRelpath));
                    reposRelPath = (File)additionInfo.get(StructureFields.AdditionInfo.reposRelPath);
                    reposId = additionInfo.lng(StructureFields.AdditionInfo.reposId);
                    additionInfo.release();
                    reposRelPath = SVNFileUtil.createFilePath(reposRelPath, SVNWCUtils.skipAncestor(workRelpath, localRelPath));
                }
            } else {
                if (status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                    File parentPath = SVNFileUtil.getParentFile(path);
                    SVNURL url = this.getNodeUrl(parentPath);
                    return url.appendPath(SVNFileUtil.getFileName(path), false);
                }
                return null;
            }
        }
        SVNWCDb.DirParsedInfo dpi = ((SVNWCDb)this.db).parseDir(path, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.ReposInfo reposInfo = ((SVNWCDb)this.db).fetchReposInfo(dpi.wcDbDir.getWCRoot().getSDb(), reposId);
        return SVNWCUtils.join(SVNURL.parseURIEncoded(reposInfo.reposRootUrl), reposRelPath);
    }

    public ConflictInfo getConflicted(File localAbsPath, boolean isTextNeed, boolean isPropNeed, boolean isTreeNeed) throws SVNException {
        boolean resolvedText = false;
        boolean resolvedProp = false;
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.conflicted);
        ConflictInfo info = new ConflictInfo();
        if (!readInfo.conflicted) {
            return info;
        }
        File dir_path = readInfo.kind == ISVNWCDb.SVNWCDbKind.Dir ? localAbsPath : SVNFileUtil.getFileDir(localAbsPath);
        File rootPath = this.getDb().getWCRoot(dir_path);
        List<SVNConflictDescription> conflicts = this.db.readConflicts(localAbsPath);
        for (SVNConflictDescription cd : conflicts) {
            boolean owns;
            SVNMergeFileSet cdf = cd.getMergeFiles();
            if (isTextNeed && cd.isTextConflict()) {
                File path;
                SVNNodeKind kind;
                boolean done = false;
                if (cdf.getBaseFile() != null && (kind = SVNFileType.getNodeKind(SVNFileType.getType(path = SVNFileUtil.isAbsolute(cdf.getBaseFile()) ? cdf.getBaseFile() : SVNFileUtil.createFilePath(dir_path, cdf.getBaseFile())))) == SVNNodeKind.FILE) {
                    info.textConflicted = true;
                    info.baseFile = path;
                    done = true;
                }
                if (cdf.getRepositoryFile() != null && (kind = SVNFileType.getNodeKind(SVNFileType.getType(path = SVNFileUtil.isAbsolute(cdf.getRepositoryFile()) ? cdf.getRepositoryFile() : SVNFileUtil.createFilePath(dir_path, cdf.getRepositoryFile())))) == SVNNodeKind.FILE) {
                    info.textConflicted = true;
                    info.repositoryFile = path;
                    done = true;
                }
                if (cdf.getLocalFile() != null && (kind = SVNFileType.getNodeKind(SVNFileType.getType(path = SVNFileUtil.isAbsolute(cdf.getLocalFile()) ? cdf.getLocalFile() : SVNFileUtil.createFilePath(dir_path, cdf.getLocalFile())))) == SVNNodeKind.FILE) {
                    info.textConflicted = true;
                    info.localFile = path;
                    done = true;
                }
                if (!(done || cdf.getBaseFile() == null && cdf.getRepositoryFile() == null && cdf.getLocalFile() == null)) {
                    resolvedText = true;
                }
            } else if (isPropNeed && cd.isPropertyConflict()) {
                if (cdf.getRepositoryFile() != null) {
                    File path = SVNFileUtil.isAbsolute(cdf.getRepositoryFile()) ? cdf.getRepositoryFile() : SVNFileUtil.createFilePath(rootPath, cdf.getRepositoryFile());
                    SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(path));
                    if (kind == SVNNodeKind.FILE) {
                        info.propConflicted = true;
                        info.propRejectFile = path;
                    } else {
                        resolvedProp = true;
                    }
                }
            } else if (isTreeNeed && cd.isTreeConflict()) {
                info.treeConflicted = true;
                info.treeConflict = (SVNTreeConflictDescription)cd;
            }
            if (!resolvedText && !resolvedProp || !(owns = this.getDb().isWCLockOwns(localAbsPath, false))) continue;
            this.getDb().opMarkResolved(localAbsPath, resolvedText, resolvedProp, false, null);
        }
        return info;
    }

    public String getProperty(File localAbsPath, String name) throws SVNException {
        SVNProperties properties = this.getProperties(localAbsPath, name);
        if (properties != null) {
            return properties.getStringValue(name);
        }
        return null;
    }

    public SVNPropertyValue getPropertyValue(File localAbsPath, String name) throws SVNException {
        SVNProperties properties = this.getProperties(localAbsPath, name);
        if (properties != null) {
            return properties.getSVNPropertyValue(name);
        }
        return null;
    }

    private SVNProperties getProperties(File localAbsPath, String name) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        assert (!SVNProperty.isEntryProperty(name));
        SVNProperties properties = null;
        ISVNWCDb.SVNWCDbKind wcKind = this.db.readKind(localAbsPath, true);
        if (wcKind == ISVNWCDb.SVNWCDbKind.Unknown) {
            return null;
        }
        boolean hidden = this.db.isNodeHidden(localAbsPath);
        if (hidden) {
            return null;
        }
        if (SVNProperty.isWorkingCopyProperty(name)) {
            try {
                properties = this.db.getBaseDavCache(localAbsPath);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    return null;
                }
                throw e;
            }
        } else {
            properties = this.getActualProperties(localAbsPath);
        }
        return properties;
    }

    private SVNProperties getActualProperties(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        return this.db.readProperties(localAbsPath);
    }

    public SVNURL getUrlFromPath(File localAbsPath) throws SVNException {
        return this.getEntryLocation((File)localAbsPath, (SVNRevision)SVNRevision.UNDEFINED, (boolean)false).url;
    }

    public EntryLocationInfo getEntryLocation(File localAbsPath, SVNRevision pegRevisionKind, boolean fetchRevnum) throws SVNException {
        if (pegRevisionKind == SVNRevision.HEAD) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }
        NodeCopyFromInfo copyFrom = this.getNodeCopyFromInfo(localAbsPath, NodeCopyFromField.url, NodeCopyFromField.rev);
        EntryLocationInfo result = new EntryLocationInfo();
        if (copyFrom.url != null && pegRevisionKind == SVNRevision.WORKING) {
            result.url = copyFrom.url;
            if (fetchRevnum) {
                result.revNum = copyFrom.rev;
            }
        } else {
            SVNURL node_url = this.getNodeUrl(localAbsPath);
            if (node_url != null) {
                result.url = node_url;
                if (fetchRevnum) {
                    if (pegRevisionKind == SVNRevision.COMMITTED || pegRevisionKind == SVNRevision.PREVIOUS) {
                        result.revNum = this.getNodeChangedInfo((File)localAbsPath).changedRev;
                        if (pegRevisionKind == SVNRevision.PREVIOUS) {
                            --result.revNum;
                        }
                    } else {
                        result.revNum = this.getNodeBaseRev(localAbsPath);
                    }
                }
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry for ''{0}'' has no URL", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        return result;
    }

    public NodeCopyFromInfo getNodeCopyFromInfo(File localAbsPath, NodeCopyFromField ... fields) throws SVNException {
        EnumSet f = SVNWCDb.getInfoFields(NodeCopyFromField.class, (Enum[])fields);
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.originalReposRelpath, ISVNWCDb.WCDbInfo.InfoField.originalRootUrl, ISVNWCDb.WCDbInfo.InfoField.originalRevision);
        SVNURL original_root_url = readInfo.originalRootUrl;
        File original_repos_relpath = readInfo.originalReposRelpath;
        long original_revision = readInfo.originalRevision;
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        NodeCopyFromInfo copyFrom = new NodeCopyFromInfo();
        if (original_root_url != null && original_repos_relpath != null) {
            SVNURL my_copyfrom_url = null;
            if (f.contains((Object)NodeCopyFromField.url) || f.contains((Object)NodeCopyFromField.isCopyTarget)) {
                my_copyfrom_url = SVNURL.parseURIEncoded(SVNPathUtil.append(original_root_url.toString(), original_repos_relpath.toString()));
            }
            if (f.contains((Object)NodeCopyFromField.rootUrl)) {
                copyFrom.rootUrl = original_root_url;
            }
            if (f.contains((Object)NodeCopyFromField.reposRelPath)) {
                copyFrom.reposRelPath = original_repos_relpath;
            }
            if (f.contains((Object)NodeCopyFromField.url)) {
                copyFrom.url = my_copyfrom_url;
            }
            if (f.contains((Object)NodeCopyFromField.rev)) {
                copyFrom.rev = original_revision;
            }
            if (f.contains((Object)NodeCopyFromField.isCopyTarget)) {
                File parent_abspath = SVNFileUtil.getFileDir(localAbsPath);
                String base_name = SVNFileUtil.getFileName(localAbsPath);
                SVNURL parent_copyfrom_url = this.getNodeCopyFromInfo((File)parent_abspath, (NodeCopyFromField[])new NodeCopyFromField[]{NodeCopyFromField.url}).url;
                if (parent_copyfrom_url == null || !SVNURL.parseURIEncoded(SVNPathUtil.append(parent_copyfrom_url.toString(), base_name)).equals(my_copyfrom_url)) {
                    copyFrom.isCopyTarget = true;
                }
            }
        } else if ((status == ISVNWCDb.SVNWCDbStatus.Added || status == ISVNWCDb.SVNWCDbStatus.ObstructedAdd) && (f.contains((Object)NodeCopyFromField.rev) || f.contains((Object)NodeCopyFromField.url) || f.contains((Object)NodeCopyFromField.rootUrl) || f.contains((Object)NodeCopyFromField.reposRelPath))) {
            ISVNWCDb.WCDbAdditionInfo scanAddition = this.db.scanAddition(localAbsPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.opRootAbsPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision);
            File op_root_abspath = scanAddition.opRootAbsPath;
            status = scanAddition.status;
            original_repos_relpath = scanAddition.originalReposRelPath;
            original_root_url = scanAddition.originalRootUrl;
            original_revision = scanAddition.originalRevision;
            if (status == ISVNWCDb.SVNWCDbStatus.Copied || status == ISVNWCDb.SVNWCDbStatus.MovedHere) {
                SVNURL src_parent_url = SVNURL.parseURIEncoded(SVNPathUtil.append(original_root_url.toString(), original_repos_relpath.toString()));
                String src_relpath = SVNPathUtil.getPathAsChild(op_root_abspath.toString(), localAbsPath.toString());
                if (src_relpath != null) {
                    if (f.contains((Object)NodeCopyFromField.rootUrl)) {
                        copyFrom.rootUrl = original_root_url;
                    }
                    if (f.contains((Object)NodeCopyFromField.reposRelPath)) {
                        copyFrom.reposRelPath = SVNFileUtil.createFilePath(original_repos_relpath, src_relpath);
                    }
                    if (f.contains((Object)NodeCopyFromField.url)) {
                        copyFrom.url = SVNURL.parseURIEncoded(SVNPathUtil.append(src_parent_url.toString(), src_relpath.toString()));
                    }
                    if (f.contains((Object)NodeCopyFromField.rev)) {
                        copyFrom.rev = original_revision;
                    }
                }
            }
        }
        return copyFrom;
    }

    public Structure<StructureFields.NodeOriginInfo> getNodeOrigin(File localAbsPath, boolean scanDeleted, StructureFields.NodeOriginInfo ... fields) throws SVNException {
        Structure<StructureFields.NodeInfo> readInfo = this.db.readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid, StructureFields.NodeInfo.originalRevision, StructureFields.NodeInfo.originalReposRelpath, StructureFields.NodeInfo.originalRootUrl, StructureFields.NodeInfo.originalUuid, StructureFields.NodeInfo.originalUuid, StructureFields.NodeInfo.haveWork);
        Object result = Structure.obtain(StructureFields.NodeOriginInfo.class, fields);
        readInfo.from(new StructureFields.NodeInfo[]{StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid, StructureFields.NodeInfo.haveWork}).into((Structure)result, new StructureFields.NodeOriginInfo[]{StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl, StructureFields.NodeOriginInfo.reposUuid, StructureFields.NodeOriginInfo.isCopy});
        if (readInfo.hasValue(StructureFields.NodeInfo.reposRelPath)) {
            readInfo.release();
            return result;
        }
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)readInfo.get(StructureFields.NodeInfo.status));
        if (status == ISVNWCDb.SVNWCDbStatus.Deleted && !scanDeleted) {
            if (((Structure)result).hasValue(StructureFields.NodeOriginInfo.isCopy) && ((Structure)result).is((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.isCopy)) {
                ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.isCopy, false);
            }
            readInfo.release();
            return result;
        }
        if (readInfo.hasValue(StructureFields.NodeInfo.originalReposRelpath)) {
            readInfo.from(new StructureFields.NodeInfo[]{StructureFields.NodeInfo.originalRevision, StructureFields.NodeInfo.originalReposRelpath, StructureFields.NodeInfo.originalRootUrl, StructureFields.NodeInfo.originalUuid}).into((Structure)result, new StructureFields.NodeOriginInfo[]{StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl, StructureFields.NodeOriginInfo.reposUuid});
            if (!((Structure)result).hasField(StructureFields.NodeOriginInfo.copyRootAbsPath)) {
                readInfo.release();
                return result;
            }
        }
        boolean scanWorking = false;
        if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            scanWorking = true;
        } else if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            ISVNWCDb.WCDbInfo belowInfo = this.db.readInfoBelowWorking(localAbsPath);
            scanWorking = belowInfo.haveWork;
            status = belowInfo.status;
        }
        readInfo.release();
        if (scanWorking) {
            ISVNWCDb.WCDbAdditionInfo addInfo = this.db.scanAddition(localAbsPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.opRootAbsPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision);
            status = addInfo.status;
            ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.reposRootUrl, addInfo.originalRootUrl);
            ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.reposUuid, addInfo.originalUuid);
            ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.revision, addInfo.originalRevision);
            if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                return result;
            }
            File relPath = SVNFileUtil.createFilePath(addInfo.originalReposRelPath, SVNWCUtils.skipAncestor(addInfo.opRootAbsPath, localAbsPath));
            ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.reposRelpath, relPath);
            if (((Structure)result).hasField(StructureFields.NodeOriginInfo.copyRootAbsPath)) {
                ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.copyRootAbsPath, addInfo.opRootAbsPath);
            }
        } else {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid);
            ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.reposRootUrl, baseInfo.reposRootUrl);
            ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.reposUuid, baseInfo.reposUuid);
            ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.revision, baseInfo.revision);
            ((Structure)result).set((StructureFields.NodeOriginInfo)StructureFields.NodeOriginInfo.reposRelpath, baseInfo.reposRelPath);
        }
        return result;
    }

    public static boolean isErrorAccess(SVNException e) {
        SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
        return errorCode == SVNErrorCode.FS_NOT_FOUND;
    }

    public boolean isPropsModified(File localAbspath) throws SVNException {
        return this.db.readInfo((File)localAbspath, (ISVNWCDb.WCDbInfo.InfoField[])new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.propsMod}).propsMod;
    }

    public void nodeWalkChildren(File localAbspath, ISVNWCNodeHandler nodeHandler, boolean showHidden, SVNDepth walkDepth, Collection<String> changelists) throws SVNException {
        assert (walkDepth != null && walkDepth.getId() >= SVNDepth.EMPTY.getId() && walkDepth.getId() <= SVNDepth.INFINITY.getId());
        changelists = changelists != null && changelists.size() > 0 ? new HashSet<String>(changelists) : null;
        Structure<StructureFields.NodeInfo> nodeInfo = this.db.readInfo(localAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfo.get(StructureFields.NodeInfo.kind));
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        nodeInfo.release();
        if (this.matchesChangelist(localAbspath, changelists)) {
            nodeHandler.nodeFound(localAbspath, kind);
        }
        if (kind == ISVNWCDb.SVNWCDbKind.File || status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
            return;
        }
        if (kind == ISVNWCDb.SVNWCDbKind.Dir) {
            this.walkerHelper(localAbspath, nodeHandler, showHidden, walkDepth, changelists);
            return;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "''{0}'' has an unrecognized node kind", (Object)localAbspath);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchesChangelist(File localAbspath, Collection<String> changelists) {
        if (changelists == null || changelists.isEmpty()) {
            return true;
        }
        Structure<StructureFields.NodeInfo> nodeInfo = null;
        try {
            nodeInfo = this.db.readInfo(localAbspath, StructureFields.NodeInfo.changelist);
            boolean bl = nodeInfo != null && nodeInfo.hasValue(StructureFields.NodeInfo.changelist) && changelists.contains(nodeInfo.text(StructureFields.NodeInfo.changelist));
            return bl;
        }
        catch (SVNException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (nodeInfo != null) {
                nodeInfo.release();
            }
        }
    }

    private void walkerHelper(File dirAbspath, ISVNWCNodeHandler nodeHandler, boolean showHidden, SVNDepth depth, Collection<String> changelists) throws SVNException {
        if (depth == SVNDepth.EMPTY) {
            return;
        }
        Map<String, Structure<StructureFields.WalkerChildInfo>> relChildren = SvnWcDbReader.readWalkerChildrenInfo((SVNWCDb)this.db, dirAbspath, null);
        block3: for (String child : relChildren.keySet()) {
            this.checkCancelled();
            Structure<StructureFields.WalkerChildInfo> childInfo = relChildren.get(child);
            ISVNWCDb.SVNWCDbStatus childStatus = (ISVNWCDb.SVNWCDbStatus)((Object)childInfo.get(StructureFields.WalkerChildInfo.status));
            ISVNWCDb.SVNWCDbKind childKind = (ISVNWCDb.SVNWCDbKind)((Object)childInfo.get(StructureFields.WalkerChildInfo.kind));
            childInfo.release();
            if (!showHidden) {
                switch (childStatus) {
                    case NotPresent: 
                    case ServerExcluded: 
                    case Excluded: {
                        continue block3;
                    }
                }
            }
            File childAbspath = SVNFileUtil.createFilePath(dirAbspath, child);
            if ((childKind == ISVNWCDb.SVNWCDbKind.File || depth.getId() >= SVNDepth.IMMEDIATES.getId()) && this.matchesChangelist(childAbspath, changelists)) {
                nodeHandler.nodeFound(childAbspath, childKind);
            }
            if (childKind != ISVNWCDb.SVNWCDbKind.Dir || depth.getId() < SVNDepth.IMMEDIATES.getId()) continue;
            SVNDepth depth_below_here = depth;
            if (depth.getId() == SVNDepth.IMMEDIATES.getId()) {
                depth_below_here = SVNDepth.EMPTY;
            }
            this.walkerHelper(childAbspath, nodeHandler, showHidden, depth_below_here, changelists);
        }
    }

    public File acquireWriteLock(File localAbspath, boolean lockAnchor, boolean returnLockRoot) throws SVNException {
        localAbspath = this.obtainAnchorPath(localAbspath, lockAnchor, returnLockRoot);
        this.db.obtainWCLock(localAbspath, -1, false);
        return localAbspath;
    }

    public File obtainAnchorPath(File localAbspath, boolean lockAnchor, boolean returnLockRoot) throws SVNException {
        boolean isSwitched;
        boolean isWcRoot;
        SVNNodeKind kind;
        try {
            ISVNWCDb.SwitchedInfo switchedInfo = this.getDb().isSwitched(localAbspath);
            kind = switchedInfo.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
            isWcRoot = switchedInfo.isWcRoot;
            isSwitched = switchedInfo.isSwitched;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            kind = SVNNodeKind.NONE;
            isWcRoot = false;
            isSwitched = false;
        }
        if (lockAnchor && kind == SVNNodeKind.DIR && isWcRoot) {
            lockAnchor = false;
        }
        if (lockAnchor) {
            assert (returnLockRoot);
            File parentAbspath = SVNFileUtil.getParentFile(localAbspath);
            if (kind == SVNNodeKind.DIR) {
                if (!isSwitched) {
                    localAbspath = parentAbspath;
                }
            } else if (kind != SVNNodeKind.NONE && kind != SVNNodeKind.UNKNOWN) {
                localAbspath = parentAbspath;
            } else {
                SVNNodeKind parentKind;
                try {
                    parentKind = this.getDb().readKind(parentAbspath, true, true, false);
                }
                catch (SVNException e) {
                    if (!SVNWCContext.isNotCurrentWc(e)) {
                        throw e;
                    }
                    parentKind = SVNNodeKind.UNKNOWN;
                }
                if (parentKind != SVNNodeKind.DIR) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy", (Object)localAbspath);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                localAbspath = parentAbspath;
            }
        } else if (kind != SVNNodeKind.DIR) {
            localAbspath = SVNFileUtil.getParentFile(localAbspath);
        }
        return localAbspath;
    }

    private static boolean isNotCurrentWc(SVNException e) {
        return e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_UPGRADE_REQUIRED;
    }

    private boolean isChildDisjoint(File localAbspath) throws SVNException {
        boolean disjoint = this.db.isWCRoot(localAbspath);
        if (disjoint) {
            return disjoint;
        }
        File parentAbspath = SVNFileUtil.getFileDir(localAbspath);
        String base = SVNFileUtil.getFileName(localAbspath);
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid);
        SVNURL nodeReposRoot = readInfo.reposRootUrl;
        File nodeReposRelpath = readInfo.reposRelPath;
        String nodeReposUuid = readInfo.reposUuid;
        if (nodeReposRelpath == null) {
            disjoint = false;
            return disjoint;
        }
        readInfo = this.db.readInfo(parentAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid);
        ISVNWCDb.SVNWCDbStatus parentStatus = readInfo.status;
        SVNURL parentReposRoot = readInfo.reposRootUrl;
        File parentReposRelpath = readInfo.reposRelPath;
        String parentReposUuid = readInfo.reposUuid;
        if (parentReposRelpath == null) {
            if (parentStatus == ISVNWCDb.SVNWCDbStatus.Added) {
                ISVNWCDb.WCDbAdditionInfo scanAddition = this.db.scanAddition(parentAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid);
                parentReposRelpath = scanAddition.reposRelPath;
                parentReposRoot = scanAddition.reposRootUrl;
                parentReposUuid = scanAddition.reposUuid;
            } else {
                ISVNWCDb.WCDbRepositoryInfo scanBaseRepository = this.db.scanBaseRepository(parentAbspath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.values());
                parentReposRelpath = scanBaseRepository.relPath;
                parentReposRoot = scanBaseRepository.rootUrl;
                parentReposUuid = scanBaseRepository.uuid;
            }
        }
        disjoint = !parentReposRoot.equals(nodeReposRoot) || !parentReposUuid.equals(nodeReposUuid) || !SVNFileUtil.createFilePath(parentReposRelpath, base).equals(nodeReposRelpath);
        return disjoint;
    }

    public void releaseWriteLock(File localAbspath) throws SVNException {
        ISVNWCDb.WCDbWorkQueueInfo wqInfo = this.db.fetchWorkQueue(localAbspath);
        if (wqInfo.workItem != null) {
            return;
        }
        this.db.releaseWCLock(localAbspath);
    }

    public CheckWCRootInfo checkWCRoot(File localAbspath, boolean fetchSwitched) throws SVNException {
        boolean isRoot;
        CheckWCRootInfo info = new CheckWCRootInfo();
        info.wcRoot = true;
        info.switched = false;
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        info.kind = readInfo.kind;
        File reposRelpath = readInfo.reposRelPath;
        SVNURL reposRoot = readInfo.reposRootUrl;
        String reposUuid = readInfo.reposUuid;
        if (reposRelpath == null) {
            info.wcRoot = false;
            return info;
        }
        if (info.kind != ISVNWCDb.SVNWCDbKind.Dir) {
            info.wcRoot = false;
        } else if (status == ISVNWCDb.SVNWCDbStatus.Added || status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            info.wcRoot = false;
        } else {
            if (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
                return null;
            }
            if (SVNFileUtil.getParentFile(localAbspath) == null) {
                return info;
            }
        }
        if (!info.wcRoot && !fetchSwitched) {
            return info;
        }
        File parentAbspath = SVNFileUtil.getParentFile(localAbspath);
        String name = SVNFileUtil.getFileName(localAbspath);
        if (info.wcRoot && (isRoot = this.db.isWCRoot(localAbspath))) {
            return info;
        }
        ISVNWCDb.WCDbRepositoryInfo parent = this.db.scanBaseRepository(parentAbspath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
        if (!reposRoot.equals(parent.rootUrl) || !reposUuid.equals(parent.uuid)) {
            return info;
        }
        info.wcRoot = false;
        if (fetchSwitched) {
            File expectedRelpath = SVNFileUtil.createFilePath(parent.relPath, name);
            info.switched = !expectedRelpath.equals(reposRelpath);
        }
        return info;
    }

    public void exclude(File localAbspath) throws SVNException {
        String reposUuid;
        SVNURL reposRoot;
        File reposRelpath;
        long revision;
        ISVNWCDb.SVNWCDbKind kind;
        block11: {
            CheckWCRootInfo checkWCRoot = this.checkWCRoot(localAbspath, true);
            boolean isRoot = checkWCRoot.wcRoot;
            boolean isSwitched = checkWCRoot.switched;
            if (isRoot) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot exclude ''{0}'': it is a working copy root", (Object)localAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
                return;
            }
            if (isSwitched) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot exclude ''{0}'': it is a switched path", (Object)localAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
                return;
            }
            ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid, ISVNWCDb.WCDbInfo.InfoField.haveBase);
            ISVNWCDb.SVNWCDbStatus status = readInfo.status;
            kind = readInfo.kind;
            revision = readInfo.revision;
            reposRelpath = readInfo.reposRelPath;
            reposRoot = readInfo.reposRootUrl;
            reposUuid = readInfo.reposUuid;
            boolean haveBase = readInfo.haveBase;
            switch (status) {
                case NotPresent: 
                case ServerExcluded: 
                case Excluded: {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL);
                    SVNErrorManager.error(err, SVNLogType.WC);
                    return;
                }
                case Added: {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot exclude ''{0}'': it is to be added to the repository. Try commit instead", (Object)localAbspath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                    return;
                }
                case Deleted: {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot exclude ''{0}'': it is to be deleted from the repository. Try commit instead", (Object)localAbspath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                    return;
                }
            }
            if (haveBase) {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid);
                kind = baseInfo.kind;
                revision = baseInfo.revision;
                reposRelpath = baseInfo.reposRelPath;
                reposRoot = baseInfo.reposRootUrl;
                reposUuid = baseInfo.reposUuid;
            }
            try {
                this.removeFromRevisionControl(localAbspath, true, false);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) break block11;
                throw e;
            }
        }
        this.db.addBaseExcludedNode(localAbspath, reposRelpath, reposRoot, reposUuid, revision, kind, ISVNWCDb.SVNWCDbStatus.Excluded, null, null);
        if (this.getEventHandler() != null) {
            SVNEvent event = new SVNEvent(localAbspath, null, null, -1L, null, null, null, null, SVNEventAction.DELETE, null, null, null, null, null, null);
            this.getEventHandler().handleEvent(event, 0.0);
        }
    }

    public static CheckSpecialInfo checkSpecialPath(File localAbspath) {
        CheckSpecialInfo info = new CheckSpecialInfo();
        SVNFileType fileType = SVNFileType.getType(localAbspath);
        info.kind = SVNFileType.getNodeKind(fileType);
        info.isSpecial = !SVNFileUtil.symlinksSupported() ? false : fileType == SVNFileType.SYMLINK;
        return info;
    }

    public void removeFromRevisionControl(File localAbspath, boolean destroyWf, boolean instantError) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        this.checkCancelled();
        boolean leftSomething = false;
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind);
        ISVNWCDb.SVNWCDbKind kind = readInfo.kind;
        if (kind == ISVNWCDb.SVNWCDbKind.File || kind == ISVNWCDb.SVNWCDbKind.Symlink) {
            boolean localSpecial;
            boolean wcSpecial;
            SvnChecksum workingSha1Checksum;
            SvnChecksum baseSha1Checksum;
            boolean textModified;
            block26: {
                block25: {
                    textModified = false;
                    baseSha1Checksum = null;
                    workingSha1Checksum = null;
                    wcSpecial = this.isSpecial(localAbspath);
                    CheckSpecialInfo checkSpecialPath = SVNWCContext.checkSpecialPath(localAbspath);
                    localSpecial = checkSpecialPath.isSpecial;
                    if ((wcSpecial || !localSpecial) && (textModified = this.isTextModified(localAbspath, false)) && instantError) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD, "File ''{0}'' has local modifications", (Object)localAbspath);
                        SVNErrorManager.error(err, SVNLogType.WC);
                        return;
                    }
                    try {
                        baseSha1Checksum = this.db.getBaseInfo((File)localAbspath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum}).checksum;
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block25;
                        throw e;
                    }
                }
                try {
                    workingSha1Checksum = this.db.readInfo((File)localAbspath, (ISVNWCDb.WCDbInfo.InfoField[])new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.checksum}).checksum;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block26;
                    throw e;
                }
            }
            this.db.opRemoveEntryTemp(localAbspath);
            if (baseSha1Checksum != null) {
                this.db.removePristine(localAbspath, baseSha1Checksum);
            }
            if (workingSha1Checksum != null && !workingSha1Checksum.equals(baseSha1Checksum)) {
                this.db.removePristine(localAbspath, workingSha1Checksum);
            }
            if (destroyWf) {
                if (!wcSpecial && localSpecial || textModified) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD);
                    SVNErrorManager.error(err, SVNLogType.WC);
                    return;
                }
                SVNFileUtil.deleteFile(localAbspath);
            }
        } else {
            Set<String> children = this.db.readChildren(localAbspath);
            for (String entryName : children) {
                File entryAbspath = SVNFileUtil.createFilePath(localAbspath, entryName);
                boolean hidden = this.db.isNodeHidden(entryAbspath);
                if (hidden) {
                    this.db.opRemoveEntryTemp(entryAbspath);
                    continue;
                }
                try {
                    this.removeFromRevisionControl(entryAbspath, destroyWf, instantError);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                        if (instantError) {
                            throw e;
                        }
                        leftSomething = true;
                        continue;
                    }
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.IO_ERROR) {
                        if (instantError) {
                            throw e;
                        }
                        leftSomething = true;
                        continue;
                    }
                    throw e;
                }
            }
            boolean isRoot = this.checkWCRoot((File)localAbspath, (boolean)false).wcRoot;
            if (!isRoot) {
                this.db.opRemoveEntryTemp(localAbspath);
            }
            this.destroyAdm(localAbspath);
            if (destroyWf && !leftSomething) {
                try {
                    SVNFileUtil.deleteFile(localAbspath);
                }
                catch (SVNException e) {
                    leftSomething = true;
                }
            }
        }
        if (leftSomething) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private void destroyAdm(File dirAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(dirAbspath));
        this.writeCheck(dirAbspath);
        File admAbspath = this.db.getWCRoot(dirAbspath);
        this.db.forgetDirectoryTemp(dirAbspath);
        if (admAbspath.equals(dirAbspath)) {
            SVNFileUtil.deleteAll(SVNWCUtils.admChild(admAbspath, null), true, this.getEventHandler());
        }
    }

    public void cropTree(File localAbspath, SVNDepth depth) throws SVNException {
        if (depth == SVNDepth.INFINITY) {
            return;
        }
        if (depth.getId() <= SVNDepth.EXCLUDE.getId() || depth.getId() >= SVNDepth.INFINITY.getId()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Can only crop a working copy with a restrictive depth");
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        ISVNWCDb.SVNWCDbKind kind = readInfo.kind;
        if (kind != ISVNWCDb.SVNWCDbKind.Dir) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Can only crop directories");
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        if (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot crop ''{0}'': it is going to be removed from repository. Try commit instead", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot crop ''{0}'': it is to be added to the repository. Try commit instead", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        this.cropChildren(localAbspath, depth);
    }

    /*
     * Unable to fully structure code
     */
    private void cropChildren(File localAbspath, SVNDepth depth) throws SVNException {
        if (!(SVNWCContext.$assertionsDisabled || depth.getId() >= SVNDepth.EMPTY.getId() && depth.getId() <= SVNDepth.INFINITY.getId())) {
            throw new AssertionError();
        }
        this.checkCancelled();
        dirDepth = this.db.readInfo((File)localAbspath, (ISVNWCDb.WCDbInfo.InfoField[])new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.depth}).depth;
        if (dirDepth == SVNDepth.UNKNOWN) {
            dirDepth = SVNDepth.INFINITY;
        }
        if (dirDepth.getId() > depth.getId()) {
            this.db.opSetDirDepthTemp(localAbspath, depth);
        }
        children = this.db.readChildren(localAbspath);
        for (String childName : children) {
            block11: {
                childAbspath = SVNFileUtil.createFilePath(localAbspath, childName);
                readInfo = this.db.readInfo(childAbspath, new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.depth});
                childStatus = readInfo.status;
                kind = readInfo.kind;
                if (childStatus == ISVNWCDb.SVNWCDbStatus.ServerExcluded || childStatus == ISVNWCDb.SVNWCDbStatus.Excluded || childStatus == ISVNWCDb.SVNWCDbStatus.NotPresent) {
                    v0 = removeBelow = kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.IMMEDIATES : SVNDepth.FILES;
                    if (depth.getId() >= removeBelow.getId()) continue;
                    this.db.opRemoveEntryTemp(localAbspath);
                    continue;
                }
                if (kind != ISVNWCDb.SVNWCDbKind.File) break block11;
                if (depth != SVNDepth.EMPTY) continue;
                try {
                    this.removeFromRevisionControl(childAbspath, true, false);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) ** GOTO lbl42
                    throw e;
                }
            }
            if (kind != ISVNWCDb.SVNWCDbKind.Dir) ** GOTO lbl39
            if (depth.getId() < SVNDepth.IMMEDIATES.getId()) {
                try {
                    this.removeFromRevisionControl(childAbspath, true, false);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) ** GOTO lbl42
                    throw e;
                }
            } else {
                this.cropChildren(childAbspath, SVNDepth.EMPTY);
                continue;
lbl39:
                // 1 sources

                err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown node kind for ''{0}''", (Object)childAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
                return;
            }
lbl42:
            // 4 sources

            if (this.getEventHandler() == null) continue;
            event = new SVNEvent(childAbspath, null, null, -1L, null, null, null, null, SVNEventAction.DELETE, null, null, null, null, null, null);
            this.getEventHandler().handleEvent(event, 0.0);
        }
    }

    public SVNWCNodeReposInfo getNodeReposInfo(File localAbspath) throws SVNException {
        ISVNWCDb.SVNWCDbStatus status;
        SVNWCNodeReposInfo info = new SVNWCNodeReposInfo();
        info.reposRootUrl = null;
        info.reposUuid = null;
        info.revision = -1L;
        try {
            ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.revision);
            status = readInfo.status;
            info.reposRootUrl = readInfo.reposRootUrl;
            info.reposUuid = readInfo.reposUuid;
            info.reposRelPath = readInfo.reposRelPath;
            info.revision = readInfo.revision;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND && e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_WORKING_COPY) {
                throw e;
            }
            return info;
        }
        if (info.reposRootUrl != null && info.reposUuid != null) {
            return info;
        }
        ISVNWCDb.WCDbRepositoryInfo reposInfo = null;
        ISVNWCDb.WCDbAdditionInfo addInfo = null;
        if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            ISVNWCDb.WCDbDeletionInfo dinfo = this.db.scanDeletion(localAbspath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.workDelAbsPath);
            if (dinfo.baseDelAbsPath != null) {
                reposInfo = this.db.scanBaseRepository(dinfo.baseDelAbsPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath);
            } else if (dinfo.workDelAbsPath != null) {
                addInfo = this.db.scanAddition(SVNFileUtil.getParentFile(dinfo.workDelAbsPath), ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath);
                ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision);
                info.revision = baseInfo.revision;
            }
        } else if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            addInfo = this.db.scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath);
        } else {
            reposInfo = this.db.scanBaseRepository(localAbspath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath);
        }
        if (addInfo != null) {
            info.reposRootUrl = addInfo.reposRootUrl;
            info.reposUuid = addInfo.reposUuid;
            info.reposRelPath = addInfo.reposRelPath;
        } else if (reposInfo != null) {
            info.reposRootUrl = reposInfo.rootUrl;
            info.reposUuid = reposInfo.uuid;
            info.reposRelPath = reposInfo.relPath;
        }
        return info;
    }

    public SVNTreeConflictDescription getTreeConflict(File victimAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(victimAbspath));
        return this.db.opReadTreeConflict(victimAbspath);
    }

    public void writeCheck(File localAbspath) throws SVNException {
        SVNWCContext.writeCheck(this.getDb(), localAbspath);
    }

    public static void writeCheck(ISVNWCDb db, File localAbspath) throws SVNException {
        boolean locked = db.isWCLockOwns(localAbspath, false);
        if (!locked) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "No write-lock in ''{0}''", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    public SVNProperties getPristineProps(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        ISVNWCDb.SVNWCDbStatus status = this.db.readInfo((File)localAbspath, (ISVNWCDb.WCDbInfo.InfoField[])new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.status}).status;
        if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            status = this.db.scanAddition((File)localAbspath, (ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[])new ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[]{ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status}).status;
        }
        if (status == ISVNWCDb.SVNWCDbStatus.Added || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
            return null;
        }
        return this.db.readPristineProperties(localAbspath);
    }

    public SVNProperties getActualProps(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        return this.db.readProperties(localAbspath);
    }

    public MergePropertiesInfo mergeProperties(File localAbsPath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, SVNProperties baseProperties, SVNProperties propChanges, boolean dryRun, ISVNConflictHandler conflictResolver) throws SVNException {
        Object err;
        Structure<StructureFields.NodeInfo> info = this.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod, StructureFields.NodeInfo.haveBase);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)info.get(StructureFields.NodeInfo.status));
        if (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbsPath);
            SVNErrorManager.error((SVNErrorMessage)err, SVNLogType.WC);
        } else if (status != ISVNWCDb.SVNWCDbStatus.Normal && status != ISVNWCDb.SVNWCDbStatus.Added && status != ISVNWCDb.SVNWCDbStatus.Incomplete) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "The node ''{0}'' does not have properties in this state.", (Object)localAbsPath);
            SVNErrorManager.error((SVNErrorMessage)err, SVNLogType.WC);
        }
        for (String propName : propChanges.nameSet()) {
            if (SVNProperty.isRegularProperty(propName)) continue;
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "The property ''{0}'' may not be merged into ''{1}''", propName, localAbsPath);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        SVNProperties pristineProps = null;
        if (info.is(StructureFields.NodeInfo.hadProps)) {
            pristineProps = this.getPristineProps(localAbsPath);
        }
        if (pristineProps == null) {
            pristineProps = new SVNProperties();
        }
        SVNProperties actualProps = info.is(StructureFields.NodeInfo.propsMod) ? this.getActualProperties(localAbsPath) : new SVNProperties(pristineProps);
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.NodeInfo.kind));
        info.release();
        MergePropertiesInfo result = this.mergeProperties2(null, localAbsPath, kind, leftVersion, rightVersion, baseProperties, pristineProps, actualProps, propChanges, false, dryRun, conflictResolver);
        if (dryRun) {
            return result;
        }
        File dirAbsPath = kind == ISVNWCDb.SVNWCDbKind.Dir ? localAbsPath : SVNFileUtil.getParentFile(localAbsPath);
        this.writeCheck(dirAbsPath);
        SVNSkel workItems = result.workItems;
        this.getDb().opSetProps(localAbsPath, result.newActualProperties, result.conflictSkel, SVNWCContext.hasMagicProperty(propChanges), workItems);
        this.wqRun(localAbsPath);
        return result;
    }

    public MergePropertiesInfo mergeProperties2(MergePropertiesInfo mergeInfo, File localAbsPath, ISVNWCDb.SVNWCDbKind kind, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, SVNProperties serverBaseProperties, SVNProperties pristineProperties, SVNProperties actualProperties, SVNProperties propChanges, boolean baseMerge, boolean dryRun, ISVNConflictHandler conflictResolver) throws SVNException {
        if (serverBaseProperties == null) {
            serverBaseProperties = pristineProperties;
        }
        if (mergeInfo == null) {
            mergeInfo = new MergePropertiesInfo();
        }
        mergeInfo.mergeOutcome = SVNStatusType.UNCHANGED;
        DefaultSvnMerger defaultMerger = this.createDefaultMerger();
        ISvnMerger customMerger = this.createCustomMerger();
        SvnMergeResult result = customMerger != null ? customMerger.mergeProperties(defaultMerger, localAbsPath, kind == null ? SVNNodeKind.UNKNOWN : kind.toNodeKind(), leftVersion, rightVersion, serverBaseProperties, pristineProperties, actualProperties, propChanges, baseMerge, dryRun, conflictResolver) : defaultMerger.mergeProperties(null, localAbsPath, kind == null ? SVNNodeKind.UNKNOWN : kind.toNodeKind(), leftVersion, rightVersion, serverBaseProperties, pristineProperties, actualProperties, propChanges, baseMerge, dryRun, conflictResolver);
        mergeInfo.mergeOutcome = result.getMergeOutcome();
        mergeInfo.newActualProperties = result.getActualProperties();
        mergeInfo.newBaseProperties = result.getBaseProperties();
        mergeInfo.workItems = defaultMerger.getWorkItems();
        mergeInfo.conflictSkel = result.getConflictSkel();
        return mergeInfo;
    }

    public MergePropertiesInfo mergeProperties3(MergePropertiesInfo mergePropertiesInfo, File localAbsPath, SVNProperties serverBaseProps, SVNProperties pristineProps, SVNProperties actualProps, SVNProperties propChanges) throws SVNException {
        if (mergePropertiesInfo == null) {
            mergePropertiesInfo = new MergePropertiesInfo();
        }
        HashSet<String> conflictProps = null;
        mergePropertiesInfo.newActualProperties = new SVNProperties(actualProps);
        if (serverBaseProps == null) {
            serverBaseProps = pristineProps;
        }
        SVNProperties theirProps = new SVNProperties(serverBaseProps);
        mergePropertiesInfo.mergeOutcome = SVNStatusType.UNCHANGED;
        Set<String> propertyNames = propChanges.nameSet();
        for (String propertyName : propertyNames) {
            boolean conflictRemains;
            MergePropStatusInfo propStatusInfo;
            SVNPropertyValue baseVal = pristineProps.getSVNPropertyValue(propertyName);
            SVNPropertyValue fromVal = serverBaseProps.getSVNPropertyValue(propertyName);
            SVNPropertyValue toVal = propChanges.getSVNPropertyValue(propertyName);
            SVNPropertyValue workingVal = actualProps.getSVNPropertyValue(propertyName);
            boolean didMerge = false;
            if (toVal == null) {
                theirProps.remove(propertyName);
            } else {
                theirProps.put(propertyName, toVal);
            }
            mergePropertiesInfo.mergeOutcome = this.setPropMergeState(mergePropertiesInfo.mergeOutcome, SVNStatusType.CHANGED);
            SVNPropertyValue resultVal = workingVal;
            if (fromVal == null) {
                propStatusInfo = this.applySinglePropAdd(resultVal, didMerge, propertyName, baseVal, toVal, workingVal);
                resultVal = propStatusInfo.resultVal;
                conflictRemains = propStatusInfo.conflictRemains;
                didMerge = propStatusInfo.didMerge;
            } else if (toVal == null) {
                propStatusInfo = this.applySinglePropDelete(resultVal, didMerge, baseVal, fromVal, workingVal);
                resultVal = propStatusInfo.resultVal;
                conflictRemains = propStatusInfo.conflictRemains;
                didMerge = propStatusInfo.didMerge;
            } else {
                propStatusInfo = this.applySinglePropChange(resultVal, didMerge, propertyName, baseVal, fromVal, toVal, workingVal);
                resultVal = propStatusInfo.resultVal;
                conflictRemains = propStatusInfo.conflictRemains;
                didMerge = propStatusInfo.didMerge;
            }
            if (resultVal != workingVal) {
                mergePropertiesInfo.newActualProperties.put(propertyName, resultVal);
            }
            if (didMerge) {
                mergePropertiesInfo.mergeOutcome = this.setPropMergeState(mergePropertiesInfo.mergeOutcome, SVNStatusType.MERGED);
            }
            if (conflictRemains) {
                mergePropertiesInfo.mergeOutcome = this.setPropMergeState(mergePropertiesInfo.mergeOutcome, SVNStatusType.CONFLICTED);
                if (conflictProps == null) {
                    conflictProps = new HashSet<String>();
                }
                conflictProps.add(propertyName);
            }
            if (conflictProps == null) continue;
            if (mergePropertiesInfo.conflictSkel == null) {
                mergePropertiesInfo.conflictSkel = SvnWcDbConflicts.createConflictSkel();
            }
            SvnWcDbConflicts.addPropConflict(mergePropertiesInfo.conflictSkel, this.getDb(), localAbsPath, null, actualProps, serverBaseProps, theirProps, conflictProps);
        }
        if (mergePropertiesInfo.newActualProperties != null) {
            mergePropertiesInfo.newActualProperties.removeNullValues();
        }
        return mergePropertiesInfo;
    }

    private ISvnMerger createCustomMerger() {
        ISVNMerger merger;
        if (this.getOptions() != null && this.getOptions().getMergerFactory() != null && (merger = this.getOptions().getMergerFactory().createMerger(CONFLICT_START, CONFLICT_END, CONFLICT_SEPARATOR)) instanceof ISvnMerger) {
            return (ISvnMerger)merger;
        }
        return null;
    }

    private DefaultSvnMerger createDefaultMerger() {
        return new DefaultSvnMerger(this);
    }

    File getPrejfileAbspath(File localAbspath) throws SVNException {
        List<SVNConflictDescription> conflicts = this.db.readConflicts(localAbspath);
        for (SVNConflictDescription cd : conflicts) {
            if (!cd.isPropertyConflict()) continue;
            if (cd.getMergeFiles().getRepositoryPath().equals("dir_conflicts.prej")) {
                return SVNFileUtil.createFilePath(localAbspath, "dir_conflicts.prej");
            }
            return SVNFileUtil.createFilePath(cd.getMergeFiles().getRepositoryPath());
        }
        return null;
    }

    void conflictSkelAddPropConflict(SVNSkel skel, String propName, SVNPropertyValue baseVal, SVNPropertyValue mineVal, SVNPropertyValue toVal, SVNPropertyValue fromVal) throws SVNException {
        SVNSkel propSkel = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependPropValue(fromVal, propSkel);
        SvnWcDbConflicts.prependPropValue(toVal, propSkel);
        SvnWcDbConflicts.prependPropValue(mineVal, propSkel);
        SvnWcDbConflicts.prependPropValue(baseVal, propSkel);
        propSkel.prependString(propName);
        propSkel.prependString(CONFLICT_KIND_PROP);
        skel.appendChild(propSkel);
    }

    SVNStatusType setPropMergeState(SVNStatusType state, SVNStatusType newValue) {
        if (state == null) {
            return null;
        }
        int statusInd = STATUS_ORDERING.indexOf(state);
        int newStatusInd = STATUS_ORDERING.indexOf(newValue);
        if (newStatusInd <= statusInd) {
            return state;
        }
        return newValue;
    }

    MergePropStatusInfo applySinglePropAdd(SVNPropertyValue resultVal, boolean didMerge, String propName, SVNPropertyValue pristineVal, SVNPropertyValue newVal, SVNPropertyValue workingVal) throws SVNException {
        boolean conflictRemains = false;
        if (workingVal != null) {
            if (SVNPropertyValue.areEqual(workingVal, newVal)) {
                didMerge = true;
            } else {
                boolean mergedProp;
                block10: {
                    mergedProp = false;
                    if (propName.equals("svn:mergeinfo")) {
                        try {
                            String mergedValString = SVNMergeInfoUtil.combineMergeInfoProperties(workingVal.getString(), newVal.getString());
                            SVNPropertyValue mergedVal = SVNPropertyValue.create(mergedValString);
                            mergedProp = true;
                            resultVal = mergedVal;
                            didMerge = true;
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) break block10;
                            throw e;
                        }
                    }
                }
                if (!mergedProp) {
                    conflictRemains = true;
                }
            }
        } else if (pristineVal != null) {
            conflictRemains = true;
        } else {
            resultVal = newVal;
        }
        MergePropStatusInfo propStatusInfo = new MergePropStatusInfo();
        propStatusInfo.conflictRemains = conflictRemains;
        propStatusInfo.resultVal = resultVal;
        propStatusInfo.didMerge = didMerge;
        return propStatusInfo;
    }

    MergePropStatusInfo applySinglePropAdd(SVNStatusType state, File localAbspath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, boolean isDir, SVNProperties workingProps, String propname, SVNPropertyValue baseVal, SVNPropertyValue toVal, ISVNConflictHandler conflictResolver, boolean dryRun) throws SVNException {
        boolean conflictRemains = false;
        SVNPropertyValue workingVal = workingProps.getSVNPropertyValue(propname);
        if (workingVal != null) {
            if (workingVal.equals(toVal)) {
                state = this.setPropMergeState(state, SVNStatusType.MERGED);
            } else {
                boolean mergedProp;
                block10: {
                    mergedProp = false;
                    if ("svn:mergeinfo".equals(propname)) {
                        try {
                            String mergedVal = SVNMergeInfoUtil.combineMergeInfoProperties(workingVal.getString(), toVal.getString());
                            workingProps.put(propname, mergedVal);
                            state = this.setPropMergeState(state, SVNStatusType.MERGED);
                            mergedProp = true;
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) break block10;
                            throw e;
                        }
                    }
                }
                if (!mergedProp) {
                    conflictRemains = true;
                }
            }
        } else if (baseVal != null) {
            conflictRemains = this.maybeGeneratePropConflict(localAbspath, leftVersion, rightVersion, isDir, propname, workingProps, null, toVal, baseVal, null, conflictResolver, dryRun);
        } else {
            workingProps.put(propname, toVal);
        }
        return new MergePropStatusInfo(state, conflictRemains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeGeneratePropConflict(File localAbspath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, boolean isDir, String propname, SVNProperties workingProps, SVNPropertyValue oldVal, SVNPropertyValue newVal, SVNPropertyValue baseVal, SVNPropertyValue workingVal, ISVNConflictHandler conflictResolver, boolean dryRun) throws SVNException {
        if (conflictResolver == null || dryRun) {
            return true;
        }
        oldVal = oldVal == null || oldVal.getString() == null && oldVal.getBytes() == null ? null : oldVal;
        newVal = newVal == null || newVal.getString() == null && newVal.getBytes() == null ? null : newVal;
        baseVal = baseVal == null || baseVal.getString() == null && baseVal.getBytes() == null ? null : baseVal;
        workingVal = workingVal == null || workingVal.getString() == null && workingVal.getBytes() == null ? null : workingVal;
        boolean conflictRemains = false;
        SVNWCConflictDescription17 cdesc = SVNWCConflictDescription17.createProp(localAbspath, isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE, propname);
        cdesc.setSrcLeftVersion(leftVersion);
        cdesc.setSrcRightVersion(rightVersion);
        try {
            SVNConflictChoice conflictChoice;
            if (workingVal != null) {
                cdesc.setMyFile(this.writeUnique(localAbspath, SVNPropertyValue.getPropertyAsBytes(workingVal)));
            }
            if (newVal != null) {
                cdesc.setTheirFile(this.writeUnique(localAbspath, SVNPropertyValue.getPropertyAsBytes(newVal)));
            }
            if (baseVal != null || oldVal != null) {
                SVNPropertyValue theVal;
                if (baseVal != null && oldVal == null || baseVal == null && oldVal != null) {
                    theVal = baseVal != null ? baseVal : oldVal;
                    cdesc.setBaseFile(this.writeUnique(localAbspath, SVNPropertyValue.getPropertyAsBytes(theVal)));
                } else {
                    theVal = !baseVal.equals(oldVal) ? (workingVal != null && baseVal.equals(workingVal) ? oldVal : baseVal) : baseVal;
                    cdesc.setBaseFile(this.writeUnique(localAbspath, SVNPropertyValue.getPropertyAsBytes(theVal)));
                    if (workingVal != null && newVal != null) {
                        FSMergerBySequence merger = new FSMergerBySequence(CONFLICT_START, CONFLICT_SEPARATOR, CONFLICT_END);
                        OutputStream result = null;
                        try {
                            cdesc.setMergedFile(SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(localAbspath), SVNFileUtil.getFileName(localAbspath), ".tmp", false));
                            result = SVNFileUtil.openFileForWriting(cdesc.getMergedFile());
                            QSequenceLineRAByteData baseData = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(theVal));
                            QSequenceLineRAByteData localData = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(workingVal));
                            QSequenceLineRAByteData latestData = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(newVal));
                            merger.merge(baseData, localData, latestData, null, result, null);
                        }
                        catch (IOException e) {
                            try {
                                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                                SVNErrorManager.error(err, e, SVNLogType.WC);
                            }
                            catch (Throwable throwable) {
                                SVNFileUtil.closeFile(result);
                                throw throwable;
                            }
                            SVNFileUtil.closeFile(result);
                        }
                        SVNFileUtil.closeFile(result);
                    }
                }
            }
            String mimePropval = null;
            if (!isDir && workingProps != null) {
                mimePropval = workingProps.getStringValue("svn:mime-type");
            }
            cdesc.setMimeType(mimePropval);
            cdesc.setBinary(mimePropval != null ? SVNProperty.mimeTypeIsBinary(mimePropval) : false);
            if (oldVal == null && newVal != null) {
                cdesc.setAction(SVNConflictAction.ADD);
            } else if (oldVal != null && newVal == null) {
                cdesc.setAction(SVNConflictAction.DELETE);
            } else {
                cdesc.setAction(SVNConflictAction.EDIT);
            }
            if (baseVal != null && workingVal == null) {
                cdesc.setReason(SVNConflictReason.DELETED);
            } else if (baseVal == null && workingVal != null) {
                cdesc.setReason(SVNConflictReason.OBSTRUCTED);
            } else {
                cdesc.setReason(SVNConflictReason.EDITED);
            }
            SVNConflictResult result = null;
            SVNConflictDescription cd = cdesc.toConflictDescription();
            result = conflictResolver.handleConflict(cd);
            if (result == null) {
                conflictRemains = true;
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no results.");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((conflictChoice = result.getConflictChoice()) == SVNConflictChoice.POSTPONE) {
                conflictRemains = true;
            } else if (conflictChoice == SVNConflictChoice.MINE_FULL) {
                conflictRemains = false;
            } else if (conflictChoice == SVNConflictChoice.THEIRS_FULL) {
                workingProps.put(propname, newVal);
                conflictRemains = false;
            } else if (conflictChoice == SVNConflictChoice.BASE) {
                workingProps.put(propname, baseVal);
                conflictRemains = false;
            } else if (conflictChoice == SVNConflictChoice.MERGED) {
                if (cdesc.getMergedFile() == null && result.getMergedFile() == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no merged file.");
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else {
                    String mergedString = SVNFileUtil.readFile(result.getMergedFile() != null ? result.getMergedFile() : cdesc.getMergedFile());
                    workingProps.put(propname, mergedString);
                    conflictRemains = false;
                }
            } else {
                conflictRemains = true;
            }
            boolean bl = conflictRemains;
            return bl;
        }
        finally {
            SVNFileUtil.deleteFile(cdesc.getBaseFile());
            SVNFileUtil.deleteFile(cdesc.getMyFile());
            SVNFileUtil.deleteFile(cdesc.getTheirFile());
            SVNFileUtil.deleteFile(cdesc.getMergedFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeUnique(File path, byte[] value) throws SVNException {
        File tmpPath = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(path), SVNFileUtil.getFileName(path), ".tmp", false);
        OutputStream os = SVNFileUtil.openFileForWriting(tmpPath);
        try {
            os.write(value);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(os);
        }
        return tmpPath;
    }

    MergePropStatusInfo applySinglePropDelete(SVNPropertyValue resultVal, boolean didMerge, SVNPropertyValue baseVal, SVNPropertyValue oldVal, SVNPropertyValue workingVal) {
        boolean conflictRemains = false;
        if (baseVal == null) {
            if (workingVal != null && !SVNPropertyValue.areEqual(workingVal, oldVal)) {
                conflictRemains = true;
            } else {
                resultVal = null;
                if (oldVal != null) {
                    didMerge = true;
                }
            }
        } else if (SVNPropertyValue.areEqual(baseVal, oldVal)) {
            if (workingVal != null) {
                if (SVNPropertyValue.areEqual(workingVal, oldVal)) {
                    resultVal = null;
                } else {
                    conflictRemains = true;
                }
            } else {
                didMerge = true;
            }
        } else {
            conflictRemains = true;
        }
        MergePropStatusInfo propStatusInfo = new MergePropStatusInfo();
        propStatusInfo.didMerge = didMerge;
        propStatusInfo.conflictRemains = conflictRemains;
        propStatusInfo.resultVal = resultVal;
        return propStatusInfo;
    }

    MergePropStatusInfo applySinglePropDelete(SVNStatusType state, File localAbspath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, boolean isDir, SVNProperties workingProps, String propname, SVNPropertyValue baseVal, SVNPropertyValue oldVal, ISVNConflictHandler conflictResolver, boolean dryRun) throws SVNException {
        boolean conflictRemains = false;
        SVNPropertyValue workingVal = workingProps.getSVNPropertyValue(propname);
        if (baseVal == null) {
            if (workingVal != null && !workingVal.equals(oldVal)) {
                conflictRemains = this.maybeGeneratePropConflict(localAbspath, leftVersion, rightVersion, isDir, propname, workingProps, oldVal, null, baseVal, workingVal, conflictResolver, dryRun);
            } else {
                workingProps.remove(propname);
                if (oldVal != null) {
                    state = this.setPropMergeState(state, SVNStatusType.MERGED);
                }
            }
        } else if (baseVal.equals(oldVal)) {
            if (workingVal != null) {
                if (workingVal.equals(oldVal)) {
                    workingProps.remove(propname);
                } else {
                    conflictRemains = this.maybeGeneratePropConflict(localAbspath, leftVersion, rightVersion, isDir, propname, workingProps, oldVal, null, baseVal, workingVal, conflictResolver, dryRun);
                }
            } else {
                state = this.setPropMergeState(state, SVNStatusType.MERGED);
            }
        } else {
            conflictRemains = this.maybeGeneratePropConflict(localAbspath, leftVersion, rightVersion, isDir, propname, workingProps, oldVal, null, baseVal, workingVal, conflictResolver, dryRun);
        }
        return new MergePropStatusInfo(state, conflictRemains);
    }

    MergePropStatusInfo applySinglePropChange(SVNPropertyValue resultVal, boolean didMerge, String propName, SVNPropertyValue baseVal, SVNPropertyValue oldVal, SVNPropertyValue newVal, SVNPropertyValue workingVal) throws SVNException {
        MergePropStatusInfo propStatusInfo;
        boolean conflictRemains;
        boolean mergedProp;
        block4: {
            mergedProp = false;
            conflictRemains = false;
            if (propName.equals("svn:mergeinfo")) {
                try {
                    propStatusInfo = this.applySingleMergeInfoPropChange(resultVal, didMerge, baseVal, oldVal, newVal, workingVal);
                    resultVal = propStatusInfo.resultVal;
                    didMerge = propStatusInfo.didMerge;
                    conflictRemains = propStatusInfo.conflictRemains;
                    mergedProp = true;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) break block4;
                    throw e;
                }
            }
        }
        if (!mergedProp) {
            propStatusInfo = this.applySingleGenericPropChange(resultVal, didMerge, oldVal, newVal, workingVal);
            resultVal = propStatusInfo.resultVal;
            conflictRemains = propStatusInfo.conflictRemains;
            didMerge = propStatusInfo.didMerge;
        }
        propStatusInfo = new MergePropStatusInfo();
        propStatusInfo.didMerge = didMerge;
        propStatusInfo.resultVal = resultVal;
        propStatusInfo.conflictRemains = conflictRemains;
        return propStatusInfo;
    }

    MergePropStatusInfo applySinglePropChange(SVNStatusType state, File localAbspath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, boolean isDir, SVNProperties workingProps, String propname, SVNPropertyValue baseVal, SVNPropertyValue oldVal, SVNPropertyValue newVal, ISVNConflictHandler conflictResolver, boolean dryRun) throws SVNException {
        if ("svn:mergeinfo".equals(propname)) {
            return this.applySingleMergeinfoPropChange(state, localAbspath, leftVersion, rightVersion, isDir, workingProps, propname, baseVal, oldVal, newVal, conflictResolver, dryRun);
        }
        return this.applySingleGenericPropChange(state, localAbspath, leftVersion, rightVersion, isDir, workingProps, propname, baseVal, oldVal, newVal, conflictResolver, dryRun);
    }

    private MergePropStatusInfo applySingleGenericPropChange(SVNPropertyValue resultVal, boolean didMerge, SVNPropertyValue oldVal, SVNPropertyValue newVal, SVNPropertyValue workingVal) {
        assert (oldVal != null);
        boolean conflictRemains = false;
        if (workingVal != null && newVal != null && SVNPropertyValue.areEqual(workingVal, newVal)) {
            if (oldVal == null || !SVNPropertyValue.areEqual(oldVal, newVal)) {
                didMerge = true;
            }
        } else if (workingVal != null && oldVal != null && SVNPropertyValue.areEqual(workingVal, oldVal)) {
            resultVal = newVal;
        } else {
            conflictRemains = true;
        }
        MergePropStatusInfo propStatusInfo = new MergePropStatusInfo();
        propStatusInfo.resultVal = resultVal;
        propStatusInfo.didMerge = didMerge;
        propStatusInfo.conflictRemains = conflictRemains;
        return propStatusInfo;
    }

    private MergePropStatusInfo applySingleGenericPropChange(SVNStatusType state, File localAbspath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, boolean isDir, SVNProperties workingProps, String propname, SVNPropertyValue baseVal, SVNPropertyValue oldVal, SVNPropertyValue newVal, ISVNConflictHandler conflictResolver, boolean dryRun) throws SVNException {
        assert (oldVal != null);
        boolean conflictRemains = false;
        SVNPropertyValue workingVal = workingProps.getSVNPropertyValue(propname);
        if (workingVal != null && oldVal != null && workingVal.equals(oldVal)) {
            workingProps.put(propname, newVal);
        } else {
            conflictRemains = conflictResolver == null ? true : this.maybeGeneratePropConflict(localAbspath, leftVersion, rightVersion, isDir, propname, workingProps, oldVal, newVal, baseVal, workingVal, conflictResolver, dryRun);
        }
        return new MergePropStatusInfo(state, conflictRemains);
    }

    private MergePropStatusInfo applySingleMergeInfoPropChange(SVNPropertyValue resultVal, boolean didMerge, SVNPropertyValue baseVal, SVNPropertyValue oldVal, SVNPropertyValue newVal, SVNPropertyValue workingVal) throws SVNException {
        boolean conflictRemains = false;
        if (workingVal != null && baseVal == null || workingVal == null && baseVal != null || !SVNPropertyValue.areEqual(workingVal, baseVal)) {
            if (workingVal != null) {
                if (SVNPropertyValue.areEqual(workingVal, newVal)) {
                    didMerge = true;
                } else {
                    resultVal = newVal = this.combineForkedMergeInfoProps(oldVal, workingVal, newVal);
                    didMerge = true;
                }
            } else {
                conflictRemains = true;
            }
        } else if (workingVal == null) {
            HashMap deletedMergeInfo = new HashMap();
            HashMap addedMergeInfo = new HashMap();
            SVNMergeInfoUtil.diffMergeInfoProperties(deletedMergeInfo, addedMergeInfo, SVNPropertyValue.getPropertyAsString(oldVal), null, SVNPropertyValue.getPropertyAsString(newVal), null);
            resultVal = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString(addedMergeInfo, null));
        } else if (oldVal.equals(baseVal)) {
            resultVal = newVal;
        } else {
            resultVal = newVal = this.combineForkedMergeInfoProps(oldVal, workingVal, newVal);
            didMerge = true;
        }
        MergePropStatusInfo propStatusInfo = new MergePropStatusInfo();
        propStatusInfo.conflictRemains = conflictRemains;
        propStatusInfo.didMerge = didMerge;
        propStatusInfo.resultVal = resultVal;
        return propStatusInfo;
    }

    private SVNPropertyValue combineForkedMergeInfoProps(SVNPropertyValue fromPropVal, SVNPropertyValue workingPropVal, SVNPropertyValue toPropVal) throws SVNException {
        String fromVal = SVNPropertyValue.getPropertyAsString(fromPropVal);
        String workingVal = SVNPropertyValue.getPropertyAsString(workingPropVal);
        String toVal = SVNPropertyValue.getPropertyAsString(toPropVal);
        Map<String, SVNMergeRangeList> fromMap = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(fromVal), null);
        HashMap<String, SVNMergeRangeList> leftDeleted = new HashMap<String, SVNMergeRangeList>();
        HashMap<String, SVNMergeRangeList> leftAdded = new HashMap<String, SVNMergeRangeList>();
        HashMap<String, SVNMergeRangeList> rightDeleted = new HashMap<String, SVNMergeRangeList>();
        HashMap<String, SVNMergeRangeList> rightAdded = new HashMap<String, SVNMergeRangeList>();
        SVNMergeInfoUtil.diffMergeInfoProperties(leftDeleted, leftAdded, null, fromMap, workingVal, null);
        SVNMergeInfoUtil.diffMergeInfoProperties(rightDeleted, rightAdded, null, fromMap, toVal, null);
        SVNMergeInfoUtil.mergeMergeInfos(leftDeleted, rightDeleted);
        SVNMergeInfoUtil.mergeMergeInfos(leftAdded, rightAdded);
        SVNMergeInfoUtil.mergeMergeInfos(fromMap, leftAdded);
        SVNMergeInfoUtil.removeMergeInfo(fromMap, leftDeleted);
        String mergedMergeInfo = SVNMergeInfoUtil.formatMergeInfoToString(fromMap, null);
        return SVNPropertyValue.create(mergedMergeInfo);
    }

    private MergePropStatusInfo applySingleMergeinfoPropChange(SVNStatusType state, File localAbspath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, boolean isDir, SVNProperties workingProps, String propname, SVNPropertyValue baseVal, SVNPropertyValue oldVal, SVNPropertyValue newVal, ISVNConflictHandler conflictResolver, boolean dryRun) throws SVNException {
        boolean conflictRemains = false;
        SVNPropertyValue workingVal = workingProps.getSVNPropertyValue(propname);
        if (workingVal != null && baseVal == null || workingVal == null && baseVal != null || workingVal != null && baseVal != null && !workingVal.equals(baseVal)) {
            if (workingVal != null) {
                if (workingVal.equals(newVal)) {
                    state = this.setPropMergeState(state, SVNStatusType.MERGED);
                } else {
                    newVal = SVNPropertyValue.create(SVNMergeInfoUtil.combineForkedMergeInfoProperties(oldVal.getString(), workingVal.getString(), newVal.getString()));
                    if (newVal != null) {
                        workingProps.put(propname, newVal);
                    } else {
                        workingProps.remove(propname);
                    }
                    state = this.setPropMergeState(state, SVNStatusType.MERGED);
                }
            } else {
                conflictRemains = this.maybeGeneratePropConflict(localAbspath, leftVersion, rightVersion, isDir, propname, workingProps, oldVal, newVal, baseVal, workingVal, conflictResolver, dryRun);
            }
        } else if (workingVal == null) {
            HashMap deleted = new HashMap();
            HashMap added = new HashMap();
            SVNMergeInfoUtil.diffMergeInfoProperties(deleted, added, oldVal.getString(), null, newVal.toString(), null);
            String mergeinfoString = SVNMergeInfoUtil.formatMergeInfoToString(added, null);
            workingProps.put(propname, mergeinfoString);
        } else if (oldVal.equals(baseVal)) {
            if (newVal != null) {
                workingProps.put(propname, newVal);
            } else {
                workingProps.remove(propname);
            }
        } else {
            newVal = SVNPropertyValue.create(SVNMergeInfoUtil.combineForkedMergeInfoProperties(oldVal.getString(), workingVal.getString(), newVal.getString()));
            if (newVal != null) {
                workingProps.put(propname, newVal);
            } else {
                workingProps.remove(propname);
            }
            state = this.setPropMergeState(state, SVNStatusType.MERGED);
        }
        return new MergePropStatusInfo(state, conflictRemains);
    }

    public WritableBaseInfo openWritableBase(File localAbspath, boolean md5Checksum, boolean sha1Checksum) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        WritableBaseInfo info = new WritableBaseInfo();
        File tempDirAbspath = this.db.getPristineTempDir(localAbspath);
        info.tempBaseAbspath = SVNFileUtil.createUniqueFile(tempDirAbspath, "svn", ".tmp", true);
        info.stream = SVNFileUtil.openFileForWriting(info.tempBaseAbspath);
        if (md5Checksum) {
            info.md5ChecksumStream = new SVNChecksumOutputStream(info.stream, "MD5", true);
            info.stream = info.md5ChecksumStream;
        }
        if (sha1Checksum) {
            info.sha1ChecksumStream = new SVNChecksumOutputStream(info.stream, "SHA1", true);
            info.stream = info.sha1ChecksumStream;
        }
        return info;
    }

    public static boolean hasMagicProperty(SVNProperties properties) {
        for (String property : properties.nameSet()) {
            if (!"svn:executable".equals(property) && !"svn:keywords".equals(property) && !"svn:eol-style".equals(property) && !"svn:special".equals(property) && !"svn:needs-lock".equals(property)) continue;
            return true;
        }
        return false;
    }

    public InputStream getTranslatedStream(File localAbspath, File versionedAbspath, boolean translateToNormalForm, boolean repairEOL) throws SVNException {
        boolean translationRequired;
        assert (SVNFileUtil.isAbsolute(localAbspath));
        assert (SVNFileUtil.isAbsolute(versionedAbspath));
        TranslateInfo translateInfo = this.getTranslateInfo(localAbspath, true, true, true, true);
        boolean special = translateInfo.special;
        SVNEolStyle eolStyle = translateInfo.eolStyleInfo.eolStyle;
        byte[] eolStr = translateInfo.eolStyleInfo.eolStr;
        Map<String, byte[]> keywords = translateInfo.keywords;
        if (special) {
            return SVNWCContext.readSpecialFile(localAbspath);
        }
        String charset = translateInfo.charset;
        boolean bl = translationRequired = special || keywords != null || eolStyle != null || charset != null;
        if (translationRequired && translateToNormalForm) {
            if (eolStyle == SVNEolStyle.Native) {
                eolStr = SVNTranslator.getBaseEOL("native");
            } else if (eolStyle == SVNEolStyle.Fixed) {
                repairEOL = true;
            } else if (eolStyle != SVNEolStyle.None) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
                return null;
            }
            return SVNTranslator.getTranslatingInputStream(SVNFileUtil.openFileForReading(localAbspath, SVNLogType.WC), charset, eolStr, repairEOL, keywords, false);
        }
        return SVNFileUtil.openFileForReading(localAbspath, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getTranslatedFile(File src, File versionedAbspath, boolean toNormalFormat, boolean forceEOLRepair, boolean useGlobalTmp, boolean forceCopy, boolean safelyEncode) throws SVNException {
        File xlated_path;
        assert (SVNFileUtil.isAbsolute(versionedAbspath));
        TranslateInfo translateInfo = this.getTranslateInfo(versionedAbspath, true, true, true, true);
        SVNEolStyle style = translateInfo.eolStyleInfo.eolStyle;
        byte[] eol = translateInfo.eolStyleInfo.eolStr;
        String charset = translateInfo.charset;
        Map<String, byte[]> keywords = translateInfo.keywords;
        boolean special = translateInfo.special;
        if (!this.isTranslationRequired(style, eol, charset, keywords, special, true) && !forceCopy) {
            xlated_path = src;
        } else {
            boolean repairForced = forceEOLRepair;
            boolean expand = !toNormalFormat;
            File tmpDir = useGlobalTmp ? null : this.db.getWCRootTempDir(versionedAbspath);
            File tmpVFile = SVNFileUtil.createUniqueFile(tmpDir, src.getName(), ".tmp", false);
            if (expand) {
                repairForced = true;
            } else if (style == SVNEolStyle.Native) {
                eol = SVNEolStyleInfo.NATIVE_EOL_STR;
            } else if (style == SVNEolStyle.Fixed) {
                repairForced = true;
            } else if (style != SVNEolStyle.None) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (expand && charset != null && safelyEncode) {
                File tmp = SVNFileUtil.createUniqueFile(tmpDir, src.getName(), ".tmp", false);
                try {
                    SVNTranslator.copyAndTranslate(src, tmp, charset, eol, keywords, special, false, repairForced);
                    SVNTranslator.copyAndTranslate(tmp, tmpVFile, charset, eol, keywords, special, true, repairForced);
                }
                finally {
                    SVNFileUtil.deleteFile(tmp);
                }
            } else {
                SVNTranslator.copyAndTranslate(src, tmpVFile, charset, eol, keywords, special, expand, repairForced);
            }
            xlated_path = tmpVFile;
        }
        return xlated_path.getAbsoluteFile();
    }

    public MergeInfo mergeText(File left, File right, File target, String leftLabel, String rightLabel, String targetLabel, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, boolean dryRun, SVNDiffOptions options, SVNProperties propDiff) throws SVNException {
        if (!dryRun) {
            this.writeCheck(target);
        }
        MergeInfo result = new MergeInfo();
        ISVNWCDb.SVNWCDbKind kind = this.getDb().readKind(target, true);
        if (kind == ISVNWCDb.SVNWCDbKind.Unknown) {
            result.mergeOutcome = SVNStatusType.NO_MERGE;
            return result;
        }
        if (this.getDb().isNodeHidden(target)) {
            result.mergeOutcome = SVNStatusType.NO_MERGE;
            return result;
        }
        SVNProperties actualProps = this.getDb().readProperties(target);
        result = this.merge(null, null, left, right, target, target, leftLabel, rightLabel, targetLabel, actualProps, dryRun, options, propDiff);
        if (!dryRun) {
            this.getDb().addWorkQueue(target, result.workItems);
            this.wqRun(target);
        }
        return result;
    }

    public MergeInfo merge(SVNSkel workItems, SVNSkel conflictSkel, File leftAbspath, File rightAbspath, File targetAbspath, File wriAbspath, String leftLabel, String rightLabel, String targetLabel, SVNProperties oldActualProps, boolean dryRun, SVNDiffOptions options, SVNProperties propDiff) throws SVNException {
        SVNPropertyValue value;
        assert (SVNFileUtil.isAbsolute(leftAbspath));
        assert (SVNFileUtil.isAbsolute(rightAbspath));
        assert (SVNFileUtil.isAbsolute(targetAbspath));
        assert (wriAbspath == null || SVNFileUtil.isAbsolute(wriAbspath));
        MergeInfo info = new MergeInfo();
        info.workItems = workItems;
        info.conflictSkel = conflictSkel;
        if (wriAbspath == null) {
            ISVNWCDb.SVNWCDbKind kind = this.db.readKind(targetAbspath, true);
            if (kind == ISVNWCDb.SVNWCDbKind.Unknown) {
                info.mergeOutcome = SVNStatusType.NO_MERGE;
                return info;
            }
            boolean hidden = this.db.isNodeHidden(targetAbspath);
            if (hidden) {
                info.mergeOutcome = SVNStatusType.NO_MERGE;
                return info;
            }
        }
        boolean isBinary = false;
        SVNPropertyValue mimeprop = propDiff.getSVNPropertyValue("svn:mime-type");
        isBinary = mimeprop != null && mimeprop.isString() ? SVNProperty.mimeTypeIsBinary(mimeprop.getString()) : (value = oldActualProps.getSVNPropertyValue("svn:mime-type")) != null && SVNProperty.mimeTypeIsBinary(value.getString());
        File detranslatedTargetAbspath = this.detranslateWCFile(targetAbspath, !isBinary, oldActualProps, propDiff, targetAbspath);
        leftAbspath = this.maybeUpdateTargetEols(leftAbspath, propDiff);
        info.mergeOutcome = SVNStatusType.NO_MERGE;
        ISvnMerger customMerger = this.createCustomMerger();
        if (isBinary || customMerger == null) {
            info = this.attemptTrivialMerge(info, leftAbspath, rightAbspath, targetAbspath, detranslatedTargetAbspath, dryRun);
        }
        if (info.mergeOutcome == SVNStatusType.NO_MERGE) {
            if (isBinary) {
                if (dryRun) {
                    info.mergeOutcome = SVNStatusType.CONFLICTED;
                } else {
                    info = this.mergeBinaryFile(info, leftAbspath, rightAbspath, targetAbspath, leftLabel, rightLabel, targetLabel, detranslatedTargetAbspath, dryRun);
                }
            } else {
                info = this.mergeTextFile(info, customMerger, leftAbspath, rightAbspath, targetAbspath, wriAbspath, leftLabel, rightLabel, targetLabel, dryRun, options, null, detranslatedTargetAbspath, mimeprop);
            }
        }
        if (!dryRun) {
            SVNSkel workItem = this.wqBuildSyncFileFlags(targetAbspath);
            info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergeInfo attemptTrivialMerge(MergeInfo info, File leftAbspath, File rightAbspath, File targetAbspath, File detranslatedTargetAbspath, boolean dryRun) throws SVNException {
        boolean sameRightDetranslatedTarget;
        block16: {
            block18: {
                File wcRootAbsPath;
                boolean deleteSrc;
                block19: {
                    block17: {
                        boolean sameLeftRight;
                        boolean sameLeftDetranslatedTarget;
                        boolean diffRightDetranslatedTargetSize;
                        SVNFileType ft = SVNFileType.getType(targetAbspath);
                        if (ft != SVNFileType.FILE) {
                            info.mergeOutcome = SVNStatusType.NO_MERGE;
                            return info;
                        }
                        long leftSize = SVNFileUtil.getFileLength(leftAbspath);
                        long rightSize = SVNFileUtil.getFileLength(rightAbspath);
                        long detranslatedTargetSize = SVNFileUtil.getFileLength(detranslatedTargetAbspath);
                        boolean absentLeft = SVNFileType.getType(leftAbspath) == SVNFileType.NONE;
                        boolean absentRight = SVNFileType.getType(rightAbspath) == SVNFileType.NONE;
                        boolean absentDetranslatedTarget = SVNFileType.getType(detranslatedTargetAbspath) == SVNFileType.NONE;
                        boolean diffLeftRightSize = !absentLeft && !absentRight && leftSize != rightSize;
                        boolean diffLeftDetranslatedTargetSize = !absentLeft && !absentDetranslatedTarget && leftSize != detranslatedTargetSize;
                        boolean bl = diffRightDetranslatedTargetSize = !absentRight && !absentDetranslatedTarget && rightSize != detranslatedTargetSize;
                        if (diffLeftRightSize && diffLeftDetranslatedTargetSize && diffRightDetranslatedTargetSize) {
                            sameRightDetranslatedTarget = false;
                            sameLeftDetranslatedTarget = false;
                            sameLeftRight = false;
                        } else if (diffLeftRightSize && diffLeftDetranslatedTargetSize) {
                            sameLeftDetranslatedTarget = false;
                            sameLeftRight = false;
                            sameRightDetranslatedTarget = SVNFileUtil.compareFiles(rightAbspath, detranslatedTargetAbspath, null);
                        } else if (diffLeftRightSize && diffRightDetranslatedTargetSize) {
                            sameRightDetranslatedTarget = false;
                            sameLeftRight = false;
                            sameLeftDetranslatedTarget = SVNFileUtil.compareFiles(leftAbspath, detranslatedTargetAbspath, null);
                        } else if (diffLeftDetranslatedTargetSize && diffRightDetranslatedTargetSize) {
                            sameRightDetranslatedTarget = false;
                            sameLeftDetranslatedTarget = false;
                            sameLeftRight = SVNFileUtil.compareFiles(leftAbspath, rightAbspath, null);
                        } else {
                            assert (!(diffLeftRightSize || diffLeftDetranslatedTargetSize || diffRightDetranslatedTargetSize));
                            sameLeftRight = SVNFileUtil.compareFiles(leftAbspath, rightAbspath, null);
                            sameLeftDetranslatedTarget = SVNFileUtil.compareFiles(leftAbspath, detranslatedTargetAbspath, null);
                            sameRightDetranslatedTarget = SVNFileUtil.compareFiles(rightAbspath, detranslatedTargetAbspath, null);
                        }
                        if (!sameLeftDetranslatedTarget) break block16;
                        if (!sameLeftRight) break block17;
                        info.mergeOutcome = SVNStatusType.UNCHANGED;
                        break block18;
                    }
                    info.mergeOutcome = SVNStatusType.MERGED;
                    if (dryRun) break block18;
                    deleteSrc = false;
                    wcRootAbsPath = this.getDb().getWCRoot(targetAbspath);
                    if (SVNPathUtil.isAncestor(wcRootAbsPath.getAbsolutePath(), rightAbspath.getAbsolutePath())) break block19;
                    InputStream tmpSrc = null;
                    OutputStream tmpDst = null;
                    try {
                        tmpSrc = SVNFileUtil.openFileForReading(rightAbspath);
                        WritableBaseInfo writableBaseInfo = this.openWritableBase(rightAbspath, false, false);
                        tmpDst = writableBaseInfo.stream;
                        SVNTranslator.copy(tmpSrc, tmpDst);
                    }
                    catch (IOException e) {
                        try {
                            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                            SVNErrorManager.error(errorMessage, SVNLogType.WC);
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(tmpSrc);
                            SVNFileUtil.closeFile(tmpDst);
                            throw throwable;
                        }
                        SVNFileUtil.closeFile(tmpSrc);
                        SVNFileUtil.closeFile(tmpDst);
                    }
                    SVNFileUtil.closeFile(tmpSrc);
                    SVNFileUtil.closeFile(tmpDst);
                    deleteSrc = true;
                }
                SVNSkel workItem = this.wqBuildFileInstall(targetAbspath, rightAbspath, false, false);
                info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
                if (deleteSrc) {
                    workItem = this.wqBuildFileRemove(wcRootAbsPath, rightAbspath);
                    info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
                }
            }
            return info;
        }
        if (sameRightDetranslatedTarget) {
            info.mergeOutcome = SVNStatusType.UNCHANGED;
            return info;
        }
        info.mergeOutcome = SVNStatusType.NO_MERGE;
        return info;
    }

    private boolean isMarkedAsBinary(File localAbsPath) throws SVNException {
        String value = this.getProperty(localAbsPath, "svn:mime-type");
        return value != null && SVNProperty.mimeTypeIsBinary(value);
    }

    private File detranslateWCFile(File targetAbspath, boolean forceCopy, SVNProperties oldActualProps, SVNProperties propDiff, File sourceAbspath) throws SVNException {
        TranslateInfo translateInfo;
        boolean newIsBinary;
        String oldMimeValue = oldActualProps.getStringValue("svn:mime-type");
        String newMimeValue = propDiff.containsName("svn:mime-type") ? propDiff.getStringValue("svn:mime-type") : oldMimeValue;
        boolean oldIsBinary = oldMimeValue != null && SVNProperty.isBinaryMimeType(oldMimeValue);
        boolean bl = newIsBinary = newMimeValue != null && SVNProperty.isBinaryMimeType(newMimeValue);
        if (oldIsBinary && newIsBinary) {
            translateInfo = this.getTranslateInfo(sourceAbspath, oldActualProps, true, false, false, true, false);
            translateInfo.special = false;
            translateInfo.eolStyleInfo = null;
        } else if (!oldIsBinary && newIsBinary) {
            translateInfo = this.getTranslateInfo(sourceAbspath, oldActualProps, true, true, true, true, true);
        } else {
            translateInfo = this.getTranslateInfo(sourceAbspath, oldActualProps, true, true, true, true, true);
            if (translateInfo.special) {
                translateInfo.keywords = null;
                translateInfo.eolStyleInfo = null;
            } else {
                String eolStyle = propDiff.getStringValue("svn:eol-style");
                if (eolStyle != null) {
                    translateInfo.eolStyleInfo = SVNEolStyleInfo.fromValue(eolStyle);
                } else if (oldIsBinary) {
                    translateInfo.eolStyleInfo = null;
                }
            }
        }
        if (translateInfo.eolStyleInfo == null) {
            translateInfo.eolStyleInfo = new SVNEolStyleInfo(SVNEolStyle.None, null);
        }
        if (forceCopy || translateInfo.keywords != null || translateInfo.eolStyleInfo.eolStr != null || translateInfo.special || translateInfo.charset != null) {
            File detranslated = SVNWCContext.openUniqueFile((File)this.getDb().getWCRootTempDir((File)targetAbspath), (boolean)false).path;
            if (translateInfo.eolStyleInfo.eolStyle == SVNEolStyle.Native) {
                translateInfo.eolStyleInfo.eolStr = SVNEolStyleInfo.LF_EOL_STR;
            } else if (translateInfo.eolStyleInfo.eolStyle != SVNEolStyle.Fixed && translateInfo.eolStyleInfo.eolStyle != SVNEolStyle.None) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNTranslator.copyAndTranslate(sourceAbspath, detranslated, translateInfo.charset, translateInfo.eolStyleInfo.eolStr, translateInfo.keywords, translateInfo.special, false, true);
            return detranslated.getAbsoluteFile();
        }
        return sourceAbspath;
    }

    public static UniqueFileInfo openUniqueFile(File dirPath, boolean openStream) throws SVNException {
        UniqueFileInfo info = new UniqueFileInfo();
        if (dirPath == null) {
            dirPath = SVNFileUtil.createFilePath(System.getProperty("java.io.tmpdir"));
        }
        info.path = SVNFileUtil.createUniqueFile(dirPath, "svn", ".tmp", false);
        if (openStream) {
            info.stream = SVNFileUtil.openFileForWriting(info.path);
        }
        return info;
    }

    private File maybeUpdateTargetEols(File oldTargetAbspath, SVNProperties propDiff) throws SVNException {
        SVNPropertyValue prop = propDiff.getSVNPropertyValue("svn:eol-style");
        if (prop != null && prop.isString()) {
            byte[] eol = SVNEolStyleInfo.fromValue((String)prop.getString()).eolStr;
            File tmpNew = SVNWCContext.openUniqueFile(null, (boolean)false).path;
            SVNTranslator.copyAndTranslate(oldTargetAbspath, tmpNew, null, eol, null, false, false, true);
            return tmpNew;
        }
        return oldTargetAbspath;
    }

    private MergeInfo mergeTextFile(MergeInfo info, ISvnMerger customMerger, File leftAbspath, File rightAbspath, File targetAbspath, File wriAbspath, String leftLabel, String rightLabel, String targetLabel, boolean dryRun, SVNDiffOptions options, File copyfromText, File detranslatedTargetAbspath, SVNPropertyValue mimeprop) throws SVNException {
        info.workItems = null;
        String baseName = SVNFileUtil.getFileName(targetAbspath);
        File tempDir = this.db.getWCRootTempDir(wriAbspath == null ? targetAbspath : wriAbspath);
        File resultTarget = SVNFileUtil.createUniqueFile(tempDir, baseName, ".tmp", false);
        boolean containsConflicts = this.doTextMerge(customMerger, resultTarget, targetAbspath, detranslatedTargetAbspath, leftAbspath, rightAbspath, targetLabel, leftLabel, rightLabel, options, SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_ORIGINAL_LATEST);
        if (containsConflicts && !dryRun) {
            info.mergeOutcome = SVNStatusType.CONFLICTED;
            if (info.mergeOutcome == SVNStatusType.CONFLICTED) {
                PresevePreMergeFileInfo preserveInfo = this.preservePreMergeFiles(leftAbspath, rightAbspath, targetAbspath, leftLabel, rightLabel, targetLabel, detranslatedTargetAbspath);
                SVNSkel workItem = preserveInfo.workItems;
                File leftCopy = preserveInfo.leftCopy;
                File rightCopy = preserveInfo.rightCopy;
                File targetCopy = preserveInfo.targetCopy;
                info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
                if (info.conflictSkel == null) {
                    info.conflictSkel = SvnWcDbConflicts.createConflictSkel();
                }
                SvnWcDbConflicts.addTextConflict(info.conflictSkel, this.getDb(), targetAbspath, targetCopy, leftCopy, rightCopy);
            }
            if (info.mergeOutcome == SVNStatusType.MERGED) {
                return info;
            }
        } else if (containsConflicts && dryRun) {
            info.mergeOutcome = SVNStatusType.CONFLICTED;
        } else if (copyfromText != null) {
            info.mergeOutcome = SVNStatusType.MERGED;
        } else {
            boolean special = this.getTranslateInfo((File)targetAbspath, (boolean)false, (boolean)false, (boolean)false, (boolean)true).special;
            boolean same = SVNFileUtil.compareFiles(resultTarget, special ? detranslatedTargetAbspath : targetAbspath, null);
            SVNStatusType sVNStatusType = info.mergeOutcome = same ? SVNStatusType.UNCHANGED : SVNStatusType.MERGED;
        }
        if (info.mergeOutcome != SVNStatusType.UNCHANGED && !dryRun) {
            SVNSkel workItem = this.wqBuildFileInstall(targetAbspath, resultTarget, false, false);
            info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
        }
        return info;
    }

    private boolean doTextMerge(ISvnMerger customMerger, File resultFile, File targetAbsPath, File detranslatedTargetAbspath, File leftAbspath, File rightAbspath, String targetLabel, String leftLabel, String rightLabel, SVNDiffOptions options, SVNDiffConflictChoiceStyle style) throws SVNException {
        DefaultSvnMerger defaultMerger = this.createDefaultMerger();
        SvnMergeResult mergeResult = customMerger != null ? customMerger.mergeText(defaultMerger, resultFile, targetAbsPath, detranslatedTargetAbspath, leftAbspath, rightAbspath, targetLabel, leftLabel, rightLabel, options, style) : defaultMerger.mergeText(null, resultFile, targetAbsPath, detranslatedTargetAbspath, leftAbspath, rightAbspath, targetLabel, leftLabel, rightLabel, options, style);
        return mergeResult.getMergeOutcome() == SVNStatusType.CONFLICTED;
    }

    ConflictMarkersInfo initConflictMarkers(String targetLabel, String leftLabel, String rightLabel) {
        ConflictMarkersInfo info = new ConflictMarkersInfo();
        info.targetMarker = targetLabel != null ? String.format("<<<<<<< %s", targetLabel) : "<<<<<<< .working";
        info.leftMarker = leftLabel != null ? String.format("||||||| %s", leftLabel) : "||||||| .old";
        info.rightMarker = rightLabel != null ? String.format(">>>>>>> %s", rightLabel) : ">>>>>>> .new";
        return info;
    }

    private PresevePreMergeFileInfo preservePreMergeFiles(File leftAbspath, File rightAbspath, File targetAbspath, String leftLabel, String rightLabel, String targetLabel, File detranslatedTargetAbspath) throws SVNException {
        File detranslatedTargetCopy;
        File tmpRight;
        File tmpLeft;
        PresevePreMergeFileInfo info = new PresevePreMergeFileInfo();
        info.workItems = null;
        File dirAbspath = SVNFileUtil.getFileDir(targetAbspath);
        String targetName = SVNFileUtil.getFileName(targetAbspath);
        File tempDir = this.db.getWCRootTempDir(targetAbspath);
        info.leftCopy = SVNFileUtil.createUniqueFile(dirAbspath, targetName, leftLabel, false);
        info.rightCopy = SVNFileUtil.createUniqueFile(dirAbspath, targetName, rightLabel, false);
        info.targetCopy = SVNFileUtil.createUniqueFile(dirAbspath, targetName, targetLabel, false);
        if (!SVNPathUtil.isAncestor(dirAbspath.getPath(), leftAbspath.getPath())) {
            tmpLeft = SVNWCContext.openUniqueFile((File)tempDir, (boolean)false).path;
            SVNFileUtil.copyFile(leftAbspath, tmpLeft, true);
        } else {
            tmpLeft = leftAbspath;
        }
        if (!SVNPathUtil.isAncestor(dirAbspath.getPath(), rightAbspath.getPath())) {
            tmpRight = SVNWCContext.openUniqueFile((File)tempDir, (boolean)false).path;
            SVNFileUtil.copyFile(rightAbspath, tmpRight, true);
        } else {
            tmpRight = rightAbspath;
        }
        SVNSkel workItem = this.wqBuildFileCopyTranslated(targetAbspath, tmpLeft, info.leftCopy);
        info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
        workItem = this.wqBuildFileCopyTranslated(targetAbspath, tmpRight, info.rightCopy);
        info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
        try {
            detranslatedTargetCopy = this.getTranslatedFile(targetAbspath, targetAbspath, true, false, false, false, false);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                detranslatedTargetCopy = detranslatedTargetAbspath;
            }
            throw e;
        }
        workItem = this.wqBuildFileCopyTranslated(targetAbspath, detranslatedTargetCopy, info.targetCopy);
        info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
        return info;
    }

    private MergeInfo maybeResolveConflicts(File leftAbspath, File rightAbspath, File targetAbspath, File copyfromText, String leftLabel, String rightLabel, String targetLabel, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, File resultTarget, File detranslatedTarget, SVNPropertyValue mimeprop, SVNDiffOptions options, ISVNConflictHandler conflictResolver) throws SVNException {
        SVNConflictResult result;
        MergeInfo info = new MergeInfo();
        info.workItems = null;
        File dirAbspath = SVNFileUtil.getFileDir(targetAbspath);
        if (conflictResolver == null) {
            result = new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
        } else {
            SVNConflictDescription cdesc = this.setupTextConflictDesc(leftAbspath, rightAbspath, targetAbspath, leftVersion, rightVersion, resultTarget, detranslatedTarget, mimeprop, false);
            result = conflictResolver.handleConflict(cdesc);
            if (result == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no results");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (result.isIsSaveMerged()) {
                info.workItems = this.saveMergeResult(targetAbspath, result.getMergedFile() != null ? result.getMergedFile() : resultTarget);
            }
        }
        MergeInfo evalInfo = this.evalConflictResolverResult(result.getConflictChoice(), dirAbspath, leftAbspath, rightAbspath, targetAbspath, copyfromText, result.getMergedFile() != null ? result.getMergedFile() : resultTarget, detranslatedTarget, options);
        info.mergeOutcome = evalInfo.mergeOutcome;
        SVNSkel workItem = evalInfo.workItems;
        info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
        if (result.getConflictChoice() != SVNConflictChoice.POSTPONE) {
            return info;
        }
        info.mergeOutcome = SVNStatusType.CONFLICTED;
        return info;
    }

    private SVNConflictDescription setupTextConflictDesc(File leftAbspath, File rightAbspath, File targetAbspath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, File resultTarget, File detranslatedTarget, SVNPropertyValue mimeprop, boolean isBinary) {
        SVNWCConflictDescription17 cdesc = SVNWCConflictDescription17.createText(targetAbspath);
        cdesc.setBinary(false);
        cdesc.setMimeType(mimeprop != null && mimeprop.isString() ? mimeprop.getString() : null);
        cdesc.setBaseFile(leftAbspath);
        cdesc.setTheirFile(rightAbspath);
        cdesc.setMyFile(detranslatedTarget);
        cdesc.setMergedFile(resultTarget);
        cdesc.setSrcLeftVersion(leftVersion);
        cdesc.setSrcRightVersion(rightVersion);
        return cdesc.toConflictDescription();
    }

    private SVNConflictDescription setupTreeConflictDesc(File localAbsPath, SVNOperation operation, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, SVNConflictReason localChange, SVNConflictAction incomingChange) {
        SVNNodeKind tcKind = leftVersion != null ? leftVersion.getKind() : (rightVersion != null ? rightVersion.getKind() : SVNNodeKind.FILE);
        SVNWCConflictDescription17 conflictDescription17 = SVNWCConflictDescription17.createTree(localAbsPath, tcKind, operation, leftVersion, rightVersion);
        conflictDescription17.setReason(localChange);
        conflictDescription17.setAction(incomingChange);
        return conflictDescription17.toConflictDescription();
    }

    private SVNSkel saveMergeResult(File versionedAbspath, File source2) throws SVNException {
        File dirAbspath = SVNFileUtil.getFileDir(versionedAbspath);
        String filename = SVNFileUtil.getFileName(versionedAbspath);
        File editedCopyAbspath = SVNFileUtil.createUniqueFile(dirAbspath, filename, ".edited", false);
        return this.wqBuildFileCopyTranslated(versionedAbspath, source2, editedCopyAbspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergeInfo evalConflictResolverResult(SVNConflictChoice choice, File wriAbspath, File leftAbspath, File rightAbspath, File targetAbspath, File copyfromText, File mergedFile, File detranslatedTarget, SVNDiffOptions options) throws SVNException {
        MergeInfo info;
        boolean removeSource;
        File installFrom;
        block12: {
            block14: {
                block13: {
                    block11: {
                        installFrom = null;
                        removeSource = false;
                        info = new MergeInfo();
                        info.workItems = null;
                        if (choice != SVNConflictChoice.BASE) break block11;
                        installFrom = leftAbspath;
                        info.mergeOutcome = SVNStatusType.MERGED;
                        break block12;
                    }
                    if (choice != SVNConflictChoice.THEIRS_FULL) break block13;
                    installFrom = rightAbspath;
                    info.mergeOutcome = SVNStatusType.MERGED;
                    break block12;
                }
                if (choice == SVNConflictChoice.MINE_FULL) {
                    info.mergeOutcome = SVNStatusType.MERGED;
                    return info;
                }
                if (choice != SVNConflictChoice.THEIRS_CONFLICT && choice != SVNConflictChoice.MINE_CONFLICT) break block14;
                SVNDiffConflictChoiceStyle style = choice == SVNConflictChoice.THEIRS_CONFLICT ? SVNDiffConflictChoiceStyle.CHOOSE_LATEST : SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED;
                File tempDir = this.db.getWCRootTempDir(wriAbspath);
                FSMergerBySequence merger = new FSMergerBySequence(null, null, null);
                RandomAccessFile localIS = null;
                RandomAccessFile latestIS = null;
                RandomAccessFile baseIS = null;
                UniqueFileInfo uniqFile = SVNWCContext.openUniqueFile(tempDir, true);
                File chosenPath = uniqFile.path;
                OutputStream chosenStream = uniqFile.stream;
                try {
                    localIS = new RandomAccessFile(detranslatedTarget, "r");
                    latestIS = new RandomAccessFile(rightAbspath, "r");
                    baseIS = new RandomAccessFile(leftAbspath, "r");
                    QSequenceLineRAFileData baseData = new QSequenceLineRAFileData(baseIS);
                    QSequenceLineRAFileData localData = new QSequenceLineRAFileData(localIS);
                    QSequenceLineRAFileData latestData = new QSequenceLineRAFileData(latestIS);
                    merger.merge(baseData, localData, latestData, options, chosenStream, style);
                }
                catch (IOException e) {
                    try {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                        SVNErrorManager.error(err, e, SVNLogType.WC);
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(chosenStream);
                        SVNFileUtil.closeFile(localIS);
                        SVNFileUtil.closeFile(baseIS);
                        SVNFileUtil.closeFile(latestIS);
                        throw throwable;
                    }
                    SVNFileUtil.closeFile(chosenStream);
                    SVNFileUtil.closeFile(localIS);
                    SVNFileUtil.closeFile(baseIS);
                    SVNFileUtil.closeFile(latestIS);
                }
                SVNFileUtil.closeFile(chosenStream);
                SVNFileUtil.closeFile(localIS);
                SVNFileUtil.closeFile(baseIS);
                SVNFileUtil.closeFile(latestIS);
                installFrom = chosenPath;
                removeSource = true;
                info.mergeOutcome = SVNStatusType.MERGED;
                break block12;
            }
            if (choice == SVNConflictChoice.MERGED) {
                installFrom = mergedFile;
                info.mergeOutcome = SVNStatusType.MERGED;
            } else if (copyfromText != null) {
                installFrom = copyfromText;
            } else {
                return info;
            }
        }
        assert (installFrom != null);
        SVNSkel workItem = this.wqBuildFileInstall(targetAbspath, installFrom, false, false);
        info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
        if (removeSource) {
            workItem = this.wqBuildFileRemove(wriAbspath, installFrom);
            info.workItems = SVNWCContext.wqMerge(info.workItems, workItem);
        }
        return info;
    }

    private MergeInfo mergeBinaryFile(MergeInfo info, File leftAbspath, File rightAbspath, File targetAbspath, String leftLabel, String rightLabel, String targetLabel, File detranslatedTargetAbspath, boolean dryRun) throws SVNException {
        File conflictWrk;
        assert (SVNFileUtil.isAbsolute(targetAbspath));
        info.workItems = null;
        File mergeDirpath = SVNFileUtil.getFileDir(targetAbspath);
        String mergeFilename = SVNFileUtil.getFileName(targetAbspath);
        if (dryRun) {
            info.mergeOutcome = SVNStatusType.CONFLICTED;
            return info;
        }
        File leftCopy = SVNFileUtil.createUniqueFile(mergeDirpath, mergeFilename, leftLabel, false);
        File rightCopy = SVNFileUtil.createUniqueFile(mergeDirpath, mergeFilename, rightLabel, false);
        SVNFileUtil.copyFile(leftAbspath, leftCopy, true);
        SVNFileUtil.copyFile(rightAbspath, rightCopy, true);
        if (!targetAbspath.equals(detranslatedTargetAbspath)) {
            File mineCopy = SVNFileUtil.createUniqueFile(mergeDirpath, mergeFilename, targetLabel, true);
            info.workItems = this.wqBuildFileMove(detranslatedTargetAbspath, mineCopy);
            conflictWrk = mineCopy;
        } else {
            conflictWrk = null;
        }
        if (info.conflictSkel == null) {
            info.conflictSkel = SvnWcDbConflicts.createConflictSkel();
        }
        SvnWcDbConflicts.addTextConflict(info.conflictSkel, this.getDb(), targetAbspath, conflictWrk, leftCopy, rightCopy);
        info.mergeOutcome = SVNStatusType.CONFLICTED;
        return info;
    }

    public SVNSkel wqBuildFileMove(File srcAbspath, File dstAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(srcAbspath));
        assert (SVNFileUtil.isAbsolute(dstAbspath));
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(srcAbspath));
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", (Object)srcAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependPath(this.getRelativePath(dstAbspath));
        workItem.prependPath(this.getRelativePath(srcAbspath));
        workItem.prependString(WorkQueueOperation.FILE_MOVE.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildFileMove(File anchorPath, File srcAbspath, File dstAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(srcAbspath));
        assert (SVNFileUtil.isAbsolute(dstAbspath));
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(srcAbspath));
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", (Object)srcAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File srcRelPath = this.getDb().toRelPath(anchorPath, srcAbspath);
        File dstRelPath = this.getDb().toRelPath(anchorPath, dstAbspath);
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependPath(dstRelPath);
        workItem.prependPath(srcRelPath);
        workItem.prependString(WorkQueueOperation.FILE_MOVE.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildFileCopyTranslated(File localAbspath, File srcAbspath, File dstAbspath) throws SVNException {
        return SVNWCContext.wqBuildFileCopyTranslated((SVNWCDb)this.getDb(), localAbspath, srcAbspath, dstAbspath);
    }

    public static SVNSkel wqBuildFileCopyTranslated(SVNWCDb db, File localAbspath, File srcAbspath, File dstAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        assert (SVNFileUtil.isAbsolute(srcAbspath));
        assert (SVNFileUtil.isAbsolute(dstAbspath));
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(srcAbspath));
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", (Object)srcAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependPath(SVNWCContext.getRelativePath(db, dstAbspath));
        workItem.prependPath(SVNWCContext.getRelativePath(db, srcAbspath));
        workItem.prependPath(SVNWCContext.getRelativePath(db, localAbspath));
        workItem.prependString(WorkQueueOperation.FILE_COPY_TRANSLATED.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildSetTextConflictMarkersTmp(File localAbspath, File old, File neo, File wrk) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        SVNSkel workItem = SVNSkel.createEmptyList();
        File wcRoot = this.getDb().getWCRoot(localAbspath);
        String oldPath = old != null ? SVNWCUtils.getPathAsChild(wcRoot, old) : null;
        String newPath = neo != null ? SVNWCUtils.getPathAsChild(wcRoot, neo) : null;
        String wrkPath = wrk != null ? SVNWCUtils.getPathAsChild(wcRoot, wrk) : null;
        workItem.prependString(wrkPath != null ? wrkPath : "");
        workItem.prependString(newPath != null ? newPath : "");
        workItem.prependString(oldPath != null ? oldPath : "");
        workItem.prependPath(this.getRelativePath(localAbspath));
        workItem.prependString(WorkQueueOperation.TMP_SET_TEXT_CONFLICT_MARKERS.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildBaseRemove(File localAbspath, boolean keepNotPresent) throws SVNException {
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependString(keepNotPresent ? "1" : "0");
        workItem.prependPath(this.getRelativePath(localAbspath));
        workItem.prependString(WorkQueueOperation.BASE_REMOVE.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildBaseRemove(File localAbspath, long notPresentRevision, ISVNWCDb.SVNWCDbKind notPresentKind) throws SVNException {
        return SVNWCContext.wqBuildBaseRemove((SVNWCDb)this.getDb(), localAbspath, notPresentRevision, notPresentKind);
    }

    public static SVNSkel wqBuildBaseRemove(SVNWCDb db, File localAbspath, long notPresentRevision, ISVNWCDb.SVNWCDbKind notPresentKind) throws SVNException {
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependString(Integer.toString(notPresentKind.ordinal()));
        workItem.prependString(Long.toString(notPresentRevision));
        workItem.prependPath(SVNWCContext.getRelativePath(db, localAbspath));
        workItem.prependString(WorkQueueOperation.BASE_REMOVE.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildRecordFileinfo(File localAbspath, SVNDate setTime) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        SVNSkel workItem = SVNSkel.createEmptyList();
        if (setTime != null) {
            workItem.prependString(String.format("%d", setTime.getTimeInMicros()));
        }
        workItem.prependPath(this.getRelativePath(localAbspath));
        workItem.prependString(WorkQueueOperation.RECORD_FILEINFO.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildFileInstall(File localAbspath, File sourceAbspath, boolean useCommitTimes, boolean recordFileinfo) throws SVNException {
        return SVNWCContext.wqBuildFileInstall((SVNWCDb)this.getDb(), localAbspath, sourceAbspath, useCommitTimes, recordFileinfo);
    }

    public static SVNSkel wqBuildFileInstall(SVNWCDb db, File localAbspath, File sourceAbspath, boolean useCommitTimes, boolean recordFileinfo) throws SVNException {
        SVNSkel workItem = SVNSkel.createEmptyList();
        if (sourceAbspath != null) {
            workItem.prependPath(SVNWCContext.getRelativePath(db, sourceAbspath));
        }
        workItem.prependString(recordFileinfo ? "1" : "0");
        workItem.prependString(useCommitTimes ? "1" : "0");
        workItem.prependPath(SVNWCContext.getRelativePath(db, localAbspath));
        workItem.prependString(WorkQueueOperation.FILE_INSTALL.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildSyncFileFlags(File localAbspath) throws SVNException {
        return SVNWCContext.wqBuildSyncFileFlags((SVNWCDb)this.getDb(), localAbspath);
    }

    public static SVNSkel wqBuildSyncFileFlags(SVNWCDb db, File localAbspath) throws SVNException {
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependPath(SVNWCContext.getRelativePath(db, localAbspath));
        workItem.prependString(WorkQueueOperation.SYNC_FILE_FLAGS.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildFileRemove(File wriAbsPath, File localAbspath) throws SVNException {
        return SVNWCContext.wqBuildFileRemove((SVNWCDb)this.getDb(), wriAbsPath, localAbspath);
    }

    public static SVNSkel wqBuildFileRemove(SVNWCDb db, File wriAbspath, File localAbspath) throws SVNException {
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependPath(db.toRelPath(wriAbspath, localAbspath));
        workItem.prependString(WorkQueueOperation.FILE_REMOVE.getOpName());
        return workItem;
    }

    public SVNSkel wqBuildDirInstall(File localAbsPath) throws SVNException {
        return SVNWCContext.wqBuildDirInstall((SVNWCDb)this.getDb(), localAbsPath);
    }

    public static SVNSkel wqBuildDirInstall(SVNWCDb db, File localAbsPath) throws SVNException {
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependPath(db.toRelPath(localAbsPath));
        workItem.prependString(WorkQueueOperation.DIRECTORY_INSTALL.getOpName());
        return workItem;
    }

    public static SVNSkel wqBuildDirRemove(SVNWCDb db, File wriAbspath, File localAbspath, boolean recursive) throws SVNException {
        SVNSkel workItem = SVNSkel.createEmptyList();
        if (recursive) {
            workItem.prependString("1");
        }
        workItem.prependPath(db.toRelPath(wriAbspath, localAbspath));
        workItem.prependString(WorkQueueOperation.DIRECTORY_REMOVE.getOpName());
        return workItem;
    }

    public SVNSkel wqBuildPrejInstall(File localAbspath, SVNSkel conflictSkel) throws SVNException {
        return SVNWCContext.wqBuildPrejInstall(this.getDb(), localAbspath, conflictSkel);
    }

    public static SVNSkel wqBuildPrejInstall(ISVNWCDb db, File localAbspath, SVNSkel conflictSkel) throws SVNException {
        assert (conflictSkel != null);
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prepend(conflictSkel);
        workItem.prependPath(SVNWCContext.getRelativePath((SVNWCDb)db, localAbspath));
        workItem.prependString(WorkQueueOperation.PREJ_INSTALL.getOpName());
        return workItem;
    }

    public SVNSkel wqBuildSetPropertyConflictMarkerTemp(File localAbspath, File prejFile) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        SVNSkel workItem = SVNSkel.createEmptyList();
        File wcRoot = this.getDb().getWCRoot(localAbspath);
        String prejPath = null;
        if (prejFile != null) {
            prejPath = SVNWCUtils.getPathAsChild(wcRoot, prejFile);
        }
        workItem.prependString(prejPath != null ? prejPath : "");
        workItem.prependPath(this.getRelativePath(localAbspath));
        workItem.prependString(WorkQueueOperation.TMP_SET_PROPERTY_CONFLICT_MARKER.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    public SVNSkel wqBuildPostUpgrade() throws SVNException {
        SVNSkel result = SVNSkel.createEmptyList();
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependString(WorkQueueOperation.POSTUPGRADE.getOpName());
        result.prepend(workItem);
        return result;
    }

    public static SVNSkel wqMerge(SVNSkel workItem1, SVNSkel workItem2) throws SVNException {
        if (workItem1 == null) {
            return workItem2;
        }
        if (workItem2 == null) {
            return workItem1;
        }
        if (SVNWCContext.isSingleWorkItem(workItem1)) {
            if (SVNWCContext.isSingleWorkItem(workItem2)) {
                SVNSkel result = SVNSkel.createEmptyList();
                result.prepend(workItem2);
                result.prepend(workItem1);
                return result;
            }
            workItem2.prepend(workItem1);
            return workItem2;
        }
        if (SVNWCContext.isSingleWorkItem(workItem2)) {
            workItem1.appendChild(workItem2);
            return workItem1;
        }
        int listSize = workItem2.getListSize();
        for (int i = 0; i < listSize; ++i) {
            workItem1.appendChild(workItem2.getChild(i));
        }
        return workItem1;
    }

    private static boolean isSingleWorkItem(SVNSkel workItem) {
        return workItem.first().isAtom();
    }

    public void wqRun(File dirAbspath) throws SVNException {
        File wcRootAbspath = this.getDb().getWCRoot(dirAbspath);
        SVNSqlJetDb sDb = this.db.getSDb(dirAbspath);
        sDb.beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            while (true) {
                this.checkCancelled();
                ISVNWCDb.WCDbWorkQueueInfo fetchWorkQueue = this.db.fetchWorkQueue(dirAbspath);
                if (fetchWorkQueue.workItem == null) break;
                this.dispatchWorkItem(wcRootAbspath, fetchWorkQueue.workItem);
                this.db.completedWorkQueue(dirAbspath, fetchWorkQueue.id);
            }
            sDb.commit();
        }
        catch (SVNException e) {
            sDb.rollback();
            throw e;
        }
    }

    private void dispatchWorkItem(File wcRootAbspath, SVNSkel workItem) throws SVNException {
        if (!workItem.isAtom()) {
            for (WorkQueueOperation scan : WorkQueueOperation.values()) {
                if (!scan.getOpName().equals(workItem.getChild(0).getValue())) continue;
                scan.getOperation().runOperation(this, wcRootAbspath, workItem);
                return;
            }
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_BAD_ADM_LOG, "Unrecognized work item in the queue associated with ''{0}''", (Object)wcRootAbspath);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    public void removeBaseNode(File localAbspath) throws SVNException {
        ISVNWCDb.SVNWCDbKind baseKind;
        ISVNWCDb.SVNWCDbStatus baseStatus;
        ISVNWCDb.WCDbInfo readInfo;
        this.checkCancelled();
        try {
            readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.haveBase, ISVNWCDb.WCDbInfo.InfoField.haveWork);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return;
            }
            throw e;
        }
        if (!readInfo.haveBase) {
            return;
        }
        ISVNWCDb.SVNWCDbStatus wrkStatus = readInfo.status;
        ISVNWCDb.SVNWCDbKind wrkKind = readInfo.kind;
        boolean haveBase = readInfo.haveBase;
        assert (haveBase);
        if (wrkStatus == ISVNWCDb.SVNWCDbStatus.Normal || wrkStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || wrkStatus == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
            baseStatus = wrkStatus;
            baseKind = wrkKind;
        } else {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind);
            baseStatus = baseInfo.status;
            baseKind = baseInfo.kind;
        }
        if (baseKind == ISVNWCDb.SVNWCDbKind.Dir && (baseStatus == ISVNWCDb.SVNWCDbStatus.Normal || baseStatus == ISVNWCDb.SVNWCDbStatus.Incomplete)) {
            Set<String> children = this.db.getBaseChildren(localAbspath);
            for (String childName : children) {
                File childAbspath = SVNFileUtil.createFilePath(localAbspath, childName);
                this.removeBaseNode(childAbspath);
            }
        }
        if (baseStatus == ISVNWCDb.SVNWCDbStatus.Normal && wrkStatus != ISVNWCDb.SVNWCDbStatus.Added && wrkStatus != ISVNWCDb.SVNWCDbStatus.Excluded) {
            if (wrkStatus != ISVNWCDb.SVNWCDbStatus.Deleted && (baseKind == ISVNWCDb.SVNWCDbKind.File || baseKind == ISVNWCDb.SVNWCDbKind.Symlink)) {
                SVNFileUtil.deleteFile(localAbspath);
            } else if (baseKind == ISVNWCDb.SVNWCDbKind.Dir && wrkStatus != ISVNWCDb.SVNWCDbStatus.Deleted) {
                SVNFileUtil.deleteFile(localAbspath);
            }
        }
        this.db.removeBase(localAbspath);
    }

    public void getAndRecordFileInfo(File localAbspath, boolean ignoreError) throws SVNException {
        if (localAbspath.exists()) {
            long timeInMicros = SVNFileUtil.getFileLastModifiedMicros(localAbspath);
            long length = SVNFileUtil.getFileLength(localAbspath);
            this.db.globalRecordFileinfo(localAbspath, length, timeInMicros);
        }
    }

    public void syncFileFlags(File localAbspath) throws SVNException {
        SVNFileUtil.setReadonly(localAbspath, false);
        SVNFileUtil.setExecutable(localAbspath, false);
        this.maybeSetReadOnly(localAbspath);
        this.maybeSetExecutable(localAbspath);
    }

    private boolean maybeSetReadOnly(File localAbspath) throws SVNException {
        ISVNWCDb.SVNWCDbLock lock;
        ISVNWCDb.SVNWCDbStatus status;
        boolean didSet;
        block6: {
            assert (SVNFileUtil.isAbsolute(localAbspath));
            didSet = false;
            status = null;
            lock = null;
            try {
                ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.lock);
                status = readInfo.status;
                lock = readInfo.lock;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block6;
                throw e;
            }
        }
        if (lock != null) {
            return didSet;
        }
        if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            return didSet;
        }
        String needsLock = this.getProperty(localAbspath, "svn:needs-lock");
        SVNProperties pristineProperties = this.getPristineProps(localAbspath);
        if (needsLock != null && pristineProperties != null && pristineProperties.getStringValue("svn:needs-lock") != null) {
            SVNFileUtil.setReadonly(localAbspath, true);
            didSet = true;
        }
        return didSet;
    }

    private boolean maybeSetExecutable(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        boolean didSet = false;
        String propval = this.getProperty(localAbspath, "svn:executable");
        if (propval != null) {
            SVNFileUtil.setExecutable(localAbspath, true);
            didSet = true;
        }
        return didSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createPrejFile(File localAbspath, SVNSkel conflictSkel) throws SVNException {
        File tempDirAbspath = this.db.getWCRootTempDir(localAbspath);
        UniqueFileInfo openUniqueFile = SVNWCContext.openUniqueFile(tempDirAbspath, true);
        OutputStream stream = openUniqueFile.stream;
        File tempAbspath = openUniqueFile.path;
        try {
            for (SVNSkel scan = conflictSkel.first().next(); scan != null; scan = scan.next()) {
                this.appendPropConflict(stream, scan);
            }
        }
        finally {
            SVNFileUtil.closeFile(stream);
        }
        return tempAbspath;
    }

    private void appendPropConflict(OutputStream stream, SVNSkel propSkel) throws SVNException {
        String message = this.messageFromSkel(propSkel);
        try {
            stream.write(message.getBytes());
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String messageFromSkel(SVNSkel skel) throws SVNException {
        String propname = skel.getChild(1).getValue();
        SVNPropertyValue original = this.maybePropValue(propname, skel.getChild(2));
        SVNPropertyValue mine = this.maybePropValue(propname, skel.getChild(3));
        SVNPropertyValue incoming = this.maybePropValue(propname, skel.getChild(4));
        SVNPropertyValue incomingBase = this.maybePropValue(propname, skel.getChild(5));
        String conflictMessage = this.generateConflictMessage(propname, original, mine, incoming, incomingBase);
        if (mine == null) {
            mine = SVNPropertyValue.create("");
        }
        if (incoming == null) {
            incoming = SVNPropertyValue.create("");
        }
        if (original == null) {
            original = incomingBase != null ? incomingBase : SVNPropertyValue.create("");
        } else if (incomingBase != null && mine.equals(original)) {
            original = incomingBase;
        }
        byte[] originalBytes = SVNPropertyValue.getPropertyAsBytes(original);
        byte[] mineBytes = SVNPropertyValue.getPropertyAsBytes(mine);
        byte[] incomingBytes = SVNPropertyValue.getPropertyAsBytes(incoming);
        boolean mineIsBinary = false;
        try {
            mineIsBinary = mineBytes != null && SVNFileUtil.detectMimeType(new ByteArrayInputStream(mineBytes)) != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean incomingIsBinary = false;
        try {
            incomingIsBinary = incomingBytes != null && SVNFileUtil.detectMimeType(new ByteArrayInputStream(incomingBytes)) != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean originalIsBinary = false;
        try {
            originalIsBinary = originalBytes != null && SVNFileUtil.detectMimeType(new ByteArrayInputStream(originalBytes)) != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(originalIsBinary || mineIsBinary || incomingIsBinary)) {
            ConflictMarkersInfo markersInfo = this.initConflictMarkers("(local property value)", "", "(incoming property value)");
            String targetMarker = markersInfo.targetMarker;
            String leftMarker = markersInfo.leftMarker;
            String rightMarker = markersInfo.rightMarker;
            FSMergerBySequence merger = new FSMergerBySequence(targetMarker.getBytes(), CONFLICT_SEPARATOR, rightMarker.getBytes(), leftMarker.getBytes());
            int mergeResult = 0;
            RandomAccessFile localIS = null;
            RandomAccessFile latestIS = null;
            RandomAccessFile baseIS = null;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try {
                SVNDiffOptions diffOptions = new SVNDiffOptions();
                diffOptions.setIgnoreAllWhitespace(false);
                diffOptions.setIgnoreAmountOfWhitespace(false);
                diffOptions.setIgnoreEOLStyle(false);
                mergeResult = merger.merge(new QSequenceLineRAByteData(originalBytes), new QSequenceLineRAByteData(mineBytes), new QSequenceLineRAByteData(incomingBytes), diffOptions, result, SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST);
                result.flush();
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
            }
            finally {
                SVNFileUtil.closeFile(result);
                SVNFileUtil.closeFile(localIS);
                SVNFileUtil.closeFile(baseIS);
                SVNFileUtil.closeFile(latestIS);
            }
            if (mergeResult == 2) {
                conflictMessage = conflictMessage + result.toString();
                return conflictMessage;
            }
        }
        if (mineBytes != null && mineBytes.length > 0) {
            conflictMessage = conflictMessage + "Local property value:\n";
            conflictMessage = mineIsBinary ? conflictMessage + "Cannot display: property value is binary data\n" : conflictMessage + SVNPropertyValue.getPropertyAsString(mine);
            conflictMessage = conflictMessage + "\n";
        }
        if (incomingBytes != null && incomingBytes.length > 0) {
            conflictMessage = conflictMessage + "Incoming property value:\n";
            conflictMessage = incomingIsBinary ? conflictMessage + "Cannot display: property value is binary data\n" : conflictMessage + SVNPropertyValue.getPropertyAsString(incoming);
            conflictMessage = conflictMessage + "\n";
        }
        return conflictMessage;
    }

    private SVNPropertyValue maybePropValue(String propname, SVNSkel child) throws SVNException {
        if (child.getListSize() != 1) {
            return null;
        }
        byte[] data = child.getChild(0).getData();
        return SVNPropertyValue.create(propname, data);
    }

    private String generateConflictMessage(String propname, SVNPropertyValue original, SVNPropertyValue mine, SVNPropertyValue incoming, SVNPropertyValue incomingBase) {
        if (incomingBase == null) {
            if (mine != null) {
                assert (!mine.equals(incoming));
                return String.format("Trying to add new property '%s'\nbut the property already exists.\n", propname);
            }
            return String.format("Trying to add new property '%s'\nbut the property has been locally deleted.\n", propname);
        }
        if (incoming == null) {
            if (original == null && mine != null) {
                return String.format("Trying to delete property '%s'\nbut the property has been locally added.\n", propname);
            }
            if (original.equals(incomingBase)) {
                if (mine != null) {
                    return String.format("Trying to delete property '%s'\nbut the property has been locally modified.\n", propname);
                }
            } else if (mine == null) {
                return String.format("Trying to delete property '%s'\nbut the property has been locally deleted and had a different value.\n", propname);
            }
            return String.format("Trying to delete property '%s'\nbut the local property value is different.\n", propname);
        }
        if (original != null && mine != null && original.equals(mine)) {
            return String.format("Trying to change property '%s'\nbut the local property value conflicts with the incoming change.\n", propname);
        }
        if (original != null && mine != null) {
            return String.format("Trying to change property '%s'\nbut the property has already been locally changed to a different value.\n", propname);
        }
        if (original != null) {
            return String.format("Trying to change property '%s'\nbut the property has been locally deleted.\n", propname);
        }
        if (mine != null) {
            return String.format("Trying to change property '%s'\nbut the property has been locally added with a different value.\n", propname);
        }
        return String.format("Trying to change property '%s'\nbut the property does not exist locally.\n", propname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveConflictOnNode(File localAbsPath, boolean resolveText, boolean resolveProps, SVNConflictChoice conflictChoice) throws SVNException {
        File conflictDirAbspath;
        boolean didResolve;
        File propRejectFile;
        File conflictWorking;
        File conflictNew;
        File conflictOld;
        block17: {
            File autoResolveSrc;
            block16: {
                block22: {
                    block23: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        conflictOld = null;
                                        conflictNew = null;
                                        conflictWorking = null;
                                        propRejectFile = null;
                                        didResolve = false;
                                        ISVNWCDb.SVNWCDbKind kind = this.getDb().readKind(localAbsPath, true);
                                        List<SVNConflictDescription> conflicts = this.getDb().readConflicts(localAbsPath);
                                        for (SVNConflictDescription desc : conflicts) {
                                            if (desc.isTextConflict()) {
                                                conflictOld = desc.getMergeFiles().getBaseFile();
                                                conflictNew = desc.getMergeFiles().getRepositoryFile();
                                                conflictWorking = desc.getMergeFiles().getLocalFile();
                                                continue;
                                            }
                                            if (!desc.isPropertyConflict()) continue;
                                            propRejectFile = desc.getMergeFiles().getRepositoryFile();
                                        }
                                        conflictDirAbspath = kind == ISVNWCDb.SVNWCDbKind.Dir ? localAbsPath : SVNFileUtil.getFileDir(localAbsPath);
                                        if (!resolveText) break block17;
                                        autoResolveSrc = null;
                                        if (conflictChoice != SVNConflictChoice.BASE) break block18;
                                        autoResolveSrc = conflictOld;
                                        break block16;
                                    }
                                    if (conflictChoice != SVNConflictChoice.MINE_FULL) break block19;
                                    autoResolveSrc = conflictWorking;
                                    break block16;
                                }
                                if (conflictChoice != SVNConflictChoice.THEIRS_FULL) break block20;
                                autoResolveSrc = conflictNew;
                                break block16;
                            }
                            if (conflictChoice != SVNConflictChoice.MERGED) break block21;
                            autoResolveSrc = null;
                            break block16;
                        }
                        if (conflictChoice != SVNConflictChoice.THEIRS_CONFLICT && conflictChoice != SVNConflictChoice.MINE_CONFLICT) break block22;
                        if (conflictOld == null || conflictWorking == null || conflictNew == null) break block23;
                        File tempDir = this.getDb().getWCRootTempDir(conflictDirAbspath);
                        SVNDiffConflictChoiceStyle style = conflictChoice == SVNConflictChoice.THEIRS_CONFLICT ? SVNDiffConflictChoiceStyle.CHOOSE_LATEST : SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED;
                        UniqueFileInfo openUniqueFile = SVNWCContext.openUniqueFile(tempDir, false);
                        autoResolveSrc = openUniqueFile.path;
                        if (!SVNFileUtil.isAbsolute(conflictOld)) {
                            conflictOld = SVNFileUtil.createFilePath(conflictDirAbspath, conflictOld);
                        }
                        if (!SVNFileUtil.isAbsolute(conflictWorking)) {
                            conflictWorking = SVNFileUtil.createFilePath(conflictDirAbspath, conflictWorking);
                        }
                        if (!SVNFileUtil.isAbsolute(conflictNew)) {
                            conflictNew = SVNFileUtil.createFilePath(conflictDirAbspath, conflictNew);
                        }
                        byte[] nullBytes = new byte[]{};
                        FSMergerBySequence merger = new FSMergerBySequence(nullBytes, nullBytes, nullBytes);
                        RandomAccessFile localIS = null;
                        RandomAccessFile latestIS = null;
                        RandomAccessFile baseIS = null;
                        OutputStream result = null;
                        try {
                            result = SVNFileUtil.openFileForWriting(autoResolveSrc);
                            baseIS = new RandomAccessFile(conflictOld, "r");
                            localIS = new RandomAccessFile(conflictWorking, "r");
                            latestIS = new RandomAccessFile(conflictNew, "r");
                            QSequenceLineRAFileData baseData = new QSequenceLineRAFileData(baseIS);
                            QSequenceLineRAFileData localData = new QSequenceLineRAFileData(localIS);
                            QSequenceLineRAFileData latestData = new QSequenceLineRAFileData(latestIS);
                            merger.merge(baseData, localData, latestData, null, result, style);
                        }
                        catch (IOException e) {
                            try {
                                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                                SVNErrorManager.error(err, e, SVNLogType.WC);
                            }
                            catch (Throwable throwable) {
                                SVNFileUtil.closeFile(result);
                                SVNFileUtil.closeFile(localIS);
                                SVNFileUtil.closeFile(baseIS);
                                SVNFileUtil.closeFile(latestIS);
                                throw throwable;
                            }
                            SVNFileUtil.closeFile(result);
                            SVNFileUtil.closeFile(localIS);
                            SVNFileUtil.closeFile(baseIS);
                            SVNFileUtil.closeFile(latestIS);
                            break block16;
                        }
                        SVNFileUtil.closeFile(result);
                        SVNFileUtil.closeFile(localIS);
                        SVNFileUtil.closeFile(baseIS);
                        SVNFileUtil.closeFile(latestIS);
                        break block16;
                    }
                    autoResolveSrc = null;
                    break block16;
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Invalid 'conflict_result' argument");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (autoResolveSrc != null) {
                SVNFileUtil.copyFile(SVNFileUtil.createFilePath(conflictDirAbspath, autoResolveSrc), localAbsPath, true);
            }
        }
        boolean foundFile = false;
        if (resolveText) {
            foundFile = this.attemptDeletion(conflictDirAbspath, conflictOld);
            foundFile = this.attemptDeletion(conflictDirAbspath, conflictNew);
            foundFile = this.attemptDeletion(conflictDirAbspath, conflictWorking);
            boolean bl = resolveText = conflictOld != null || conflictNew != null || conflictWorking != null;
        }
        if (resolveProps) {
            if (propRejectFile != null) {
                foundFile = this.attemptDeletion(conflictDirAbspath, propRejectFile);
            } else {
                resolveProps = false;
            }
        }
        if (resolveText || resolveProps) {
            this.getDb().opMarkResolved(localAbsPath, resolveText, resolveProps, false, null);
            if (foundFile) {
                didResolve = true;
            }
        }
        return didResolve;
    }

    private void resolveOneConflict(File localAbsPath, boolean resolveText, String resolveProps, boolean resolveTree, SVNConflictChoice conflictChoice) throws SVNException {
        boolean resolved = false;
        List<SVNConflictDescription> conflicts = this.getDb().readConflicts(localAbsPath);
        Iterator<SVNConflictDescription> iterator2 = conflicts.iterator();
        if (iterator2.hasNext()) {
            SVNConflictDescription desc = iterator2.next();
            if (desc.isTreeConflict()) {
                if (resolveTree) {
                    if (conflictChoice != SVNConflictChoice.MERGED) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Tree conflicts can only be resolved to 'working' state; {0} not resolved", (Object)localAbsPath);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    this.getDb().opSetTreeConflict(localAbsPath, null);
                    resolved = true;
                }
            } else if (desc.isTextConflict()) {
                if (resolveText && this.resolveConflictOnNode(localAbsPath, true, false, conflictChoice)) {
                    resolved = true;
                }
            } else if (desc.isPropertyConflict() && !"".equals(resolveProps) && (!"".equals(resolveProps) || resolveProps.equals(desc.getPropertyName())) && this.resolveConflictOnNode(localAbsPath, false, true, conflictChoice)) {
                resolved = true;
            }
        }
        if (resolved && this.getEventHandler() != null) {
            SVNEvent event = new SVNEvent(localAbsPath, null, null, -1L, null, null, null, null, SVNEventAction.RESOLVED, null, null, null, null, null, null);
            this.getEventHandler().handleEvent(event, 0.0);
        }
    }

    private void recursiveResolveConflict(File localAbsPath, SVNDepth depth, boolean resolveText, String resolveProps, boolean resolveTree, SVNConflictChoice conflictChoice, ISVNConflictHandler conflictHandler) throws SVNException {
        if (resolveProps != null && resolveProps.length() > 0) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Resolving a single property is not (yet) supported.");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        Structure<StructureFields.NodeInfo> nodeInfoStructure = this.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.conflicted);
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
        boolean conflicted = nodeInfoStructure.is(StructureFields.NodeInfo.conflicted);
        if (kind != ISVNWCDb.SVNWCDbKind.Dir) {
            depth = SVNDepth.EMPTY;
        } else if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        if (this.getEventHandler() != null) {
            this.getEventHandler().handleEvent(new SVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, null, SVNEventAction.RESOLVER_STARTING, SVNEventAction.RESOLVER_STARTING, null, null, null, null, null), -1.0);
        }
        ConflictStatusWalker statusWalker = new ConflictStatusWalker();
        statusWalker.resolveText = resolveText;
        statusWalker.resolveProp = resolveProps;
        statusWalker.resolveTree = resolveTree;
        statusWalker.conflictChoice = conflictChoice;
        statusWalker.conflictHandler = conflictHandler;
        SVNStatusEditor17 editor = new SVNStatusEditor17(localAbsPath, this, this.getOptions(), false, false, depth, statusWalker);
        editor.walkStatus(localAbsPath, depth, false, false, true, null);
        if (this.getEventHandler() != null) {
            this.getEventHandler().handleEvent(new SVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, null, SVNEventAction.RESOLVER_DONE, SVNEventAction.RESOLVER_DONE, null, null, null, null, null), -1.0);
        }
    }

    public void resolvedConflict(File localAbsPath, SVNDepth depth, boolean resolveText, String resolveProps, boolean resolveTree, SVNConflictChoice conflictChoice) throws SVNException {
        this.recursiveResolveConflict(localAbsPath, depth, resolveText, resolveProps, resolveTree, conflictChoice, this.getOptions().getConflictResolver());
    }

    private boolean attemptDeletion(File parentDir, File baseName) throws SVNException {
        if (baseName == null) {
            return false;
        }
        File fullPath = SVNFileUtil.createFilePath(parentDir, baseName);
        return SVNFileUtil.deleteFile(fullPath);
    }

    public int checkWC(File localAbsPath) throws SVNException {
        return this.checkWC(localAbsPath, false);
    }

    private int checkWC(File localAbsPath, boolean check2) throws SVNException {
        int wcFormat;
        block12: {
            wcFormat = 0;
            try {
                wcFormat = this.db.getFormatTemp(localAbsPath);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_MISSING) {
                    throw e;
                }
                wcFormat = 0;
                SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath));
                if (kind != SVNNodeKind.NONE) break block12;
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' does not exist", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
                return 0;
            }
        }
        if (wcFormat >= 12) {
            ISVNWCDb.SVNWCDbKind dbKind;
            ISVNWCDb.SVNWCDbStatus dbStatus;
            SVNNodeKind wcKind;
            if (check2 && (wcKind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath))) != SVNNodeKind.DIR) {
                return 0;
            }
            try {
                ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind);
                dbStatus = readInfo.status;
                dbKind = readInfo.kind;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    return 0;
                }
                throw e;
            }
            if (dbKind != ISVNWCDb.SVNWCDbKind.Dir) {
                return 0;
            }
            switch (dbStatus) {
                case NotPresent: 
                case ServerExcluded: 
                case Excluded: {
                    return 0;
                }
            }
        }
        return wcFormat;
    }

    public void initializeWC(File localAbspath, SVNURL url, SVNURL repositoryRoot, String uuid, long revision, SVNDepth depth, int targetWorkingCopyFormat) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (url != null);
        assert (repositoryRoot != null);
        assert (uuid != null);
        int format = this.checkWC(localAbspath, true);
        File reposRelpath = SVNFileUtil.createFilePath(SVNWCUtils.isChild(repositoryRoot, url));
        if (reposRelpath == null) {
            reposRelpath = SVNFileUtil.createFilePath("");
        }
        if (format < 29) {
            this.initWC(localAbspath, reposRelpath, repositoryRoot, uuid, revision, depth, targetWorkingCopyFormat);
            return;
        }
        ISVNWCDb.WCDbInfo readInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        long dbRevision = readInfo.revision;
        File dbReposRelpath = readInfo.reposRelPath;
        SVNURL dbReposRootUrl = readInfo.reposRootUrl;
        String dbReposUuid = readInfo.reposUuid;
        if (status != ISVNWCDb.SVNWCDbStatus.Deleted && status != ISVNWCDb.SVNWCDbStatus.NotPresent) {
            if (dbRevision != revision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Revision {0} doesn't match existing revision {1} in ''{2}''", revision, dbRevision, localAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (dbReposRootUrl == null) {
                if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                    ISVNWCDb.WCDbAdditionInfo scanAddition = this.db.scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid);
                    dbReposRelpath = scanAddition.reposRelPath;
                    dbReposRootUrl = scanAddition.reposRootUrl;
                    dbReposUuid = scanAddition.reposUuid;
                } else {
                    ISVNWCDb.WCDbRepositoryInfo scanBase = this.db.scanBaseRepository(localAbspath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
                    dbReposRelpath = scanBase.relPath;
                    dbReposRootUrl = scanBase.rootUrl;
                    dbReposUuid = scanBase.uuid;
                }
            }
            if (!(dbReposUuid.equals(uuid) && dbReposRootUrl.equals(repositoryRoot) && SVNWCUtils.isAncestor(dbReposRelpath, reposRelpath))) {
                NodeCopyFromInfo copyFromInfo = this.getNodeCopyFromInfo(localAbspath, NodeCopyFromField.rootUrl, NodeCopyFromField.reposRelPath);
                SVNURL copyfromRootUrl = copyFromInfo.rootUrl;
                File copyfromReposRelpath = copyFromInfo.reposRelPath;
                if (copyfromRootUrl == null || !copyfromRootUrl.equals(repositoryRoot) || !copyfromReposRelpath.equals(reposRelpath)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL ''{0}'' doesn't match existing URL ''{1}'' in ''{2}''", url, SVNWCUtils.join(dbReposRootUrl, dbReposRelpath), localAbspath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        }
    }

    private void initWC(File localAbspath, File reposRelpath, SVNURL repositoryRoot, String uuid, long revNumber, SVNDepth depth, int workingCopyFormat) throws SVNException {
        File wcAdmDir = SVNWCUtils.admChild(localAbspath, null);
        SVNFileUtil.ensureDirectoryExists(wcAdmDir);
        SVNFileUtil.setHidden(wcAdmDir, true);
        SVNFileUtil.ensureDirectoryExists(SVNWCUtils.admChild(localAbspath, WC_ADM_PRISTINE));
        SVNFileUtil.ensureDirectoryExists(SVNWCUtils.admChild(localAbspath, WC_ADM_TMP));
        SVNFileUtil.writeToFile(SVNWCUtils.admChild(localAbspath, WC_ADM_FORMAT), "12", null);
        SVNFileUtil.writeToFile(SVNWCUtils.admChild(localAbspath, WC_ADM_ENTRIES), "12", null);
        this.db.init(localAbspath, reposRelpath, repositoryRoot, uuid, revNumber, depth, workingCopyFormat);
    }

    public String getActualTarget(File path) throws SVNException {
        ISVNWCDb.SVNWCDbKind kind;
        boolean switched;
        boolean wcRoot;
        block3: {
            wcRoot = false;
            switched = false;
            kind = null;
            try {
                CheckWCRootInfo checkWCRoot = this.checkWCRoot(path.getAbsoluteFile(), true);
                wcRoot = checkWCRoot.wcRoot;
                kind = checkWCRoot.kind;
                switched = checkWCRoot.switched;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) break block3;
                throw e;
            }
        }
        if (!wcRoot && !switched || kind != ISVNWCDb.SVNWCDbKind.Dir) {
            return path.getName();
        }
        return "";
    }

    public File getNodeReposRelPath(File localAbsPath) throws SVNException {
        ISVNWCDb.WCDbInfo readInfo = this.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.haveBase);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        File reposRelPath = readInfo.reposRelPath;
        boolean haveBase = readInfo.haveBase;
        if (reposRelPath == null) {
            if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                reposRelPath = this.getDb().scanAddition((File)localAbsPath, (ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[])new ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[]{ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath}).reposRelPath;
            } else if (haveBase) {
                reposRelPath = this.getDb().scanBaseRepository((File)localAbsPath, (ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[])new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath}).relPath;
            } else if (status == ISVNWCDb.SVNWCDbStatus.Excluded || !haveBase && status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                File parentAbspath = SVNFileUtil.getParentFile(localAbsPath);
                String name = SVNFileUtil.getFileName(localAbsPath);
                File parentRelpath = this.getNodeReposRelPath(parentAbspath);
                if (parentRelpath != null) {
                    reposRelPath = SVNFileUtil.createFilePath(parentRelpath, name);
                }
            } else {
                reposRelPath = null;
            }
        }
        return reposRelPath;
    }

    public boolean isChangelistMatch(File localAbsPath, Collection<String> changelistsSet) {
        if (changelistsSet == null || changelistsSet.isEmpty()) {
            return true;
        }
        try {
            String changelist = this.db.readInfo((File)localAbsPath, (ISVNWCDb.WCDbInfo.InfoField[])new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.changelist}).changelist;
            return changelist != null && changelistsSet.contains(changelist);
        }
        catch (SVNException e) {
            return false;
        }
    }

    public boolean isNodeStatusDeleted(File localAbsPath) throws SVNException {
        return this.getDb().readInfo((File)localAbsPath, (ISVNWCDb.WCDbInfo.InfoField[])new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.status}).status == ISVNWCDb.SVNWCDbStatus.Deleted;
    }

    public PropDiffs getPropDiffs(File localAbsPath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        PropDiffs propDiffs = new PropDiffs();
        SVNProperties baseProps = this.getDb().readPristineProperties(localAbsPath);
        if (baseProps == null) {
            baseProps = new SVNProperties();
        }
        propDiffs.originalProps = baseProps;
        SVNProperties actualProps = this.getDb().readProperties(localAbsPath);
        propDiffs.propChanges = SVNWCUtils.propDiffs(actualProps, baseProps);
        return propDiffs;
    }

    public ISVNWCDb.SVNWCDbLock getNodeLock(File localAbsPath) throws SVNException {
        try {
            return this.getDb().getBaseInfo((File)localAbsPath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock}).lock;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            return null;
        }
    }

    public List<File> getNodeChildren(File dirAbsPath, boolean showHidden) throws SVNException {
        Set<String> relChildren = this.getDb().readChildren(dirAbsPath);
        ArrayList<File> childs = new ArrayList<File>();
        for (String child : relChildren) {
            boolean childIsHiden;
            File childAbsPath = SVNFileUtil.createFilePath(dirAbsPath, child);
            if (!showHidden && (childIsHiden = this.getDb().isNodeHidden(childAbsPath))) continue;
            childs.add(childAbsPath);
        }
        return childs;
    }

    public List<File> getChildrenOfWorkingNode(File dirAbsPath, boolean showHidden) throws SVNException {
        Set<String> relChildren = this.getDb().getChildrenOfWorkingNode(dirAbsPath);
        ArrayList<File> childs = new ArrayList<File>();
        for (String child : relChildren) {
            boolean childIsHiden;
            File childAbsPath = SVNFileUtil.createFilePath(dirAbsPath, child);
            if (!showHidden && (childIsHiden = this.getDb().isNodeHidden(childAbsPath))) continue;
            childs.add(childAbsPath);
        }
        return childs;
    }

    public SVNDepth getNodeDepth(File localAbsPath) throws SVNException {
        return this.getDb().readInfo((File)localAbsPath, (ISVNWCDb.WCDbInfo.InfoField[])new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.depth}).depth;
    }

    public SVNSkel wqBuildFileCommit(File localAbspath, boolean propsMods) throws SVNException {
        SVNSkel workItem = SVNSkel.createEmptyList();
        workItem.prependString("0");
        workItem.prependString("0");
        workItem.prependPath(this.getRelativePath(localAbspath));
        workItem.prependString(WorkQueueOperation.FILE_COMMIT.getOpName());
        SVNSkel result = SVNSkel.createEmptyList();
        result.appendChild(workItem);
        return result;
    }

    private File getRelativePath(File localAbsPath) throws SVNException {
        return SVNWCContext.getRelativePath((SVNWCDb)this.getDb(), localAbsPath);
    }

    private static File getRelativePath(SVNWCDb db, File localAbspath) throws SVNException {
        if (localAbspath == null) {
            return null;
        }
        SVNWCDb.DirParsedInfo parseDir = db.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        return parseDir.localRelPath;
    }

    public void ensureNoUnfinishedTransactions() throws SVNException {
        ((SVNWCDb)this.getDb()).ensureNoUnfinishedTransactions();
    }

    public void canonicalizeURLs(File path, SVNExternalsStore externalsStore, boolean omitDefaultPort) throws SVNException {
        SVNWCDb.DirParsedInfo parseDir = ((SVNWCDb)this.getDb()).parseDir(path, SVNSqlJetDb.Mode.ReadWrite);
        SvnWcDbShared.canonicalizeURLs(parseDir.wcDbDir.getWCRoot(), true, externalsStore, omitDefaultPort);
        this.wqRun(path);
    }

    public void setSqliteJournalMode(SqlJetPagerJournalMode sqliteJournalMode) {
        if (this.db != null) {
            ((SVNWCDb)this.db).setJournalModel(sqliteJournalMode);
        }
    }

    public void setSqliteTemporaryDbInMemory(boolean temporaryDbInMemory) {
        if (this.db != null) {
            ((SVNWCDb)this.db).setTemporaryDbInMemory(temporaryDbInMemory);
        }
    }

    public SVNSkel conflictCreateMarker(SVNSkel conflictSkel, File localAbsPath) throws SVNException {
        Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflictSkel);
        SVNOperation operation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
        boolean propConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.propConflicted);
        if (propConflicted) {
            String markerName;
            File markerDir;
            SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath));
            if (kind == SVNNodeKind.DIR) {
                markerDir = localAbsPath;
                markerName = THIS_DIR_PREJ;
            } else {
                markerDir = SVNFileUtil.getParentFile(localAbsPath);
                markerName = SVNFileUtil.getFileName(localAbsPath);
            }
            File markerAbsPath = SVNFileUtil.createUniqueFile(markerDir, markerName, PROP_REJ_EXT, false);
            File markerRelPath = ((SVNWCDb)this.getDb()).toRelPath(localAbsPath, markerAbsPath);
            SVNSkel propConflict = SvnWcDbConflicts.getConflict(conflictSkel, SvnWcDbConflicts.ConflictKind.prop);
            propConflict.first().next().prependPath(markerRelPath);
            Structure<SvnWcDbConflicts.PropertyConflictInfo> propertyConflictInfoStructure = SvnWcDbConflicts.readPropertyConflict(this.getDb(), localAbsPath, conflictSkel);
            SVNProperties mineProps = SVNProperties.wrap((SVNHashMap)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.mineProps));
            SVNProperties theirOriginalProps = SVNProperties.wrap((SVNHashMap)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.theirOldProps));
            SVNProperties theirProps = SVNProperties.wrap((SVNHashMap)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.theirProps));
            Set conflictedProps = (Set)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.conflictedPropNames);
            SVNProperties oldProps = operation == SVNOperation.MERGE ? this.getDb().readPristineProperties(localAbsPath) : theirOriginalProps;
            SVNSkel propData = SVNSkel.createEmptyList();
            propData.prepend(SVNSkel.createEmptyList());
            for (String propName : conflictedProps) {
                SvnWcDbConflicts.addPropConflict(propData, propName, oldProps != null ? oldProps.getSVNPropertyValue(propName) : null, mineProps != null ? mineProps.getSVNPropertyValue(propName) : null, theirProps != null ? theirProps.getSVNPropertyValue(propName) : null, theirOriginalProps != null ? theirOriginalProps.getSVNPropertyValue(propName) : null);
            }
            return this.wqBuildPrejInstall(localAbsPath, propData);
        }
        return null;
    }

    public void invokeConflictResolver(File localAbsPath, SVNSkel conflictSkel, ISVNConflictHandler conflictHandler, ISVNCanceller canceller) throws SVNException {
        Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflictSkel);
        SVNOperation operation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
        List locations = (List)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.locations);
        boolean textConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.textConflicted);
        boolean propConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.propConflicted);
        boolean treeConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.treeConflicted);
        SVNConflictVersion leftVersion = null;
        SVNConflictVersion rightVersion = null;
        if (locations != null && locations.size() > 0) {
            leftVersion = (SVNConflictVersion)locations.get(0);
        }
        if (locations != null && locations.size() > 1) {
            rightVersion = (SVNConflictVersion)locations.get(1);
        }
        if (propConflicted) {
            Structure<SvnWcDbConflicts.PropertyConflictInfo> propertyConflictInfoStructure = SvnWcDbConflicts.readPropertyConflict(this.db, localAbsPath, conflictSkel);
            SVNProperties mineProps = SVNProperties.wrap((SVNHashMap)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.mineProps));
            SVNProperties theirOldProps = SVNProperties.wrap((SVNHashMap)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.theirOldProps));
            SVNProperties theirProps = SVNProperties.wrap((SVNHashMap)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.theirProps));
            Set conflicted = (Set)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.conflictedPropNames);
            boolean markResolved = true;
            SVNProperties oldProperties = operation == SVNOperation.MERGE ? this.db.readPristineProperties(localAbsPath) : theirOldProps;
            for (String propName : conflicted) {
                boolean conflictRemains;
                if (canceller != null) {
                    canceller.checkCancelled();
                }
                if (!(conflictRemains = this.generatePropConflict(localAbsPath, operation, leftVersion, rightVersion, propName, oldProperties != null ? oldProperties.getSVNPropertyValue(propName) : null, mineProps != null ? mineProps.getSVNPropertyValue(propName) : null, theirOldProps != null ? theirOldProps.getSVNPropertyValue(propName) : null, theirProps != null ? theirProps.getSVNPropertyValue(propName) : null, conflictHandler))) continue;
                markResolved = false;
            }
            if (markResolved) {
                this.db.opMarkResolved(localAbsPath, false, true, false, null);
            }
        }
        if (textConflicted) {
            Structure<SvnWcDbConflicts.TextConflictInfo> textConflictInfoStructure = SvnWcDbConflicts.readTextConflict(this.db, localAbsPath, conflictSkel);
            File mineAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.mineAbsPath);
            File theirOldAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.theirOldAbsPath);
            File theirAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.theirAbsPath);
            TextConflictResolutionInfo resolutionInfo = this.resolveTextConflict(localAbsPath, operation, theirOldAbsPath, theirAbsPath, leftVersion, rightVersion, localAbsPath, mineAbsPath, conflictHandler);
            SVNSkel workItems = resolutionInfo.workItems;
            boolean wasResolved = resolutionInfo.resolved;
            if (wasResolved) {
                if (workItems != null) {
                    this.getDb().addWorkQueue(localAbsPath, workItems);
                    this.wqRun(localAbsPath);
                }
                this.getDb().opMarkResolved(localAbsPath, true, false, false, null);
            }
        }
        if (treeConflicted) {
            SVNConflictDescription conflictDescription = this.getDb().opReadTreeConflict(localAbsPath);
            conflictDescription = this.setupTreeConflictDesc(localAbsPath, operation, leftVersion, rightVersion, conflictDescription.getConflictReason(), conflictDescription.getConflictAction());
            conflictHandler.handleConflict(conflictDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generatePropConflict(File localAbsPath, SVNOperation operation, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, String propName, SVNPropertyValue baseVal, SVNPropertyValue workingVal, SVNPropertyValue incomingOldVal, SVNPropertyValue incomingNewVal, ISVNConflictHandler conflictHandler) throws SVNException {
        File dirPath = SVNFileUtil.getParentFile(localAbsPath);
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath));
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_FOUND, "The node ''{0}'' was not found.", (Object)localAbsPath);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        SVNWCConflictDescription17 conflictDescription = new SVNWCConflictDescription17();
        conflictDescription.setLocalAbspath(localAbsPath);
        conflictDescription.setNodeKind(kind == SVNNodeKind.DIR ? SVNNodeKind.DIR : SVNNodeKind.FILE);
        conflictDescription.setKind(SVNWCConflictDescription17.ConflictKind.PROPERTY);
        conflictDescription.setPropertyName(propName);
        conflictDescription.setOperation(operation);
        conflictDescription.setSrcLeftVersion(leftVersion);
        conflictDescription.setSrcRightVersion(rightVersion);
        try {
            boolean conflictRemains;
            File uniqueFile;
            if (workingVal != null) {
                uniqueFile = SVNFileUtil.createUniqueFile(dirPath, "svn", "", false);
                SVNFileUtil.writeToFile(uniqueFile, SVNPropertyValue.getPropertyAsBytes(workingVal));
                conflictDescription.setMyFile(uniqueFile);
            }
            if (incomingNewVal != null) {
                uniqueFile = SVNFileUtil.createUniqueFile(dirPath, "svn", "", false);
                SVNFileUtil.writeToFile(uniqueFile, SVNPropertyValue.getPropertyAsBytes(incomingNewVal));
                conflictDescription.setTheirFile(uniqueFile);
            }
            if (baseVal != null || incomingOldVal != null) {
                File uniqueFile2;
                SVNPropertyValue conflictBaseVal;
                if (baseVal != null && incomingOldVal == null || baseVal == null && incomingOldVal != null) {
                    conflictBaseVal = baseVal != null ? baseVal : incomingOldVal;
                    uniqueFile2 = SVNFileUtil.createUniqueFile(dirPath, "svn", "", false);
                    SVNFileUtil.writeToFile(uniqueFile2, SVNPropertyValue.getPropertyAsBytes(conflictBaseVal));
                    conflictDescription.setBaseFile(uniqueFile2);
                } else {
                    conflictBaseVal = !SVNWCContext.arePropsEqual(baseVal, incomingOldVal) ? (workingVal != null && SVNWCContext.arePropsEqual(baseVal, workingVal) ? incomingOldVal : baseVal) : baseVal;
                    uniqueFile2 = SVNFileUtil.createUniqueFile(dirPath, "svn", "", false);
                    SVNFileUtil.writeToFile(uniqueFile2, SVNPropertyValue.getPropertyAsBytes(conflictBaseVal));
                    conflictDescription.setBaseFile(uniqueFile2);
                    if (workingVal != null && incomingNewVal != null) {
                        SVNDiffOptions svnDiffOptions = new SVNDiffOptions();
                        FSMergerBySequence merger = new FSMergerBySequence(CONFLICT_START, CONFLICT_SEPARATOR, CONFLICT_END);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        try {
                            merger.merge(new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(conflictBaseVal)), new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(workingVal)), new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(incomingNewVal)), svnDiffOptions, byteArrayOutputStream, SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST);
                            File tempDir = this.getDb().getWCRootTempDir(localAbsPath);
                            File mergedFile = SVNFileUtil.createUniqueFile(tempDir, SVNFileUtil.getFileName(localAbsPath), PROP_REJ_EXT, false);
                            SVNFileUtil.writeToFile(mergedFile, byteArrayOutputStream.toByteArray());
                            conflictDescription.setMergedFile(mergedFile);
                        }
                        catch (IOException e) {
                            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                            SVNErrorManager.error(errorMessage, SVNLogType.WC);
                        }
                        finally {
                            SVNFileUtil.closeFile(byteArrayOutputStream);
                        }
                    }
                }
            }
            if (incomingOldVal == null && incomingNewVal != null) {
                conflictDescription.setAction(SVNConflictAction.ADD);
            } else if (incomingOldVal != null && incomingNewVal == null) {
                conflictDescription.setAction(SVNConflictAction.DELETE);
            } else {
                conflictDescription.setAction(SVNConflictAction.EDIT);
            }
            if (baseVal != null && workingVal == null) {
                conflictDescription.setReason(SVNConflictReason.DELETED);
            } else if (baseVal == null && workingVal != null) {
                conflictDescription.setReason(SVNConflictReason.OBSTRUCTED);
            } else {
                conflictDescription.setReason(SVNConflictReason.EDITED);
            }
            SVNConflictResult conflictResult = conflictHandler.handleConflict(conflictDescription.toConflictDescription());
            SVNPropertyValue newValue = null;
            if (conflictResult.getConflictChoice() == SVNConflictChoice.POSTPONE) {
                conflictRemains = true;
            } else if (conflictResult.getConflictChoice() == SVNConflictChoice.MINE_FULL) {
                conflictRemains = false;
                newValue = workingVal;
            } else if (conflictResult.getConflictChoice() == SVNConflictChoice.THEIRS_FULL) {
                conflictRemains = false;
                newValue = incomingNewVal;
            } else if (conflictResult.getConflictChoice() == SVNConflictChoice.BASE) {
                conflictRemains = false;
                newValue = baseVal;
            } else if (conflictResult.getConflictChoice() == SVNConflictChoice.MERGED) {
                if (conflictDescription.getMergedFile() == null && conflictResult.getMergedFile() == null) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no merged file");
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                byte[] merged = SVNFileUtil.readFully(conflictResult.getMergedFile() != null ? conflictResult.getMergedFile() : conflictDescription.getMergedFile());
                newValue = SVNPropertyValue.create(propName, merged);
                conflictRemains = false;
            } else {
                conflictRemains = true;
            }
            if (!conflictRemains) {
                SVNProperties props = this.getDb().readProperties(localAbsPath);
                props.put(propName, newValue);
                this.getDb().opSetProps(localAbsPath, props, null, false, null);
            }
            boolean bl = conflictRemains;
            return bl;
        }
        finally {
            try {
                if (conflictDescription != null) {
                    if (conflictDescription.getMyFile() != null) {
                        SVNFileUtil.deleteFile(conflictDescription.getMyFile());
                    }
                    if (conflictDescription.getBaseFile() != null) {
                        SVNFileUtil.deleteFile(conflictDescription.getBaseFile());
                    }
                    if (conflictDescription.getTheirFile() != null) {
                        SVNFileUtil.deleteFile(conflictDescription.getTheirFile());
                    }
                    if (conflictDescription.getMergedFile() != null) {
                        SVNFileUtil.deleteFile(conflictDescription.getMergedFile());
                    }
                }
            }
            catch (SVNException e) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.WC, e);
            }
        }
    }

    public TextConflictResolutionInfo resolveTextConflict(File localAbsPath, SVNOperation operation, File leftAbsPath, File rightAbsPath, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, File resultTarget, File detranslatedTarget, ISVNConflictHandler conflictHandler) throws SVNException {
        TextConflictResolutionInfo resolutionInfo = new TextConflictResolutionInfo();
        resolutionInfo.workItems = null;
        resolutionInfo.resolved = false;
        SVNProperties props = this.db.readProperties(localAbsPath);
        SVNWCConflictDescription17 conflictDescription = new SVNWCConflictDescription17();
        conflictDescription.setLocalAbspath(localAbsPath);
        conflictDescription.setBinary(false);
        conflictDescription.setMimeType(props.getStringValue("svn:mime-type"));
        conflictDescription.setBaseFile(leftAbsPath);
        conflictDescription.setTheirFile(rightAbsPath);
        conflictDescription.setMyFile(detranslatedTarget);
        conflictDescription.setMergedFile(resultTarget);
        conflictDescription.setOperation(operation);
        conflictDescription.setSrcLeftVersion(leftVersion);
        conflictDescription.setSrcRightVersion(rightVersion);
        conflictDescription.setKind(SVNWCConflictDescription17.ConflictKind.TEXT);
        SVNConflictResult result = conflictHandler.handleConflict(conflictDescription.toConflictDescription());
        if (result == null) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no results");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (result.isIsSaveMerged()) {
            SVNWCContext.saveMergeResult(this.db, localAbsPath, result.getMergedFile() != null ? result.getMergedFile() : resultTarget);
        }
        if (result.getConflictChoice() == SVNConflictChoice.POSTPONE) {
            TextConflictResolutionInfo textConflictResolutionInfo = this.evalTextConflictFuncResult(localAbsPath, result.getConflictChoice(), leftAbsPath, rightAbsPath, result.getMergedFile() != null ? result.getMergedFile() : resultTarget, detranslatedTarget);
            SVNSkel workItem = textConflictResolutionInfo.workItems;
            resolutionInfo.resolved = textConflictResolutionInfo.resolved;
            resolutionInfo.workItems = SVNWCContext.wqMerge(resolutionInfo.workItems, workItem);
        } else {
            resolutionInfo.resolved = false;
        }
        return resolutionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextConflictResolutionInfo evalTextConflictFuncResult(File localAbsPath, SVNConflictChoice choice, File leftAbsPath, File rightAbsPath, File mergedAbsPath, File detranslatedTarget) throws SVNException {
        TextConflictResolutionInfo resolutionInfo = new TextConflictResolutionInfo();
        resolutionInfo.workItems = null;
        boolean removeSource = false;
        File installFromAbsPath = null;
        if (choice == SVNConflictChoice.BASE) {
            installFromAbsPath = leftAbsPath;
            resolutionInfo.resolved = true;
        } else if (choice == SVNConflictChoice.THEIRS_FULL) {
            installFromAbsPath = rightAbsPath;
            resolutionInfo.resolved = true;
        } else if (choice == SVNConflictChoice.MINE_FULL) {
            installFromAbsPath = detranslatedTarget;
            resolutionInfo.resolved = true;
        } else if (choice == SVNConflictChoice.THEIRS_CONFLICT || choice == SVNConflictChoice.MINE_CONFLICT) {
            File tempDir = this.getDb().getWCRootTempDir(localAbsPath);
            File uniqueFile = SVNFileUtil.createUniqueFile(tempDir, null, null, false);
            FSMergerBySequence merger = new FSMergerBySequence(null, null, null);
            RandomAccessFile leftRAFile = SVNFileUtil.openRAFileForReading(leftAbsPath);
            RandomAccessFile detranslatedRAFile = SVNFileUtil.openRAFileForReading(detranslatedTarget);
            RandomAccessFile rightRAFile = SVNFileUtil.openRAFileForReading(rightAbsPath);
            OutputStream outputStream2 = null;
            try {
                outputStream2 = new FileOutputStream(uniqueFile);
                outputStream2 = new BufferedOutputStream(outputStream2);
                merger.merge(new QSequenceLineRAFileData(leftRAFile), new QSequenceLineRAFileData(detranslatedRAFile), new QSequenceLineRAFileData(rightRAFile), null, outputStream2, choice == SVNConflictChoice.THEIRS_CONFLICT ? SVNDiffConflictChoiceStyle.CHOOSE_LATEST : SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED);
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            finally {
                SVNFileUtil.closeFile(leftRAFile);
                SVNFileUtil.closeFile(detranslatedRAFile);
                SVNFileUtil.closeFile(rightRAFile);
                SVNFileUtil.closeFile(outputStream2);
            }
            installFromAbsPath = uniqueFile;
            removeSource = true;
            resolutionInfo.resolved = true;
        } else if (choice == SVNConflictChoice.MERGED) {
            installFromAbsPath = mergedAbsPath;
            resolutionInfo.resolved = true;
        } else {
            resolutionInfo.resolved = false;
            return resolutionInfo;
        }
        assert (installFromAbsPath != null);
        SVNSkel workItem = SVNWCContext.wqBuildFileInstall((SVNWCDb)this.db, localAbsPath, installFromAbsPath, false, false);
        resolutionInfo.workItems = SVNWCContext.wqMerge(resolutionInfo.workItems, workItem);
        workItem = SVNWCContext.wqBuildSyncFileFlags((SVNWCDb)this.db, localAbsPath);
        resolutionInfo.workItems = SVNWCContext.wqMerge(resolutionInfo.workItems, workItem);
        if (removeSource) {
            SVNWCContext.wqBuildFileRemove((SVNWCDb)this.db, localAbsPath, installFromAbsPath);
            resolutionInfo.workItems = SVNWCContext.wqMerge(resolutionInfo.workItems, workItem);
        }
        return resolutionInfo;
    }

    private static boolean arePropsEqual(SVNPropertyValue propertyValue1, SVNPropertyValue propertyValue2) {
        byte[] baseBytes = SVNPropertyValue.getPropertyAsBytes(propertyValue1);
        byte[] incomingOldBytes = SVNPropertyValue.getPropertyAsBytes(propertyValue2);
        return Arrays.equals(baseBytes, incomingOldBytes);
    }

    private static SVNSkel saveMergeResult(ISVNWCDb db, File localAbsPath, File sourceAbsPath) throws SVNException {
        File dirPath = SVNFileUtil.getParentFile(localAbsPath);
        String fileName = SVNFileUtil.getFileName(localAbsPath);
        File editedCopyAbsPath = SVNFileUtil.createUniqueFile(dirPath, fileName, ".edited", false);
        return SVNWCContext.wqBuildFileCopyTranslated((SVNWCDb)db, localAbsPath, sourceAbsPath, editedCopyAbsPath);
    }

    private boolean resolveTreeConflictOnNode(File localAbsPath, SVNConflictChoice conflictChoice) throws SVNException {
        SVNErrorMessage errorMessage;
        boolean didResolve = false;
        SVNSkel conflicts = this.getDb().readConflict(localAbsPath);
        if (conflicts == null) {
            return didResolve;
        }
        Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflicts);
        boolean treeConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.treeConflicted);
        SVNOperation operation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
        if (!treeConflicted) {
            return didResolve;
        }
        Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this.getDb(), localAbsPath, conflicts);
        SVNConflictReason reason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
        SVNConflictAction action = (SVNConflictAction)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.incomingChange);
        File srcOpRootAbsPath = (File)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.moveSrcOpRootAbsPath);
        if (operation == SVNOperation.UPDATE || operation == SVNOperation.SWITCH) {
            if (reason == SVNConflictReason.DELETED || reason == SVNConflictReason.REPLACED) {
                if (conflictChoice == SVNConflictChoice.MERGED) {
                    if (action != SVNConflictAction.DELETE) {
                        this.getDb().resolveBreakMovedAway(localAbsPath, srcOpRootAbsPath, true, this.getEventHandler());
                        didResolve = true;
                        return didResolve;
                    }
                    didResolve = true;
                } else if (conflictChoice == SVNConflictChoice.MINE_CONFLICT) {
                    this.getDb().resolveDeleteRaiseMovedAway(localAbsPath, this.getEventHandler());
                } else {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Tree conflict can only be resolved to 'working' or 'mine-conflict' state; '{0}' not resolved", (Object)localAbsPath);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
            } else if (reason == SVNConflictReason.MOVED_AWAY && action == SVNConflictAction.EDIT) {
                if (conflictChoice == SVNConflictChoice.MINE_CONFLICT) {
                    this.getDb().updateMovedAwayConflictVictim(localAbsPath, this.getEventHandler());
                    didResolve = true;
                } else if (conflictChoice == SVNConflictChoice.MERGED) {
                    this.getDb().resolveBreakMovedAway(localAbsPath, srcOpRootAbsPath, true, this.getEventHandler());
                    didResolve = true;
                } else {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Tree conflict can only be resolved to 'working' or 'mine-conflict' state; '{0}' not resolved", (Object)localAbsPath);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
            }
        }
        if (!didResolve && conflictChoice != SVNConflictChoice.MERGED) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Tree conflict can only be resolved to 'working' state; '{0}' not resolved", (Object)localAbsPath);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        this.getDb().opMarkResolved(localAbsPath, false, false, true, null);
        this.wqRun(localAbsPath);
        return didResolve;
    }

    private boolean resolveTextConflictOnNode(File localAbsPath, SVNConflictChoice conflictChoice, File mergedFile) throws SVNException {
        SVNSkel workItem;
        SVNSkel workItems = null;
        boolean didResolve = false;
        SVNSkel conflicts = this.getDb().readConflict(localAbsPath);
        if (conflicts == null) {
            return didResolve;
        }
        Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflicts);
        SVNOperation operation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
        boolean textConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.textConflicted);
        if (!textConflicted) {
            return didResolve;
        }
        Structure<SvnWcDbConflicts.TextConflictInfo> textConflictInfoStructure = SvnWcDbConflicts.readTextConflict(this.getDb(), localAbsPath, conflicts);
        File conflictWorkingAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.mineAbsPath);
        File conflictOldAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.theirOldAbsPath);
        File conflictNewAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.theirAbsPath);
        File autoResolveSrc = null;
        if (conflictChoice == SVNConflictChoice.BASE) {
            autoResolveSrc = conflictOldAbsPath;
        } else if (conflictChoice == SVNConflictChoice.MINE_FULL) {
            autoResolveSrc = conflictWorkingAbsPath;
        } else if (conflictChoice == SVNConflictChoice.THEIRS_FULL) {
            autoResolveSrc = conflictNewAbsPath;
        } else if (conflictChoice == SVNConflictChoice.MERGED) {
            autoResolveSrc = mergedFile;
        } else if (conflictChoice == SVNConflictChoice.THEIRS_CONFLICT || conflictChoice == SVNConflictChoice.MINE_CONFLICT) {
            if (conflictOldAbsPath != null && conflictWorkingAbsPath != null && conflictNewAbsPath != null) {
                File tempDir = this.getDb().getWCRootTempDir(localAbsPath);
                UniqueFileInfo uniqueFileInfo = SVNWCContext.openUniqueFile(tempDir, false);
                autoResolveSrc = uniqueFileInfo.path;
                SVNDiffConflictChoiceStyle style = conflictChoice == SVNConflictChoice.THEIRS_CONFLICT ? SVNDiffConflictChoiceStyle.CHOOSE_LATEST : SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED;
                this.doTextMerge(null, autoResolveSrc, null, conflictWorkingAbsPath, conflictOldAbsPath, conflictNewAbsPath, null, null, null, null, style);
            } else {
                autoResolveSrc = null;
            }
        } else {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Invalid 'conflict_result' argument");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (autoResolveSrc != null) {
            workItem = this.wqBuildFileCopyTranslated(localAbsPath, autoResolveSrc, localAbsPath);
            workItems = SVNWCContext.wqMerge(workItems, workItem);
            workItem = this.wqBuildSyncFileFlags(localAbsPath);
            workItems = SVNWCContext.wqMerge(workItems, workItem);
        }
        RemoveArtifactInfo removeArtifactInfo = this.removeArtifactFileIfExists(localAbsPath, conflictOldAbsPath);
        didResolve = removeArtifactInfo.fileFound;
        workItem = removeArtifactInfo.workItem;
        workItems = SVNWCContext.wqMerge(workItems, workItem);
        removeArtifactInfo = this.removeArtifactFileIfExists(localAbsPath, conflictNewAbsPath);
        didResolve = removeArtifactInfo.fileFound;
        workItem = removeArtifactInfo.workItem;
        workItems = SVNWCContext.wqMerge(workItems, workItem);
        removeArtifactInfo = this.removeArtifactFileIfExists(localAbsPath, conflictWorkingAbsPath);
        didResolve = removeArtifactInfo.fileFound;
        workItem = removeArtifactInfo.workItem;
        workItems = SVNWCContext.wqMerge(workItems, workItem);
        this.getDb().opMarkResolved(localAbsPath, true, false, false, workItems);
        this.wqRun(localAbsPath);
        return didResolve;
    }

    private boolean resolvePropConflictOnNode(File localAbsPath, String conflictedPropName, SVNConflictChoice conflictChoice, File mergedFile) throws SVNException {
        boolean didResolve = false;
        SVNSkel conflicts = this.getDb().readConflict(localAbsPath);
        if (conflicts == null) {
            return didResolve;
        }
        Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflicts);
        SVNOperation operation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
        boolean propConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.propConflicted);
        if (!propConflicted) {
            return didResolve;
        }
        Structure<SvnWcDbConflicts.PropertyConflictInfo> propertyConflictInfoStructure = SvnWcDbConflicts.readPropertyConflict(this.getDb(), localAbsPath, conflicts);
        File propRejectFile = (File)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.markerAbspath);
        SVNProperties mineProps = SVNProperties.wrap((Map)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.mineProps));
        SVNProperties theirOldProps = SVNProperties.wrap((Map)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.theirOldProps));
        SVNProperties theirProps = SVNProperties.wrap((Map)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.theirProps));
        Set conflictedPropNames = (Set)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.conflictedPropNames);
        SVNProperties oldProps = operation == SVNOperation.MERGE ? this.getDb().readPristineProperties(localAbsPath) : theirOldProps;
        SVNProperties resolveFrom = null;
        if (conflictChoice == SVNConflictChoice.BASE) {
            resolveFrom = theirOldProps != null ? theirOldProps : oldProps;
        } else if (conflictChoice == SVNConflictChoice.MINE_FULL || conflictChoice == SVNConflictChoice.MINE_CONFLICT) {
            resolveFrom = mineProps;
        } else if (conflictChoice == SVNConflictChoice.THEIRS_FULL || conflictChoice == SVNConflictChoice.THEIRS_CONFLICT) {
            resolveFrom = theirProps;
        } else if (conflictChoice == SVNConflictChoice.MERGED) {
            if (mergedFile != null && conflictedPropName.length() > 0) {
                SVNProperties actualProps;
                resolveFrom = actualProps = this.getDb().readProperties(localAbsPath);
                Object propValue = SVNFileUtil.readFully(mergedFile);
                resolveFrom.put(conflictedPropName, SVNPropertyValue.create(conflictedPropName, (byte[])propValue));
            } else {
                resolveFrom = null;
            }
        } else {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Invalid 'conflict_result' argument");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (conflictedPropNames != null && conflictedPropNames.size() > 0 && resolveFrom != null) {
            SVNProperties actualProperties = this.getDb().readProperties(localAbsPath);
            for (String propName : conflictedPropNames) {
                SVNPropertyValue newValue = resolveFrom.getSVNPropertyValue(propName);
                actualProperties.put(propName, newValue);
            }
            this.getDb().opSetProps(localAbsPath, actualProperties, null, false, null);
        }
        SVNSkel workItems = null;
        RemoveArtifactInfo artifactInfo = this.removeArtifactFileIfExists(localAbsPath, propRejectFile);
        didResolve = artifactInfo.fileFound;
        SVNSkel workItem = artifactInfo.workItem;
        workItems = SVNWCContext.wqMerge(workItems, workItem);
        this.getDb().opMarkResolved(localAbsPath, false, true, false, workItems);
        this.wqRun(localAbsPath);
        return didResolve;
    }

    private RemoveArtifactInfo removeArtifactFileIfExists(File wriAbsPath, File artifactFileAbsPath) throws SVNException {
        SVNNodeKind nodeKind;
        RemoveArtifactInfo removeArtifactInfo = new RemoveArtifactInfo();
        removeArtifactInfo.workItem = null;
        if (artifactFileAbsPath != null && (nodeKind = SVNFileType.getNodeKind(SVNFileType.getType(artifactFileAbsPath))) == SVNNodeKind.FILE) {
            removeArtifactInfo.workItem = this.wqBuildFileRemove(wriAbsPath, artifactFileAbsPath);
            removeArtifactInfo.fileFound = true;
        }
        return removeArtifactInfo;
    }

    public ISVNWCDb.WCDbBaseInfo getNodeBase(File localAbsPath, boolean ignoreNonExisting, boolean showHidden) throws SVNException {
        SVNException err = null;
        ISVNWCDb.WCDbBaseInfo baseInfo = null;
        try {
            baseInfo = this.getDb().getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid, ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            err = e;
        }
        if (err != null || err == null && !showHidden && baseInfo.status != ISVNWCDb.SVNWCDbStatus.Normal && baseInfo.status != ISVNWCDb.SVNWCDbStatus.Incomplete) {
            if (!ignoreNonExisting) {
                if (err != null) {
                    throw err;
                }
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node '{0}' was not found.", (Object)localAbsPath);
                SVNErrorManager.error(errorMessage, err, SVNLogType.WC);
            }
            if (baseInfo == null) {
                baseInfo = new ISVNWCDb.WCDbBaseInfo();
            }
            baseInfo.kind = ISVNWCDb.SVNWCDbKind.Unknown;
            baseInfo.revision = -1L;
            baseInfo.reposRelPath = null;
            baseInfo.reposRootUrl = null;
            baseInfo.reposUuid = null;
            baseInfo.lock = null;
            return baseInfo;
        }
        assert (SVNRevision.isValidRevisionNumber(baseInfo.revision));
        assert (baseInfo.reposRelPath != null);
        assert (baseInfo.reposRootUrl != null);
        assert (baseInfo.reposUuid != null);
        return baseInfo;
    }

    public File acquireWriteLockForResolve(File localAbsPath) throws SVNException {
        File obtainedAbsPath = null;
        File requestedAbsPath = localAbsPath;
        boolean locked = false;
        while (!locked) {
            obtainedAbsPath = this.acquireWriteLock(requestedAbsPath, false, true);
            locked = true;
            File requiredAbsPath = this.getDb().requiredLockForResolve(localAbsPath);
            File child = SVNFileUtil.skipAncestor(requiredAbsPath, obtainedAbsPath);
            if (child != null && !"".equals(SVNFileUtil.getFilePath(child))) {
                this.releaseWriteLock(obtainedAbsPath);
                locked = false;
                requestedAbsPath = requiredAbsPath;
                continue;
            }
            assert (!requiredAbsPath.equals(obtainedAbsPath) || SVNFileUtil.skipAncestor(obtainedAbsPath, requiredAbsPath) != null);
        }
        return obtainedAbsPath;
    }

    public NodePresence getNodePresence(File localAbsPath, boolean baseOnly) throws SVNException {
        ISVNWCDb.SVNWCDbStatus status;
        if (baseOnly) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.getDb().getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status);
            status = baseInfo.status;
        } else {
            Structure<StructureFields.NodeInfo> nodeInfoStructure = this.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status);
            status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
        }
        NodePresence nodePresence = new NodePresence();
        nodePresence.isNotPresent = status == ISVNWCDb.SVNWCDbStatus.NotPresent;
        nodePresence.isExcluded = status == ISVNWCDb.SVNWCDbStatus.Excluded;
        nodePresence.isServerExcluded = status == ISVNWCDb.SVNWCDbStatus.ServerExcluded;
        return nodePresence;
    }

    public List<CommittableExternalInfo> committableExternalsBelow(List<CommittableExternalInfo> externals, File localAbsPath, SVNDepth depth) throws SVNException {
        List<CommittableExternalInfo> origExternals = this.getDb().committableExternalsBelow(localAbsPath, depth != SVNDepth.INFINITY);
        if (origExternals == null) {
            return null;
        }
        for (CommittableExternalInfo xInfo : origExternals) {
            boolean isRolledOut;
            if (depth == SVNDepth.FILES && xInfo.kind == SVNNodeKind.DIR || !(isRolledOut = this.isExternalRolledOut(xInfo))) continue;
            if (externals == null) {
                externals = new ArrayList<CommittableExternalInfo>();
            }
            externals.add(xInfo);
            if (depth != SVNDepth.INFINITY) continue;
            this.committableExternalsBelow(externals, xInfo.localAbsPath, SVNDepth.INFINITY);
        }
        return externals;
    }

    private boolean isExternalRolledOut(CommittableExternalInfo xInfo) {
        File reposRelPath;
        SVNURL reposRootUrl;
        block2: {
            reposRootUrl = null;
            reposRelPath = null;
            try {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.getDb().getBaseInfo(xInfo.localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl);
                reposRootUrl = baseInfo.reposRootUrl;
                reposRelPath = baseInfo.reposRelPath;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) break block2;
                return false;
            }
        }
        return xInfo.reposRootUrl.equals(reposRootUrl) && xInfo.reposRelPath.equals(reposRelPath);
    }

    public NodeMovedHere nodeWasMovedHere(File localAbsPath) throws SVNException {
        NodeMovedHere nodeMovedHere;
        block2: {
            nodeMovedHere = new NodeMovedHere();
            try {
                ISVNWCDb.Moved moved = this.getDb().scanMoved(localAbsPath);
                nodeMovedHere.deleteOpRootAbsPath = moved.movedFromDeleteAbsPath;
                nodeMovedHere.movedFromAbsPath = moved.movedFromAbsPath;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_UNEXPECTED_STATUS) break block2;
                throw e;
            }
        }
        return nodeMovedHere;
    }

    public NodeMovedAway nodeWasMovedAway(File localAbsPath) throws SVNException {
        NodeMovedAway nodeMovedAway = new NodeMovedAway();
        boolean isDeleted = this.isNodeStatusDeleted(localAbsPath);
        if (isDeleted) {
            ISVNWCDb.WCDbDeletionInfo deletionInfo = this.getDb().scanDeletion(localAbsPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.movedToAbsPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.movedToOpRootAbsPath);
            nodeMovedAway.movedToAbsPath = deletionInfo.movedToAbsPath;
            nodeMovedAway.opRootAbsPath = deletionInfo.movedToOpRootAbsPath;
        }
        return nodeMovedAway;
    }

    public File getNodeDeletedAncestor(File localAbsPath) throws SVNException {
        Structure<StructureFields.NodeInfo> nodeInfoStructure = this.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
        if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            ISVNWCDb.WCDbDeletionInfo deletionInfo = this.getDb().scanDeletion(localAbsPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath);
            return deletionInfo.baseDelAbsPath;
        }
        return null;
    }

    public ObstructionData checkForObstructions(File localAbsPath, boolean noWcRootCheck) throws SVNException {
        boolean isRoot;
        ISVNWCDb.SVNWCDbKind kind;
        ISVNWCDb.SVNWCDbStatus status;
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        ObstructionData obstructionData = new ObstructionData();
        obstructionData.obstructionState = SVNStatusType.INAPPLICABLE;
        obstructionData.deleted = false;
        obstructionData.excluded = false;
        obstructionData.parentDepth = SVNDepth.UNKNOWN;
        obstructionData.kind = SVNNodeKind.NONE;
        SVNNodeKind diskKind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath));
        try {
            Structure<StructureFields.NodeInfo> nodeInfoStructure = this.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
            status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
            kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                ISVNWCDb.SVNWCDbKind kind2;
                ISVNWCDb.SVNWCDbStatus status2;
                if (diskKind != SVNNodeKind.NONE) {
                    obstructionData.obstructionState = SVNStatusType.OBSTRUCTED;
                    return obstructionData;
                }
                try {
                    Structure<StructureFields.NodeInfo> nodeInfoStructure = this.getDb().readInfo(SVNFileUtil.getFileDir(localAbsPath), StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.depth);
                    status2 = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
                    kind2 = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
                    obstructionData.parentDepth = (SVNDepth)nodeInfoStructure.get(StructureFields.NodeInfo.depth);
                }
                catch (SVNException e1) {
                    if (e1.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        obstructionData.obstructionState = SVNStatusType.OBSTRUCTED;
                        return obstructionData;
                    }
                    throw e1;
                }
                if (kind2 != ISVNWCDb.SVNWCDbKind.Dir || status2 != ISVNWCDb.SVNWCDbStatus.Normal && status2 != ISVNWCDb.SVNWCDbStatus.Added) {
                    obstructionData.obstructionState = SVNStatusType.OBSTRUCTED;
                }
                return obstructionData;
            }
            throw e;
        }
        if (!noWcRootCheck && kind == ISVNWCDb.SVNWCDbKind.Dir && status == ISVNWCDb.SVNWCDbStatus.Normal && (isRoot = this.getDb().isWCRoot(localAbsPath))) {
            obstructionData.obstructionState = SVNStatusType.OBSTRUCTED;
            return obstructionData;
        }
        obstructionData.kind = this.convertDbKindToNodeKind(kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, status, false);
        switch (status) {
            case Deleted: {
                obstructionData.deleted = true;
                break;
            }
            case NotPresent: {
                if (diskKind == SVNNodeKind.NONE) break;
                obstructionData.obstructionState = SVNStatusType.OBSTRUCTED;
                break;
            }
            case ServerExcluded: 
            case Excluded: {
                obstructionData.excluded = true;
                break;
            }
            case Incomplete: {
                obstructionData.obstructionState = SVNStatusType.MISSING;
                break;
            }
            case Normal: 
            case Added: {
                if (diskKind == SVNNodeKind.NONE) {
                    obstructionData.obstructionState = SVNStatusType.MISSING;
                    break;
                }
                if (diskKind == this.convertDbKindToNodeKind(kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, status, false)) break;
                obstructionData.obstructionState = SVNStatusType.OBSTRUCTED;
                break;
            }
            default: {
                SVNErrorManager.assertionFailure(false, null, SVNLogType.WC);
            }
        }
        return obstructionData;
    }

    private SVNNodeKind convertDbKindToNodeKind(SVNNodeKind dbKind, ISVNWCDb.SVNWCDbStatus dbStatus, boolean showHidden) {
        if (!showHidden) {
            switch (dbStatus) {
                case NotPresent: 
                case ServerExcluded: 
                case Excluded: {
                    return SVNNodeKind.NONE;
                }
            }
            return dbKind;
        }
        return dbKind;
    }

    public void deleteTreeConflict(File victimAbsPath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(victimAbsPath));
        this.getDb().opMarkResolved(victimAbsPath, false, false, true, null);
    }

    public void addTreeConflict(SVNWCConflictDescription17 conflict) throws SVNException {
        block12: {
            assert (conflict != null);
            assert (conflict.getOperation() == SVNOperation.MERGE || conflict.getReason() != SVNConflictReason.MOVED_AWAY && conflict.getReason() != SVNConflictReason.MOVED_HERE);
            try {
                ConflictInfo conflictInfo = this.getConflicted(conflict.getLocalAbspath(), false, false, true);
                SVNTreeConflictDescription existingConflict = conflictInfo.treeConflict;
                if (existingConflict != null) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Attempt to add tree conflict that already exists at ''{0}''", (Object)conflict.getLocalAbspath());
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                } else if (conflict == null) {
                    return;
                }
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block12;
                throw e;
            }
        }
        SVNSkel conflictSkel = SvnWcDbConflicts.createConflictSkel();
        SvnWcDbConflicts.addTreeConflict(conflictSkel, this.getDb(), conflict.getLocalAbspath(), conflict.getReason(), conflict.getAction(), null);
        if (conflict.getOperation() == SVNOperation.UPDATE) {
            SvnWcDbConflicts.conflictSkelOpUpdate(conflictSkel, conflict.getSrcLeftVersion(), conflict.getSrcRightVersion());
        } else if (conflict.getOperation() == SVNOperation.SWITCH) {
            SvnWcDbConflicts.conflictSkelOpSwitch(conflictSkel, conflict.getSrcLeftVersion(), conflict.getSrcRightVersion());
        } else if (conflict.getOperation() == SVNOperation.MERGE) {
            SvnWcDbConflicts.conflictSkelOpMerge(conflictSkel, conflict.getSrcLeftVersion(), conflict.getSrcRightVersion());
        }
        this.getDb().opMarkConflict(conflict.getLocalAbspath(), conflictSkel, null);
    }

    static {
        STATUS_ORDERING.add(SVNStatusType.UNKNOWN);
        STATUS_ORDERING.add(SVNStatusType.UNCHANGED);
        STATUS_ORDERING.add(SVNStatusType.INAPPLICABLE);
        STATUS_ORDERING.add(SVNStatusType.CHANGED);
        STATUS_ORDERING.add(SVNStatusType.MERGED);
        STATUS_ORDERING.add(SVNStatusType.OBSTRUCTED);
        STATUS_ORDERING.add(SVNStatusType.CONFLICTED);
        CONFLICT_START = "<<<<<<< (modified)".getBytes();
        CONFLICT_END = ">>>>>>> (latest)".getBytes();
        CONFLICT_SEPARATOR = "=======".getBytes();
    }

    public static class NodeMovedAway {
        public File movedToAbsPath;
        public File opRootAbsPath;
        public NodeMovedAway next;
    }

    public static class NodeMovedHere {
        public File movedFromAbsPath;
        public File deleteOpRootAbsPath;
    }

    public static class CommittableExternalInfo {
        public File localAbsPath;
        public File reposRelPath;
        public SVNURL reposRootUrl;
        public SVNNodeKind kind;
    }

    public static class NodePresence {
        public boolean isNotPresent;
        public boolean isExcluded;
        public boolean isServerExcluded;
    }

    private static class RemoveArtifactInfo {
        public SVNSkel workItem;
        public boolean fileFound;

        private RemoveArtifactInfo() {
        }
    }

    private class ConflictStatusWalker
    implements ISvnObjectReceiver<SvnStatus> {
        public boolean resolveText;
        public String resolveProp;
        public boolean resolveTree;
        public SVNConflictChoice conflictChoice;
        public ISVNConflictHandler conflictHandler;
        public ISVNCanceller canceller;
        public ISVNEventHandler eventHandler;

        private ConflictStatusWalker() {
        }

        @Override
        public void receive(SvnTarget target, SvnStatus status) throws SVNException {
            boolean resolved = false;
            if (!status.isConflicted()) {
                return;
            }
            File localAbsPath = target.getFile();
            List<SVNConflictDescription> conflictDescriptions = SVNWCContext.this.getDb().readConflicts(localAbsPath);
            for (SVNConflictDescription conflictDescription : conflictDescriptions) {
                boolean didResolve;
                SVNConflictChoice myChoice = this.conflictChoice;
                File mergeFile = null;
                if (myChoice == null) {
                    SVNConflictResult result;
                    if (this.conflictHandler == null) {
                        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "No conflict-callback and no pre-defined conflict-choice provided");
                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                    }
                    if ((result = this.conflictHandler.handleConflict(conflictDescription)) == null) {
                        result = new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                    }
                    myChoice = result.getConflictChoice();
                    mergeFile = result.getMergedFile();
                }
                if (myChoice == SVNConflictChoice.POSTPONE) continue;
                if (conflictDescription.isTreeConflict()) {
                    if (!this.resolveTree) break;
                    didResolve = SVNWCContext.this.resolveTreeConflictOnNode(localAbsPath, myChoice);
                    resolved = true;
                    continue;
                }
                if (conflictDescription.isTextConflict()) {
                    if (!this.resolveText) break;
                    didResolve = SVNWCContext.this.resolveTextConflictOnNode(localAbsPath, myChoice, mergeFile);
                    if (!didResolve) continue;
                    resolved = true;
                    continue;
                }
                if (!conflictDescription.isPropertyConflict() || this.resolveProp == null || this.resolveProp.length() != 0 && !this.resolveProp.equals(conflictDescription.getPropertyName())) break;
                didResolve = SVNWCContext.this.resolvePropConflictOnNode(localAbsPath, conflictDescription.getPropertyName(), myChoice, mergeFile);
                if (!didResolve) continue;
                resolved = true;
            }
            if (SVNWCContext.this.getEventHandler() != null && resolved) {
                SVNWCContext.this.getEventHandler().handleEvent(new SVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, null, SVNEventAction.RESOLVED, SVNEventAction.RESOLVED, null, null, null, null, null), -1.0);
            }
        }
    }

    private static class TextConflictResolutionInfo {
        public SVNSkel workItems;
        public boolean resolved;

        private TextConflictResolutionInfo() {
        }
    }

    public static class ConflictInfo {
        public boolean textConflicted;
        public boolean propConflicted;
        public boolean treeConflicted;
        public File baseFile;
        public File repositoryFile;
        public File localFile;
        public File propRejectFile;
        public SVNTreeConflictDescription treeConflict;
        public boolean ignored;
    }

    public static class PropDiffs {
        public SVNProperties propChanges;
        public SVNProperties originalProps;
    }

    public static class RunPostUpgrade
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            block2: {
                try {
                    SvnOldUpgrade.wipePostUpgrade(ctx, wcRootAbspath, false);
                }
                catch (SVNException ex) {
                    if (ex.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) break block2;
                    throw ex;
                }
            }
            File adminPath = SVNFileUtil.createFilePath(wcRootAbspath, SVNFileUtil.getAdminDirectoryName());
            File entriesPath = SVNFileUtil.createFilePath(adminPath, SVNWCContext.WC_ADM_ENTRIES);
            File formatPath = SVNFileUtil.createFilePath(adminPath, SVNWCContext.WC_ADM_FORMAT);
            File tempFile = SVNFileUtil.createUniqueFile(adminPath, "svn-XXXXXX", ".tmp", false);
            SVNFileUtil.writeToFile(tempFile, SVNWCContext.WC_NON_ENTRIES_STRING, "US-ASCII");
            SVNFileUtil.rename(tempFile, formatPath);
            tempFile = SVNFileUtil.createUniqueFile(adminPath, "svn-XXXXXX", ".tmp", false);
            SVNFileUtil.writeToFile(tempFile, SVNWCContext.WC_NON_ENTRIES_STRING, "US-ASCII");
            SVNFileUtil.rename(tempFile, entriesPath);
        }
    }

    public static class RunSetPropertyConflictMarkerTemp
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            String prejBasename = workItem.getListSize() > 2 ? workItem.getChild(2).getValue() : null;
            File prejAbspath = SVNFileUtil.createFilePath(wcRootAbspath, prejBasename);
            SVNSkel conflicts = ctx.getDb().readConflict(localAbspath);
            if (conflicts == null) {
                conflicts = SvnWcDbConflicts.createConflictSkel();
                SvnWcDbConflicts.conflictSkelOpUpdate(conflicts, null, null);
            }
            HashSet<String> propNames = new HashSet<String>();
            SvnWcDbConflicts.addPropConflict(conflicts, ctx.getDb(), localAbspath, prejAbspath, null, null, null, propNames);
            ctx.getDb().opMarkConflict(localAbspath, conflicts, null);
        }
    }

    public static class RunSetTextConflictMarkersTemp
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            SVNSkel conflicts;
            String value;
            File wrkBasename;
            String value2;
            File newBasename;
            String value3;
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            int listSize = workItem.getListSize();
            File oldBaseAbsPath = null;
            File newBaseAbsPath = null;
            File wrkBaseAbsPath = null;
            File oldBasename = listSize > 2 ? ((value3 = workItem.getChild(2).getValue()) == null || value3.length() == 0 ? null : SVNFileUtil.createFilePath(value3)) : null;
            if (oldBasename != null) {
                oldBaseAbsPath = SVNFileUtil.createFilePath(wcRootAbspath, oldBasename);
            }
            if ((newBasename = listSize > 3 ? ((value2 = workItem.getChild(3).getValue()) == null || value2.length() == 0 ? null : SVNFileUtil.createFilePath(value2)) : null) != null) {
                newBaseAbsPath = SVNFileUtil.createFilePath(wcRootAbspath, newBasename);
            }
            if ((wrkBasename = listSize > 4 ? ((value = workItem.getChild(4).getValue()) == null || value.length() == 0 ? null : SVNFileUtil.createFilePath(value)) : null) != null) {
                wrkBaseAbsPath = SVNFileUtil.createFilePath(wcRootAbspath, wrkBasename);
            }
            if ((conflicts = ctx.getDb().readConflict(localAbspath)) == null) {
                conflicts = SvnWcDbConflicts.createConflictSkel();
                SvnWcDbConflicts.conflictSkelOpUpdate(conflicts, null, null);
            }
            SvnWcDbConflicts.addTextConflict(conflicts, ctx.getDb(), localAbspath, wrkBaseAbsPath, oldBaseAbsPath, newBaseAbsPath);
            ctx.getDb().opMarkConflict(localAbspath, conflicts, null);
        }
    }

    public static class RunRecordFileInfo
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws NumberFormatException, SVNException {
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            SVNDate setTime = null;
            if (workItem.getListSize() > 2) {
                long val = Long.parseLong(workItem.getChild(2).getValue());
                setTime = SVNWCUtils.readDate(val);
            }
            if (setTime != null && SVNFileType.getType(localAbspath).isFile()) {
                SVNFileUtil.setFileLastModifiedMicros(localAbspath, setTime.getTimeInMicros());
            }
            ctx.getAndRecordFileInfo(localAbspath, true);
        }
    }

    public static class RunDirInstall
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File localRelPath = SVNFileUtil.createFilePath(workItem.first().next().getValue());
            File localAbsPath = SVNFileUtil.createFilePath(wcRootAbspath, localRelPath);
            SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath));
            if (kind != SVNNodeKind.NONE && kind != SVNNodeKind.DIR) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a directory", (Object)localAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            } else if (kind == SVNNodeKind.NONE) {
                SVNFileUtil.ensureDirectoryExists(localAbsPath);
            } else {
                SVNErrorManager.assertionFailure(kind == SVNNodeKind.DIR, null, SVNLogType.WC);
            }
        }
    }

    public static class RunDirRemove
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            block5: {
                SVNSkel arg1 = workItem.first().next();
                File localRelpath = SVNFileUtil.createFilePath(arg1.getValue());
                File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, localRelpath);
                boolean recursive = false;
                if (arg1.next() != null) {
                    boolean bl = recursive = !"0".equals(arg1.next().getValue());
                }
                if (recursive) {
                    SVNFileUtil.deleteAll(localAbspath, true);
                } else {
                    try {
                        SVNFileUtil.deleteFile(localAbspath);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY || e.getErrorMessage().getErrorCode() == SVNErrorCode.DIR_NOT_EMPTY) break block5;
                        throw e;
                    }
                }
            }
        }
    }

    public static class RunPrejInstall
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            SVNSkel conflicts = ctx.getDb().readConflict(localAbspath);
            Structure<SvnWcDbConflicts.PropertyConflictInfo> propertyConflictInfo = SvnWcDbConflicts.readPropertyConflict(ctx.getDb(), wcRootAbspath, conflicts);
            File prejfileAbspath = (File)propertyConflictInfo.get(SvnWcDbConflicts.PropertyConflictInfo.markerAbspath);
            SVNSkel conflictSkel = null;
            if (workItem.getListSize() > 2) {
                conflictSkel = workItem.getChild(2);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            File tmpPrejfileAbspath = ctx.createPrejFile(localAbspath, conflictSkel);
            assert (prejfileAbspath != null);
            SVNFileUtil.rename(tmpPrejfileAbspath, prejfileAbspath);
        }
    }

    public static class RunSyncFileFlags
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            ctx.syncFileFlags(localAbspath);
        }
    }

    public static class RunFileTranslate
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            File srcAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(2).getValue());
            File dstAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(3).getValue());
            TranslateInfo tinf = ctx.getTranslateInfo(localAbspath, true, true, true, true);
            SVNTranslator.copyAndTranslate(srcAbspath, dstAbspath, tinf.charset, tinf.eolStyleInfo.eolStr, tinf.keywords, tinf.special, true, true);
        }
    }

    public static class RunFileMove
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File srcRelPath = new File(workItem.getChild(1).getValue());
            File dstRelPath = new File(workItem.getChild(2).getValue());
            File srcAbspath = !SVNFileUtil.isAbsolute(srcRelPath) ? SVNFileUtil.createFilePath(wcRootAbspath, srcRelPath) : srcRelPath;
            File dstAbspath = !SVNFileUtil.isAbsolute(dstRelPath) ? SVNFileUtil.createFilePath(wcRootAbspath, dstRelPath) : dstRelPath;
            SVNFileType srcType = SVNFileType.getType(srcAbspath);
            if (srcType == SVNFileType.DIRECTORY) {
                SVNFileUtil.moveDir(srcAbspath, dstAbspath);
            } else if (srcType == SVNFileType.FILE) {
                SVNFileUtil.moveFile(srcAbspath, dstAbspath);
            } else if (srcType == SVNFileType.SYMLINK) {
                SVNFileUtil.createSymlink(dstAbspath, SVNFileUtil.getSymlinkName(srcAbspath));
            }
        }
    }

    public static class RunFileRemove
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            SVNFileUtil.deleteFile(localAbspath);
        }
    }

    public static class RunFileCommit
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            File tmpFile = ctx.getTranslatedFile(localAbspath, localAbspath, false, false, false, false, true);
            TranslateInfo info = ctx.getTranslateInfo(localAbspath, false, false, false, true);
            boolean sameContents = false;
            boolean overwroteWorkFile = false;
            sameContents = (info == null || !info.special) && !tmpFile.equals(localAbspath) ? ctx.isSameContents(tmpFile, localAbspath) : true;
            if (!sameContents) {
                SVNFileUtil.rename(tmpFile, localAbspath);
                overwroteWorkFile = true;
            } else if (!tmpFile.equals(localAbspath)) {
                SVNFileUtil.deleteFile(tmpFile);
            }
            ctx.syncFileFlags(localAbspath);
            if (overwroteWorkFile) {
                ctx.getAndRecordFileInfo(localAbspath, false);
            } else {
                ctx.isTextModified(localAbspath, false);
            }
        }
    }

    public static class RunFileInstall
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            SVNDate changedDate;
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            boolean useCommitTimes = "1".equals(workItem.getChild(2).getValue());
            boolean recordFileInfo = "1".equals(workItem.getChild(3).getValue());
            ISVNWCDb.NodeInstallInfo nodeInstallInfo = ctx.getDb().readNodeInstallInfo(localAbspath, wcRootAbspath);
            File sourceAbsPath = null;
            if (workItem.getListSize() >= 5) {
                File localRelPath = SVNFileUtil.createFilePath(workItem.getChild(4).getValue());
                sourceAbsPath = ctx.getDb().fromRelPath(wcRootAbspath, localRelPath);
            } else if (nodeInstallInfo.checksum == null) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Can't install '{0}' from pristine store, because no checksum is recorded for this file", (Object)localAbspath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            } else {
                sourceAbsPath = SvnWcDbPristines.getPristineFuturePath(nodeInstallInfo.wcRoot, nodeInstallInfo.checksum);
            }
            TranslateInfo tinfo = ctx.getTranslateInfo(localAbspath, true, true, true, true);
            SVNTranslator.translate(sourceAbsPath, localAbspath, tinfo.charset, tinfo.eolStyleInfo.eolStr, tinfo.keywords, tinfo.special, true);
            if (tinfo.special) {
                return;
            }
            Structure<SvnWcDbReader.InstallInfo> installInfo = SvnWcDbReader.readNodeInstallInfo((SVNWCDb)ctx.getDb(), localAbspath, SvnWcDbReader.InstallInfo.changedDate, SvnWcDbReader.InstallInfo.pristineProps);
            SVNProperties props = (SVNProperties)installInfo.get(SvnWcDbReader.InstallInfo.pristineProps);
            if (props != null && (props.containsName("svn:executable") || props.containsName("svn:needs-lock"))) {
                ctx.syncFileFlags(localAbspath);
            }
            if (useCommitTimes && (changedDate = (SVNDate)installInfo.get(SvnWcDbReader.InstallInfo.changedDate)) != null) {
                SVNFileUtil.setFileLastModifiedMicros(localAbspath, changedDate.getTimeInMicros());
            }
            if (recordFileInfo) {
                ctx.getAndRecordFileInfo(localAbspath, false);
            }
        }
    }

    public static class RunBaseRemove
    implements RunWorkQueueOperation {
        @Override
        public void runOperation(SVNWCContext ctx, File wcRootAbspath, SVNSkel workItem) throws SVNException {
            File localAbspath = SVNFileUtil.createFilePath(wcRootAbspath, workItem.getChild(1).getValue());
            long value = -1L;
            try {
                value = Long.parseLong(workItem.getChild(2).getValue());
            }
            catch (NumberFormatException nfe) {
                value = -1L;
            }
            File reposRelPath = null;
            SVNURL reposRootUrl = null;
            String reposUuid = null;
            ISVNWCDb.SVNWCDbKind kind = null;
            long revision = -1L;
            if (workItem.getList().size() >= 4) {
                revision = value;
                kind = ISVNWCDb.SVNWCDbKind.values()[Integer.parseInt(workItem.getChild(3).getValue())];
                if (revision >= 0L) {
                    File dirAbsPath = SVNFileUtil.getParentFile(localAbspath);
                    ISVNWCDb.WCDbRepositoryInfo info = ctx.getDb().scanBaseRepository(dirAbsPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
                    reposRelPath = SVNFileUtil.createFilePath(info.relPath, SVNFileUtil.getFileName(localAbspath));
                    reposRootUrl = info.rootUrl;
                    reposUuid = info.uuid;
                }
            } else {
                boolean keepNotPresent;
                boolean bl = keepNotPresent = value == 1L;
                if (keepNotPresent) {
                    ISVNWCDb.WCDbBaseInfo info = ctx.getDb().getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid);
                    reposRelPath = info.reposRelPath;
                    reposRootUrl = info.reposRootUrl;
                    reposUuid = info.reposUuid;
                    revision = info.revision;
                    kind = info.kind;
                }
            }
            ctx.removeBaseNode(localAbspath);
            if (revision >= 0L) {
                ctx.getDb().addBaseNotPresentNode(localAbspath, reposRelPath, reposRootUrl, reposUuid, revision, kind, null, null);
            }
        }
    }

    public static class PresevePreMergeFileInfo {
        public SVNSkel workItems;
        public File leftCopy;
        public File rightCopy;
        public File targetCopy;
    }

    public static class ConflictMarkersInfo {
        public String rightMarker;
        public String leftMarker;
        public String targetMarker;
    }

    public static class UniqueFileInfo {
        public File path;
        public OutputStream stream;
    }

    public static class MergePropertiesInfo {
        public SVNSkel conflictSkel;
        public SVNSkel workItems;
        public SVNStatusType mergeOutcome;
        public SVNProperties newBaseProperties;
        public SVNProperties newActualProperties;
        public boolean treeConflicted;
    }

    public static class MergeInfo {
        public SVNSkel workItems;
        public SVNSkel conflictSkel;
        public SVNStatusType mergeOutcome;
        public boolean foundTextConflict;
    }

    public static class WritableBaseInfo {
        public OutputStream stream;
        public File tempBaseAbspath;
        public SVNChecksumOutputStream md5ChecksumStream;
        public SVNChecksumOutputStream sha1ChecksumStream;

        public SvnChecksum getMD5Checksum() {
            return this.md5ChecksumStream == null ? null : new SvnChecksum(SvnChecksum.Kind.md5, this.md5ChecksumStream.getDigest());
        }

        public SvnChecksum getSHA1Checksum() {
            return this.sha1ChecksumStream == null ? null : new SvnChecksum(SvnChecksum.Kind.sha1, this.sha1ChecksumStream.getDigest());
        }
    }

    static class MergePropStatusInfo {
        public SVNStatusType state;
        public boolean conflictRemains;
        public SVNPropertyValue resultVal;
        public boolean didMerge;

        public MergePropStatusInfo() {
        }

        public MergePropStatusInfo(SVNStatusType state, boolean conflictRemains) {
            this.state = state;
            this.conflictRemains = conflictRemains;
        }
    }

    public class SVNWCNodeReposInfo {
        public SVNURL reposRootUrl;
        public String reposUuid;
        public File reposRelPath;
        public long revision;
    }

    public static class CheckSpecialInfo {
        public SVNNodeKind kind;
        public boolean isSpecial;
    }

    public static class CheckWCRootInfo {
        public boolean wcRoot;
        public ISVNWCDb.SVNWCDbKind kind;
        public boolean switched;
    }

    public static interface ISVNWCNodeHandler {
        public void nodeFound(File var1, ISVNWCDb.SVNWCDbKind var2) throws SVNException;
    }

    public static class NodeCopyFromInfo {
        public SVNURL rootUrl = null;
        public File reposRelPath = null;
        public SVNURL url = null;
        public long rev = -1L;
        public boolean isCopyTarget = false;
    }

    public static enum NodeCopyFromField {
        rootUrl,
        reposRelPath,
        url,
        rev,
        isCopyTarget;

    }

    public static class EntryLocationInfo {
        public SVNURL url;
        public long revNum;
    }

    public static class TranslateInfo {
        public SVNEolStyleInfo eolStyleInfo;
        public String charset;
        public Map<String, byte[]> keywords;
        public boolean special;
    }

    public static class PristineContentsInfo {
        public InputStream stream;
        public File path;
    }

    public class ScheduleInternalInfo {
        public SVNWCSchedule schedule;
        public boolean copied;
    }

    public static class ObstructionData {
        public SVNStatusType obstructionState;
        public boolean deleted;
        public boolean excluded;
        public SVNNodeKind kind;
        public SVNDepth parentDepth;
    }

    public static enum SVNWCSchedule {
        normal,
        add,
        delete,
        replace;

    }

    public static enum WorkQueueOperation {
        BASE_REMOVE("base-remove", new RunBaseRemove()),
        FILE_INSTALL("file-install", new RunFileInstall()),
        FILE_COMMIT("file-commit", new RunFileCommit()),
        FILE_REMOVE("file-remove", new RunFileRemove()),
        FILE_MOVE("file-move", new RunFileMove()),
        FILE_COPY_TRANSLATED("file-translate", new RunFileTranslate()),
        SYNC_FILE_FLAGS("sync-file-flags", new RunSyncFileFlags()),
        PREJ_INSTALL("prej-install", new RunPrejInstall()),
        DIRECTORY_REMOVE("dir-remove", new RunDirRemove()),
        DIRECTORY_INSTALL("dir-install", new RunDirInstall()),
        RECORD_FILEINFO("record-fileinfo", new RunRecordFileInfo()),
        TMP_SET_TEXT_CONFLICT_MARKERS("tmp-set-text-conflict-markers", new RunSetTextConflictMarkersTemp()),
        TMP_SET_PROPERTY_CONFLICT_MARKER("tmp-set-property-conflict-marker", new RunSetPropertyConflictMarkerTemp()),
        POSTUPGRADE("postupgrade", new RunPostUpgrade());

        private final String opName;
        private final RunWorkQueueOperation operation;

        private WorkQueueOperation(String opName, RunWorkQueueOperation operation) {
            this.opName = opName;
            this.operation = operation;
        }

        public String getOpName() {
            return this.opName;
        }

        public RunWorkQueueOperation getOperation() {
            return this.operation;
        }
    }

    public static interface RunWorkQueueOperation {
        public void runOperation(SVNWCContext var1, File var2, SVNSkel var3) throws SVNException;
    }

    public static enum SVNEolStyle {
        Unknown,
        None,
        Native,
        Fixed;

    }

    public static class SVNEolStyleInfo {
        public static final byte[] NATIVE_EOL_STR = System.getProperty("line.separator").getBytes();
        public static final byte[] LF_EOL_STR = new byte[]{10};
        public static final byte[] CR_EOL_STR = new byte[]{13};
        public static final byte[] CRLF_EOL_STR = new byte[]{13, 10};
        public SVNEolStyle eolStyle;
        public byte[] eolStr;

        public SVNEolStyleInfo(SVNEolStyle style, byte[] str) {
            this.eolStyle = style;
            this.eolStr = str;
        }

        public static SVNEolStyleInfo fromValue(String value) {
            if (value == null) {
                return new SVNEolStyleInfo(SVNEolStyle.None, null);
            }
            if ("native".equals(value)) {
                return new SVNEolStyleInfo(SVNEolStyle.Native, NATIVE_EOL_STR);
            }
            if ("LF".equals(value)) {
                return new SVNEolStyleInfo(SVNEolStyle.Fixed, LF_EOL_STR);
            }
            if ("CR".equals(value)) {
                return new SVNEolStyleInfo(SVNEolStyle.Fixed, CR_EOL_STR);
            }
            if ("CRLF".equals(value)) {
                return new SVNEolStyleInfo(SVNEolStyle.Fixed, CRLF_EOL_STR);
            }
            return new SVNEolStyleInfo(SVNEolStyle.Unknown, null);
        }
    }

    public static interface CleanupHandler {
        public void cleanup() throws SVNException;
    }

    protected static class TreeLocalModsInfo {
        public boolean modificationsFound;
        public boolean nonDeleteModificationsFound;

        protected TreeLocalModsInfo() {
        }
    }
}

