/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.tmatesoft.svn.core.internal.util.ISVNTask;
import org.tmatesoft.svn.core.internal.util.ISVNThreadPool;
import org.tmatesoft.svn.core.internal.util.SVNEmptyThreadPool;
import org.tmatesoft.svn.core.internal.util.SVNTask;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNThreadPool
implements ISVNThreadPool {
    private ThreadPoolExecutor myThreadPool;
    private CustomThreadFactory myThreadFactory;
    private ISVNThreadPool myFailSafePool;

    @Override
    public ISVNTask run(Runnable task, boolean daemon) {
        ThreadPoolExecutor threadPool = this.getThreadPool(daemon);
        try {
            Future<?> future = threadPool.submit(task);
            return new SVNTask(future);
        }
        catch (RejectedExecutionException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Could not submit task: " + e.getMessage());
            ISVNThreadPool failSafePool = this.getFailSafePool();
            return failSafePool.run(task, daemon);
        }
    }

    private synchronized ISVNThreadPool getFailSafePool() {
        if (this.myFailSafePool == null) {
            this.myFailSafePool = new SVNEmptyThreadPool();
        }
        return this.myFailSafePool;
    }

    private synchronized ThreadPoolExecutor getThreadPool(boolean daemon) {
        CustomThreadFactory threadFactory2 = this.getThreadFactory(daemon);
        if (this.myThreadPool == null) {
            this.myThreadPool = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory2);
        }
        return this.myThreadPool;
    }

    private synchronized CustomThreadFactory getThreadFactory(boolean daemon) {
        if (this.myThreadFactory == null) {
            this.myThreadFactory = new CustomThreadFactory(daemon);
        } else {
            this.myThreadFactory.setIsDaemon(daemon);
        }
        return this.myThreadFactory;
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger ourPoolNumber = new AtomicInteger(1);
        private final ThreadGroup myGroup;
        private final AtomicInteger myThreadNumber = new AtomicInteger(1);
        private final String myNamePrefix;
        private boolean myIsDaemon;

        CustomThreadFactory(boolean daemon) {
            SecurityManager s = System.getSecurityManager();
            this.myGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.myNamePrefix = "pool-" + ourPoolNumber.getAndIncrement() + "-svnkit-thread-";
            this.myIsDaemon = daemon;
        }

        public void setIsDaemon(boolean isDaemon) {
            this.myIsDaemon = isDaemon;
        }

        @Override
        public Thread newThread(Runnable task) {
            Thread thread2 = new Thread(this.myGroup, task, this.myNamePrefix + this.myThreadNumber.getAndIncrement(), 0L);
            thread2.setDaemon(this.myIsDaemon);
            if (thread2.getPriority() != 5) {
                thread2.setPriority(5);
            }
            return thread2;
        }
    }
}

