/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.util.List;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.batch.rule.internal.RulesBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.rule.RulesLoader;
import org.sonarqube.ws.Rules;

public class RulesProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(RulesProvider.class);
    private static final String LOG_MSG = "Load server rules";
    private Rules singleton = null;

    public Rules provide(RulesLoader ref) {
        if (this.singleton == null) {
            this.singleton = RulesProvider.load(ref);
        }
        return this.singleton;
    }

    private static Rules load(RulesLoader ref) {
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
        List<Rules.ListResponse.Rule> loadedRules = ref.load();
        RulesBuilder builder = new RulesBuilder();
        for (Rules.ListResponse.Rule r : loadedRules) {
            NewRule newRule = builder.add(RuleKey.of(r.getRepository(), r.getKey()));
            newRule.setName(r.getName());
            newRule.setInternalKey(r.getInternalKey());
        }
        profiler.stopInfo();
        return builder.build();
    }
}

