/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class SourcePublisher
implements ReportPublisherStep {
    private final InputComponentStore componentCache;

    public SourcePublisher(InputComponentStore componentStore) {
        this.componentCache = componentStore;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        for (DefaultInputFile inputFile : this.componentCache.allChangedFilesToPublish()) {
            File iofile = writer.getSourceFile(inputFile.scannerId());
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(iofile));){
                InputStream in = inputFile.inputStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, inputFile.charset()));){
                    SourcePublisher.writeSource(reader, output, inputFile.lines());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to store file source in the report", e);
            }
        }
    }

    private static void writeSource(BufferedReader reader, OutputStream output, int lines) throws IOException {
        int line = 0;
        String lineStr = reader.readLine();
        while (lineStr != null) {
            IOUtils.write(lineStr, output, StandardCharsets.UTF_8);
            if (++line < lines) {
                IOUtils.write("\n", output, StandardCharsets.UTF_8);
            }
            lineStr = reader.readLine();
        }
    }
}

