/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.genericcoverage;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.config.DefaultConfiguration;
import org.sonar.scanner.genericcoverage.GenericCoverageReportParser;

public class GenericCoverageSensor
implements ProjectSensor {
    private static final Logger LOG = Loggers.get(GenericCoverageSensor.class);
    static final String REPORT_PATHS_PROPERTY_KEY = "sonar.coverageReportPaths";
    private final DefaultConfiguration config;

    public GenericCoverageSensor(DefaultConfiguration config) {
        this.config = config;
    }

    public static List<PropertyDefinition> properties() {
        return Collections.singletonList(PropertyDefinition.builder(REPORT_PATHS_PROPERTY_KEY).name("Coverage report paths").description("List of comma-separated paths (absolute or relative) containing coverage report.").category("codeCoverage").onQualifiers("TRK", new String[0]).multiValues(true).build());
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Generic Coverage Report").onlyWhenConfiguration(c -> c.hasKey(REPORT_PATHS_PROPERTY_KEY));
    }

    @Override
    public void execute(SensorContext context) {
        Set<String> reportPaths = this.loadReportPaths();
        for (String reportPath : reportPaths) {
            File reportFile = context.fileSystem().resolvePath(reportPath);
            LOG.info("Parsing {}", (Object)reportFile);
            GenericCoverageReportParser parser = new GenericCoverageReportParser();
            parser.parse(reportFile, context);
            LOG.info("Imported coverage data for {} files", (Object)parser.numberOfMatchedFiles());
            int numberOfUnknownFiles = parser.numberOfUnknownFiles();
            if (numberOfUnknownFiles <= 0) continue;
            LOG.info("Coverage data ignored for " + numberOfUnknownFiles + " unknown files, including:\n" + parser.firstUnknownFiles().stream().collect(Collectors.joining("\n")));
        }
    }

    Set<String> loadReportPaths() {
        return new LinkedHashSet<String>(Arrays.asList(this.config.getStringArray(REPORT_PATHS_PROPERTY_KEY)));
    }
}

