/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.updatecenter.common.PluginManifest;
import org.sonar.updatecenter.common.Version;

public class PluginInfo
implements Comparable<PluginInfo> {
    private static final Logger LOGGER = Loggers.get(PluginInfo.class);
    private static final Joiner SLASH_JOINER = Joiner.on(" / ").skipNulls();
    private final String key;
    private String name;
    @CheckForNull
    private File jarFile;
    @CheckForNull
    private String mainClass;
    @CheckForNull
    private Version version;
    private String displayVersion;
    @CheckForNull
    private Version minimalSqVersion;
    @CheckForNull
    private String description;
    @CheckForNull
    private String organizationName;
    @CheckForNull
    private String organizationUrl;
    @CheckForNull
    private String license;
    @CheckForNull
    private String homepageUrl;
    @CheckForNull
    private String issueTrackerUrl;
    private boolean useChildFirstClassLoader;
    @CheckForNull
    private String basePlugin;
    @CheckForNull
    private String implementationBuild;
    @CheckForNull
    private boolean sonarLintSupported;
    @CheckForNull
    private String documentationPath;
    private final Set<RequiredPlugin> requiredPlugins = new HashSet<RequiredPlugin>();

    public PluginInfo(String key) {
        Objects.requireNonNull(key, "Plugin key is missing from manifest");
        this.key = key;
        this.name = key;
    }

    public PluginInfo setJarFile(@Nullable File f) {
        this.jarFile = f;
        return this;
    }

    @CheckForNull
    public File getJarFile() {
        return this.jarFile;
    }

    public File getNonNullJarFile() {
        Objects.requireNonNull(this.jarFile);
        return this.jarFile;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public Version getVersion() {
        return this.version;
    }

    @CheckForNull
    public String getDisplayVersion() {
        return this.displayVersion;
    }

    public PluginInfo setDisplayVersion(@Nullable String displayVersion) {
        this.displayVersion = displayVersion;
        return this;
    }

    @CheckForNull
    public Version getMinimalSqVersion() {
        return this.minimalSqVersion;
    }

    @CheckForNull
    public String getMainClass() {
        return this.mainClass;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @CheckForNull
    public String getOrganizationName() {
        return this.organizationName;
    }

    @CheckForNull
    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    @CheckForNull
    public String getLicense() {
        return this.license;
    }

    @CheckForNull
    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    @CheckForNull
    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public boolean isUseChildFirstClassLoader() {
        return this.useChildFirstClassLoader;
    }

    public boolean isSonarLintSupported() {
        return this.sonarLintSupported;
    }

    public String getDocumentationPath() {
        return this.documentationPath;
    }

    @CheckForNull
    public String getBasePlugin() {
        return this.basePlugin;
    }

    @CheckForNull
    public String getImplementationBuild() {
        return this.implementationBuild;
    }

    public Set<RequiredPlugin> getRequiredPlugins() {
        return this.requiredPlugins;
    }

    public PluginInfo setName(@Nullable String name) {
        this.name = name != null ? name : this.key;
        return this;
    }

    public PluginInfo setVersion(Version version) {
        this.version = version;
        return this;
    }

    public PluginInfo setMinimalSqVersion(@Nullable Version v) {
        this.minimalSqVersion = v;
        return this;
    }

    public PluginInfo setDocumentationPath(@Nullable String documentationPath) {
        this.documentationPath = documentationPath;
        return this;
    }

    public PluginInfo setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public PluginInfo setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public PluginInfo setOrganizationName(@Nullable String s) {
        this.organizationName = s;
        return this;
    }

    public PluginInfo setOrganizationUrl(@Nullable String s) {
        this.organizationUrl = s;
        return this;
    }

    public PluginInfo setLicense(@Nullable String license) {
        this.license = license;
        return this;
    }

    public PluginInfo setHomepageUrl(@Nullable String s) {
        this.homepageUrl = s;
        return this;
    }

    public PluginInfo setIssueTrackerUrl(@Nullable String s) {
        this.issueTrackerUrl = s;
        return this;
    }

    public PluginInfo setUseChildFirstClassLoader(boolean b) {
        this.useChildFirstClassLoader = b;
        return this;
    }

    public PluginInfo setSonarLintSupported(boolean sonarLintPlugin) {
        this.sonarLintSupported = sonarLintPlugin;
        return this;
    }

    public PluginInfo setBasePlugin(@Nullable String s) {
        if ("l10nen".equals(s)) {
            LOGGER.info("Plugin [{}] defines 'l10nen' as base plugin. This metadata can be removed from manifest of l10n plugins since version 5.2.", (Object)this.key);
            this.basePlugin = null;
        } else {
            this.basePlugin = s;
        }
        return this;
    }

    public PluginInfo setImplementationBuild(@Nullable String implementationBuild) {
        this.implementationBuild = implementationBuild;
        return this;
    }

    public PluginInfo addRequiredPlugin(RequiredPlugin p) {
        this.requiredPlugins.add(p);
        return this;
    }

    public boolean isCompatibleWith(String runtimeVersion) {
        if (null == this.minimalSqVersion) {
            return true;
        }
        Version effectiveMin = Version.create(this.minimalSqVersion.getName()).removeQualifier();
        Version effectiveVersion = Version.create(runtimeVersion).removeQualifier();
        if (runtimeVersion.endsWith("-SNAPSHOT")) {
            effectiveMin = Version.create(effectiveMin.getMajor() + "." + effectiveMin.getMinor());
        }
        return effectiveVersion.compareTo(effectiveMin) >= 0;
    }

    public String toString() {
        return String.format("[%s]", SLASH_JOINER.join(this.key, this.version, this.implementationBuild));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo info = (PluginInfo)o;
        return Objects.equals(this.key, info.key) && Objects.equals(this.version, info.version);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.version);
    }

    @Override
    public int compareTo(PluginInfo that) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.name), (Comparable<?>)((Object)that.name)).compare(this.version, that.version, Ordering.natural().nullsFirst()).result();
    }

    public static PluginInfo create(File jarFile) {
        try {
            PluginManifest manifest = new PluginManifest(jarFile);
            return PluginInfo.create(jarFile, manifest);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to extract plugin metadata from file: " + jarFile, e);
        }
    }

    @VisibleForTesting
    static PluginInfo create(File jarFile, PluginManifest manifest) {
        PluginInfo.validateManifest(jarFile, manifest);
        PluginInfo info = new PluginInfo(manifest.getKey());
        info.fillFields(jarFile, manifest);
        return info;
    }

    private static void validateManifest(File jarFile, PluginManifest manifest) {
        if (StringUtils.isBlank(manifest.getKey())) {
            throw MessageException.of(String.format("File is not a plugin. Please delete it and restart: %s", jarFile.getAbsolutePath()));
        }
    }

    protected void fillFields(File jarFile, PluginManifest manifest) {
        this.setJarFile(jarFile);
        this.setName(manifest.getName());
        this.setMainClass(manifest.getMainClass());
        this.setVersion(Version.create(manifest.getVersion()));
        this.setDocumentationPath(PluginInfo.getDocumentationPath(jarFile));
        this.setDescription(manifest.getDescription());
        this.setLicense(manifest.getLicense());
        this.setOrganizationName(manifest.getOrganization());
        this.setOrganizationUrl(manifest.getOrganizationUrl());
        this.setDisplayVersion(manifest.getDisplayVersion());
        String minSqVersion = manifest.getSonarVersion();
        if (minSqVersion != null) {
            this.setMinimalSqVersion(Version.create(minSqVersion));
        }
        this.setHomepageUrl(manifest.getHomepage());
        this.setIssueTrackerUrl(manifest.getIssueTrackerUrl());
        this.setUseChildFirstClassLoader(manifest.isUseChildFirstClassLoader());
        this.setSonarLintSupported(manifest.isSonarLintSupported());
        this.setBasePlugin(manifest.getBasePlugin());
        this.setImplementationBuild(manifest.getImplementationBuild());
        String[] requiredPluginsFromManifest = manifest.getRequirePlugins();
        if (requiredPluginsFromManifest != null) {
            Arrays.stream(requiredPluginsFromManifest).map(RequiredPlugin::parse).filter(t -> !"license".equals(((RequiredPlugin)t).key)).forEach(this::addRequiredPlugin);
        }
    }

    private static String getDocumentationPath(File file) {
        String string;
        JarFile jarFile = new JarFile(file);
        try {
            string = Optional.ofNullable(jarFile.getEntry("static/documentation.md")).map(ZipEntry::getName).orElse(null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("Could not retrieve documentation path from " + file, e);
                return null;
            }
        }
        jarFile.close();
        return string;
    }

    public static class RequiredPlugin {
        private static final Pattern PARSER = Pattern.compile("\\w+:.+");
        private final String key;
        private final Version minimalVersion;

        public RequiredPlugin(String key, Version minimalVersion) {
            this.key = key;
            this.minimalVersion = minimalVersion;
        }

        public String getKey() {
            return this.key;
        }

        public Version getMinimalVersion() {
            return this.minimalVersion;
        }

        public static RequiredPlugin parse(String s) {
            if (!PARSER.matcher(s).matches()) {
                throw new IllegalArgumentException("Manifest field does not have correct format: " + s);
            }
            String[] fields = StringUtils.split(s, ':');
            return new RequiredPlugin(fields[0], Version.create(fields[1]).removeQualifier());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequiredPlugin that = (RequiredPlugin)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key + ':' + this.minimalVersion.getName();
        }
    }
}

