/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.sonar.classloader.ClassloaderRef;
import org.sonar.classloader.Mask;

class DefaultClassloaderRef
implements ClassloaderRef {
    private final Mask mask;
    private final ClassLoader classloader;

    DefaultClassloaderRef(ClassLoader classloader, Mask mask) {
        this.classloader = classloader;
        this.mask = mask;
    }

    @Override
    public Class loadClassIfPresent(String classname) {
        if (this.mask.acceptClass(classname)) {
            try {
                return this.classloader.loadClass(classname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL loadResourceIfPresent(String name) {
        if (this.mask.acceptResource(name)) {
            return this.classloader.getResource(name);
        }
        return null;
    }

    @Override
    public void loadResources(String name, Collection<URL> appendTo) {
        if (this.mask.acceptResource(name)) {
            try {
                Enumeration<URL> resources = this.classloader.getResources(name);
                while (resources.hasMoreElements()) {
                    appendTo.add(resources.nextElement());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Fail to load resources named '%s'", name), e);
            }
        }
    }
}

