/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.impl.utils;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.sonar.api.utils.Preconditions;
import org.sonar.api.utils.System2;

public class AlwaysIncreasingSystem2
extends System2 {
    private static final SecureRandom rnd = new SecureRandom();
    private final AtomicLong now;
    private final long increment;

    private AlwaysIncreasingSystem2(LongSupplier initialValueSupplier, long increment) {
        Preconditions.checkArgument(increment > 0L, "increment must be > 0");
        long initialValue = initialValueSupplier.getAsLong();
        Preconditions.checkArgument(initialValue >= 0L, "Initial value must be >= 0");
        this.now = new AtomicLong(initialValue);
        this.increment = increment;
    }

    public AlwaysIncreasingSystem2(long increment) {
        this(AlwaysIncreasingSystem2::randomInitialValue, increment);
    }

    public AlwaysIncreasingSystem2(long initialValue, int increment) {
        this(() -> initialValue, (long)increment);
    }

    public AlwaysIncreasingSystem2() {
        this(AlwaysIncreasingSystem2::randomInitialValue, 100L);
    }

    @Override
    public long now() {
        return this.now.getAndAdd(this.increment);
    }

    private static long randomInitialValue() {
        return Math.abs(rnd.nextInt(2000000));
    }
}

