/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.picocontainer.BehaviorFactory;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.InjectionFactory;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.behaviors.HiddenImplementation;
import org.picocontainer.injectors.AdaptingInjection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBehaviorFactory
implements ComponentFactory,
Serializable,
BehaviorFactory {
    private ComponentFactory delegate;

    @Override
    public ComponentFactory wrap(ComponentFactory delegate) {
        this.delegate = delegate;
        return this;
    }

    @Override
    public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        if (this.delegate == null) {
            this.delegate = new AdaptingInjection();
        }
        ComponentAdapter<T> compAdapter = this.delegate.createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
        boolean enableCircular = AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.ENABLE_CIRCULAR);
        if (enableCircular && this.delegate instanceof InjectionFactory) {
            return componentMonitor.newBehavior(new HiddenImplementation<T>(compAdapter));
        }
        return compAdapter;
    }

    @Override
    public void verify(PicoContainer container) {
        this.delegate.verify(container);
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitComponentFactory(this);
        if (this.delegate != null) {
            this.delegate.accept(visitor);
        }
    }

    @Override
    public <T> ComponentAdapter<T> addComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, ComponentAdapter<T> adapter) {
        if (this.delegate != null && this.delegate instanceof BehaviorFactory) {
            return ((BehaviorFactory)this.delegate).addComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, adapter);
        }
        return adapter;
    }

    public static boolean arePropertiesPresent(Properties current, Properties present, boolean compareValueToo) {
        Enumeration<Object> keys2 = present.keys();
        while (keys2.hasMoreElements()) {
            String key = (String)keys2.nextElement();
            String presentValue = present.getProperty(key);
            String currentValue = current.getProperty(key);
            if (currentValue == null) {
                return false;
            }
            if (presentValue.equals(currentValue) || !compareValueToo) continue;
            return false;
        }
        return true;
    }

    public static boolean removePropertiesIfPresent(Properties current, Properties present) {
        if (!AbstractBehaviorFactory.arePropertiesPresent(current, present, true)) {
            return false;
        }
        Enumeration<Object> keys2 = present.keys();
        while (keys2.hasMoreElements()) {
            Object key = keys2.nextElement();
            current.remove(key);
        }
        return true;
    }

    public static String getAndRemovePropertiesIfPresentByKey(Properties current, Properties present) {
        if (!AbstractBehaviorFactory.arePropertiesPresent(current, present, false)) {
            return null;
        }
        Enumeration<Object> keys2 = present.keys();
        String value = null;
        while (keys2.hasMoreElements()) {
            Object key = keys2.nextElement();
            value = (String)current.remove(key);
        }
        return value;
    }

    protected void mergeProperties(Properties into, Properties from) {
        Enumeration<?> e = from.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            into.setProperty(s, from.getProperty(s));
        }
    }
}

