/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Node;

@Rule(key="S6359")
public class AndroidCustomPermissionCheck
extends AbstractAndroidManifestCheck {
    private static final String MESSAGE = "Use a different namespace for the \"%s\" permission.";
    private final XPathExpression xPathExpression = XPathBuilder.forExpression("/manifest/permission/@n1:name").withNamespace("n1", "http://schemas.android.com/apk/res/android").build();

    @Override
    protected final void scanAndroidManifest(XmlFile file) {
        this.evaluateAsList(this.xPathExpression, file.getDocument()).stream().filter(node -> node.getNodeValue().startsWith("android.permission")).forEach(node -> this.reportIssue((Node)node, String.format(MESSAGE, AndroidCustomPermissionCheck.simpleName(node.getNodeValue()))));
    }

    private static String simpleName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
    }
}

