/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import java.util.Collections;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Element;

@Rule(key="S6358")
public class AndroidApplicationBackupCheck
extends AbstractAndroidManifestCheck {
    private static final String MESSAGE = "Make sure backup of application data is safe here.";
    private final XPathExpression xPathApplicationWithBackup = XPathBuilder.forExpression("/manifest/application[ not(@n:allowBackup='false')and not(@n:backupAgent)and not(@n:fullBackupContent and (starts-with(@n:fullBackupContent, '@') or starts-with(@n:fullBackupContent, '$')))]").withNamespace("n", "http://schemas.android.com/apk/res/android").build();

    @Override
    protected void scanAndroidManifest(XmlFile file) {
        this.evaluateAsList(this.xPathApplicationWithBackup, file.getDocument()).forEach(node -> this.reportIssue(XmlFile.nameLocation((Element)node), MESSAGE, Collections.emptyList()));
    }
}

