/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.xml.LineCounter;
import org.sonar.plugins.xml.XmlHighlighting;
import org.sonar.plugins.xml.checks.CheckList;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;

public class XmlSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(XmlSensor.class);
    private static final RuleKey PARSING_ERROR_RULE_KEY = RuleKey.of((String)"xml", (String)"S2260");
    private final Checks<Object> checks;
    private final boolean parsingErrorCheckEnabled;
    private final FileSystem fileSystem;
    private final FilePredicate mainFilesPredicate;
    private final SonarRuntime sonarRuntime;
    private final FileLinesContextFactory fileLinesContextFactory;

    public XmlSensor(SonarRuntime sonarRuntime, FileSystem fileSystem, CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory) {
        this.sonarRuntime = sonarRuntime;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.checks = checkFactory.create("xml").addAnnotatedChecks(CheckList.getCheckClasses());
        this.parsingErrorCheckEnabled = this.checks.of(PARSING_ERROR_RULE_KEY) != null;
        this.fileSystem = fileSystem;
        this.mainFilesPredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SensorContext context) {
        ArrayList inputFiles = new ArrayList();
        this.fileSystem.inputFiles(this.mainFilesPredicate).forEach(inputFiles::add);
        if (inputFiles.isEmpty()) {
            return;
        }
        boolean isSonarLintContext = context.runtime().getProduct() == SonarProduct.SONARLINT;
        ProgressReport progressReport = new ProgressReport("Report about progress of XML Analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start(inputFiles.stream().map(InputFile::toString).collect(Collectors.toList()));
        boolean cancelled = false;
        try {
            for (InputFile inputFile : inputFiles) {
                if (context.isCancelled()) {
                    cancelled = true;
                    break;
                }
                this.scanFile(context, inputFile, isSonarLintContext);
                progressReport.nextFile();
            }
        }
        finally {
            if (!cancelled) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
    }

    private void scanFile(SensorContext context, InputFile inputFile, boolean isSonarLintContext) {
        try {
            XmlFile xmlFile = XmlFile.create(inputFile);
            if (!isSonarLintContext) {
                LineCounter.analyse(context, this.fileLinesContextFactory, xmlFile);
                XmlHighlighting.highlight(context, xmlFile);
            }
            this.runChecks(context, xmlFile);
        }
        catch (Exception e) {
            this.processParseException(e, context, inputFile);
        }
    }

    private void runChecks(SensorContext context, XmlFile newXmlFile) {
        this.checks.all().stream().map(SonarXmlCheck.class::cast).forEach(check -> this.runCheck(context, (SonarXmlCheck)check, this.checks.ruleKey(check), newXmlFile));
    }

    void runCheck(SensorContext context, SonarXmlCheck check, RuleKey ruleKey, XmlFile newXmlFile) {
        try {
            check.scanFile(context, ruleKey, newXmlFile);
        }
        catch (Exception e) {
            XmlSensor.logFailingRule(ruleKey, newXmlFile.getInputFile().uri(), e);
        }
    }

    private static void logFailingRule(RuleKey rule, URI fileLocation, Exception e) {
        LOG.error(String.format("Unable to execute rule %s on %s", rule, fileLocation), (Throwable)e);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("xml").name("XML Sensor");
        this.processesFilesIndependently(descriptor);
    }

    private void processesFilesIndependently(SensorDescriptor descriptor) {
        if (this.sonarRuntime.getProduct() != SonarProduct.SONARQUBE || !this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)3))) {
            return;
        }
        try {
            Method method = descriptor.getClass().getMethod("processesFilesIndependently", new Class[0]);
            method.invoke((Object)descriptor, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LOG.warn("Could not call SensorDescriptor.processesFilesIndependently() method", (Throwable)e);
        }
    }

    private void processParseException(Exception e, SensorContext context, InputFile inputFile) {
        XmlSensor.reportAnalysisError(e, context, inputFile);
        LOG.warn(String.format("Unable to analyse file %s;", inputFile.uri()));
        LOG.debug("Cause: {}", (Object)e.getMessage());
        if (this.parsingErrorCheckEnabled) {
            XmlSensor.createParsingErrorIssue(e, context, inputFile);
        }
    }

    private static void reportAnalysisError(Exception e, SensorContext context, InputFile inputFile) {
        context.newAnalysisError().onFile(inputFile).message(e.getMessage()).save();
    }

    private static void createParsingErrorIssue(Exception e, SensorContext context, InputFile inputFile) {
        NewIssue newIssue = context.newIssue();
        NewIssueLocation primaryLocation = newIssue.newLocation().message("Parse error: " + e.getMessage()).on((InputComponent)inputFile);
        newIssue.forRule(PARSING_ERROR_RULE_KEY).at(primaryLocation).save();
    }
}

