/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.helpers;

import java.util.HashSet;
import java.util.Set;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.FinalState;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;
import org.sonarsource.analyzer.commons.regex.helpers.IntersectAutomataChecker;
import org.sonarsource.analyzer.commons.regex.helpers.SubAutomaton;
import org.sonarsource.analyzer.commons.regex.helpers.SupersetAutomataChecker;

public class RegexTreeHelper {
    private RegexTreeHelper() {
    }

    public static boolean intersects(SubAutomaton auto1, SubAutomaton auto2, boolean defaultAnswer) {
        return new IntersectAutomataChecker(defaultAnswer).check(auto1, auto2);
    }

    public static boolean supersetOf(SubAutomaton auto1, SubAutomaton auto2, boolean defaultAnswer) {
        return new SupersetAutomataChecker(defaultAnswer).check(auto1, auto2);
    }

    public static boolean isAnchoredAtEnd(AutomatonState start) {
        return RegexTreeHelper.isAnchoredAtEnd(start, new HashSet<AutomatonState>());
    }

    private static boolean isAnchoredAtEnd(AutomatonState start, Set<AutomatonState> visited) {
        if (RegexTreeHelper.isEndBoundary(start)) {
            return true;
        }
        if (start instanceof FinalState) {
            return false;
        }
        visited.add(start);
        for (AutomatonState automatonState : start.successors()) {
            if (visited.contains(automatonState) || RegexTreeHelper.isAnchoredAtEnd(automatonState, visited)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEndBoundary(AutomatonState state) {
        if (!(state instanceof BoundaryTree)) {
            return false;
        }
        switch (((BoundaryTree)state).type()) {
            case LINE_END: 
            case INPUT_END: 
            case INPUT_END_FINAL_TERMINATOR: {
                return true;
            }
        }
        return false;
    }

    public static boolean onlyMatchesEmptySuffix(AutomatonState start) {
        return RegexTreeHelper.onlyMatchesEmptySuffix(start, new HashSet<AutomatonState>());
    }

    private static boolean onlyMatchesEmptySuffix(AutomatonState start, Set<AutomatonState> visited) {
        if (start instanceof FinalState || visited.contains(start)) {
            return true;
        }
        visited.add(start);
        if (start instanceof LookAroundTree) {
            return RegexTreeHelper.onlyMatchesEmptySuffix(start.continuation(), visited);
        }
        if (start.incomingTransitionType() != AutomatonState.TransitionType.EPSILON) {
            return false;
        }
        for (AutomatonState automatonState : start.successors()) {
            if (RegexTreeHelper.onlyMatchesEmptySuffix(automatonState, visited)) continue;
            return false;
        }
        return true;
    }
}

