/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.YieldStatement;

@Rule(key="S2734")
public class InitReturnsValueCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_RETURN = "Remove this return value.";
    private static final String MESSAGE_YIELD = "Remove this yield statement.";
    public static final String CHECK_KEY = "S2734";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef func = (FunctionDef)ctx.syntaxNode();
            if (!"__init__".equals(func.name().name())) {
                return;
            }
            ReturnAndYieldVisitor returnAndYieldVisitor = new ReturnAndYieldVisitor();
            func.body().accept(returnAndYieldVisitor);
            for (Tree returnNode : returnAndYieldVisitor.returnNodes) {
                String message = returnNode.is(Tree.Kind.RETURN_STMT) ? MESSAGE_RETURN : MESSAGE_YIELD;
                ctx.addIssue(returnNode, message);
            }
        });
    }

    private static class ReturnAndYieldVisitor
    extends BaseTreeVisitor {
        List<Tree> returnNodes = new ArrayList<Tree>();

        private ReturnAndYieldVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        }

        @Override
        public void visitReturnStatement(ReturnStatement pyReturnStatementTree) {
            if (pyReturnStatementTree.expressions().isEmpty() || pyReturnStatementTree.expressions().get(0).is(Tree.Kind.NONE)) {
                return;
            }
            this.returnNodes.add(pyReturnStatementTree);
        }

        @Override
        public void visitYieldStatement(YieldStatement pyYieldStatementTree) {
            this.returnNodes.add(pyYieldStatementTree);
        }
    }
}

